/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.InvalidParameterValueException;
import org.eclipse.edt.gen.MissingParameterValueException;
import org.eclipse.edt.gen.PromptQueryException;
import org.eclipse.edt.gen.UnknownParameterException;

public abstract class CommandProcessor {
    private List<String> templatePath = new ArrayList<String>();
    private List<String> nativeTypePath = new ArrayList<String>();
    private List<String> primitiveTypePath = new ArrayList<String>();
    private List<String> messagePath = new ArrayList<String>();
    private Map<String, CommandParameter> parameterMapping = new HashMap<String, CommandParameter>();
    private Map<String, String> aliasMapping = new HashMap<String, String>();

    public boolean processBase(String[] args) {
        try {
            this.installOverrides(args, true);
            return true;
        }
        catch (PromptQueryException e) {
            System.out.println(e.getMessage());
            return false;
        }
        catch (UnknownParameterException e) {
            System.out.println("This parameter is unknown: " + e.getMessage());
            return false;
        }
        catch (MissingParameterValueException e) {
            System.out.println("This value for this parameter is missing: " + e.getMessage());
            return false;
        }
        catch (InvalidParameterValueException e) {
            System.out.println("This value for this parameter is incorrect: " + e.getMessage());
            return false;
        }
    }

    public boolean processUser(String[] args) {
        try {
            this.installOverrides(args, false);
            return true;
        }
        catch (PromptQueryException e) {
            System.out.println(e.getMessage());
            return false;
        }
        catch (UnknownParameterException e) {
            System.out.println("This parameter is unknown: " + e.getMessage());
            return false;
        }
        catch (MissingParameterValueException e) {
            System.out.println("This value for this parameter is missing: " + e.getMessage());
            return false;
        }
        catch (InvalidParameterValueException e) {
            System.out.println("This value for this parameter is incorrect: " + e.getMessage());
            return false;
        }
    }

    private void installOverrides(String[] args, boolean baseMode) throws PromptQueryException, UnknownParameterException, InvalidParameterValueException, MissingParameterValueException {
        CommandParameter parameter;
        if (baseMode) {
            this.templatePath.clear();
            this.nativeTypePath.clear();
            this.primitiveTypePath.clear();
            this.messagePath.clear();
            for (Map.Entry<String, CommandParameter> entry : this.parameterMapping.entrySet()) {
                parameter = entry.getValue();
                parameter.setValue(null);
            }
        }
        if (!baseMode) {
            String prompt = "";
            int i = 0;
            while (i < args.length) {
                CommandParameter parameter2;
                if (args[i].equals("?")) {
                    for (Map.Entry<String, CommandParameter> entry : this.parameterMapping.entrySet()) {
                        parameter2 = entry.getValue();
                        prompt = String.valueOf(prompt) + parameter2.getPromptText() + "\n";
                    }
                } else if (args[i].startsWith("?")) {
                    String alias = args[i].substring(1);
                    String internalName = this.getAlias(alias);
                    if (internalName == null) {
                        throw new UnknownParameterException(alias);
                    }
                    parameter2 = this.getParameter(internalName);
                    if (parameter2 == null) {
                        throw new UnknownParameterException(internalName);
                    }
                    prompt = String.valueOf(prompt) + parameter2.getPromptText() + "\n";
                }
                ++i;
            }
            if (prompt.length() > 0) {
                throw new PromptQueryException(prompt);
            }
        }
        int i = 0;
        while (i < args.length) {
            String alias;
            String internalName;
            if (args[i].startsWith("-") && ((internalName = this.getAlias(alias = args[i].substring(1))) != null || !baseMode)) {
                int n;
                Object[] objectArray;
                Object[] possibleValues;
                String value;
                if (internalName == null) {
                    throw new UnknownParameterException(alias);
                }
                CommandParameter parameter3 = this.getParameter(internalName);
                if (parameter3 == null) {
                    throw new UnknownParameterException(internalName);
                }
                if (parameter3.getPossibleValues() instanceof Boolean[]) {
                    boolean valid = false;
                    Boolean replacementValue = new Boolean(true);
                    value = "true";
                    if (i + 1 < args.length && !args[i + 1].startsWith("-") && !args[i + 1].startsWith("?")) {
                        value = args[i + 1];
                        ++i;
                    }
                    objectArray = possibleValues = parameter3.getPossibleValues();
                    int n2 = possibleValues.length;
                    n = 0;
                    while (n < n2) {
                        Object possibleValue = objectArray[n];
                        if (possibleValue instanceof Boolean) {
                            if (((Boolean)possibleValue).booleanValue() && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
                                valid = true;
                                replacementValue = new Boolean(true);
                            } else if (!((Boolean)possibleValue).booleanValue() && (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no"))) {
                                valid = true;
                                replacementValue = new Boolean(false);
                            }
                        }
                        ++n;
                    }
                    if (!valid) {
                        throw new InvalidParameterValueException(value);
                    }
                    parameter3.setValue(replacementValue);
                } else if (parameter3.getPossibleValues() instanceof String[]) {
                    boolean valid = false;
                    String replacementValue = "";
                    value = "";
                    if (i + 1 < args.length && !args[i + 1].startsWith("-") && !args[i + 1].startsWith("?")) {
                        value = args[i + 1];
                        ++i;
                    }
                    objectArray = possibleValues = parameter3.getPossibleValues();
                    int n3 = possibleValues.length;
                    n = 0;
                    while (n < n3) {
                        Object possibleValue = objectArray[n];
                        if (possibleValue == null) {
                            valid = true;
                            replacementValue = value;
                        } else if (possibleValue instanceof String && value.equalsIgnoreCase((String)possibleValue)) {
                            valid = true;
                            replacementValue = value;
                        }
                        ++n;
                    }
                    if (!valid) {
                        throw new InvalidParameterValueException(value);
                    }
                    parameter3.setValue(replacementValue);
                } else {
                    ArrayList<String> replacementValue = new ArrayList<String>();
                    while (i + 1 < args.length) {
                        Object[] possibleValues2;
                        if (args[i + 1].startsWith("-")) break;
                        boolean valid = false;
                        Object[] objectArray2 = possibleValues2 = parameter3.getPossibleValues();
                        n = possibleValues2.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Object possibleValue = objectArray2[n4];
                            if (possibleValue == null) {
                                valid = true;
                            } else if (possibleValue instanceof String && args[i + 1].equalsIgnoreCase((String)possibleValue)) {
                                valid = true;
                            }
                            ++n4;
                        }
                        if (!valid) {
                            throw new InvalidParameterValueException(args[i + 1]);
                        }
                        replacementValue.add(args[i + 1]);
                        ++i;
                    }
                    parameter3.setValue(replacementValue.toArray());
                }
            }
            ++i;
        }
        if (!baseMode) {
            for (Map.Entry<String, CommandParameter> entry : this.parameterMapping.entrySet()) {
                parameter = entry.getValue();
                if (!parameter.isRequired() || parameter.getValue() != null) continue;
                throw new MissingParameterValueException(entry.getKey());
            }
        }
    }

    public void installParameter(boolean required, String internalName, String[] aliases, Object[] possibleValues, String promptText) {
        if (this.getParameter(internalName) != null) {
            return;
        }
        CommandParameter parameter = new CommandParameter(required, possibleValues, possibleValues[0], promptText);
        this.parameterMapping.put(internalName, parameter);
        if (aliases != null) {
            String[] stringArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String alias = stringArray[n2];
                if (alias != null) {
                    if (this.getAlias(alias) != null) {
                        System.out.println("This alias already exists: " + alias + ". It has been ignored.");
                        return;
                    }
                    this.aliasMapping.put(alias.toLowerCase(), internalName);
                }
                ++n2;
            }
        }
    }

    private String getAlias(String aliasName) {
        return this.aliasMapping.get(aliasName.toLowerCase());
    }

    public CommandParameter getParameter(String internalName) {
        return this.parameterMapping.get(internalName);
    }

    public Map<String, CommandParameter> getParameterMapping() {
        return this.parameterMapping;
    }

    public List<String> getTemplatePath() {
        return this.templatePath;
    }

    public List<String> getNativeTypePath() {
        return this.nativeTypePath;
    }

    public List<String> getPrimitiveTypePath() {
        return this.primitiveTypePath;
    }

    public List<String> getMessagePath() {
        return this.messagePath;
    }
}

