/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.testserver;

import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.edt.ide.testserver.AbstractTestServerContribution;
import org.eclipse.edt.ide.testserver.TestServerPlugin;

public class TestServerIDEConnector {
    private static TestServerIDEConnector instance;
    private static int START_PORT_NUMBER;
    private static int portNumber;
    private static boolean running;
    private static final String EOL = "\r\n";
    private ServerSocket serverSocket;

    static {
        portNumber = START_PORT_NUMBER = 6590;
        running = true;
    }

    public static TestServerIDEConnector getInstance() {
        if (instance == null) {
            instance = new TestServerIDEConnector();
        }
        return instance;
    }

    private TestServerIDEConnector() {
        do {
            try {
                ++START_PORT_NUMBER;
                this.serverSocket = new ServerSocket(portNumber);
            }
            catch (Exception exception) {}
        } while (this.serverSocket == null);
        new Thread(){

            @Override
            public void run() {
                TestServerIDEConnector.this.startServer();
            }
        }.start();
    }

    public void startServer() {
        try {
            while (running) {
                Socket client = this.serverSocket.accept();
                this.handleBrowserEvent(client);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void handleBrowserEvent(Socket socket) {
        block18: {
            PrintStream ps = null;
            try {
                try {
                    ps = new PrintStream(socket.getOutputStream());
                    AbstractTestServerContribution[] abstractTestServerContributionArray = TestServerPlugin.getContributions();
                    int n = abstractTestServerContributionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractTestServerContribution contrib = abstractTestServerContributionArray[n2];
                        if (!contrib.handleServerRequest(socket, ps)) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    try {
                        this.fail(ps);
                    }
                    catch (Exception exception) {}
                    if (ps != null) {
                        try {
                            ps.flush();
                            ps.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (ps != null) {
                    try {
                        ps.flush();
                        ps.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (ps != null) {
                try {
                    ps.flush();
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int getPortNumber() {
        return portNumber;
    }

    public void fail(PrintStream ps) throws InterruptedException {
        ps.print(TestServerIDEConnector.getBadResponseHeader());
        ps.close();
    }

    public static String getBadResponseHeader() {
        return "HTTP/1.0 404 \r\nContent-Type: text/plain; charset=UTF-8\r\n\r\n";
    }

    public static String getGoodResponseHeader(String url, String contentType, boolean cache) {
        return TestServerIDEConnector.getResponseHeader(url, contentType, cache, 200, "OK");
    }

    public static String getResponseHeader(String url, String contentType, boolean cache, int status, String statusMsg) {
        return "HTTP/1.0 " + String.valueOf(status) + " " + statusMsg + EOL + "Content-Type: " + contentType + EOL + EOL;
    }
}

