/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.actions.AbstractOpenWizardWorkbenchAction;
import org.eclipse.edt.ide.ui.internal.wizards.ServiceBindingWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

public class OpenEGLServiceBindingWizardAction
extends AbstractOpenWizardWorkbenchAction {
    public OpenEGLServiceBindingWizardAction() {
    }

    public OpenEGLServiceBindingWizardAction(IWorkbench workbench, String label, Class[] activatedOnTypes, boolean acceptEmptySelection) {
        super(workbench, label, activatedOnTypes, acceptEmptySelection);
    }

    public OpenEGLServiceBindingWizardAction(IWorkbench workbench, String label, boolean acceptEmptySelection) {
        super(workbench, label, acceptEmptySelection);
    }

    @Override
    protected Wizard createWizard() {
        return new ServiceBindingWizard();
    }

    @Override
    public void run(IAction action) {
        if (EDTUIPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(true)) {
            super.run(action);
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        IEGLFile eglpartFile = null;
        if (selection instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof IFile) {
                IEGLElement eglElem = EGLCore.create((IFile)((IFile)selectedElement));
                if (eglElem instanceof IEGLFile) {
                    eglpartFile = (IEGLFile)eglElem;
                }
            } else if (selectedElement instanceof IEGLFile) {
                eglpartFile = (IEGLFile)selectedElement;
            }
            if (eglpartFile != null) {
                this.shouldEnableMenu(action, eglpartFile);
            }
        }
    }

    protected void shouldEnableMenu(IAction action, IEGLFile eglpartFile) {
        try {
            if (eglpartFile.exists()) {
                IPart[] allParts = eglpartFile.getAllParts();
                boolean bFndServicePart = false;
                int i = 0;
                while (i < allParts.length && !bFndServicePart) {
                    if (allParts[i] instanceof SourcePart) {
                        bFndServicePart = this.fndType((SourcePart)allParts[i], action);
                    }
                    ++i;
                }
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
    }

    protected boolean fndType(SourcePart part, IAction action) {
        if (part.isService()) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }
}

