/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.editor.EGLContentAssistInvocationContext;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposalCategory;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposalComparator;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposalComputerRegistry;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLParameterListValidator;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLTextMessages;
import org.eclipse.edt.ide.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.edt.ide.ui.internal.preferences.Messages;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;

public class EGLContentAssistProcessor
implements IContentAssistProcessor {
    private EGLCompletionProposalComparator comparator;
    private static final Comparator ORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            EGLCompletionProposalCategory d1 = (EGLCompletionProposalCategory)o1;
            EGLCompletionProposalCategory d2 = (EGLCompletionProposalCategory)o2;
            return d1.getSortOrder() - d2.getSortOrder();
        }
    };
    private static final String PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY = "EmptyDefaultAssistCategory";
    private IEditorPart editor;
    private IContextInformationValidator fValidator;
    private EGLCompletionProposalComputerRegistry fComputerRegistry;
    private final List fCategories;
    private final String fPartition;
    private final ContentAssistant fAssistant;
    private int fRepetition = -1;
    private List fCategoryIteration = null;
    private String fIterationGesture = null;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;

    public EGLContentAssistProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        this.editor = editor;
        this.fComputerRegistry = EGLCompletionProposalComputerRegistry.getDefault();
        this.fAssistant = assistant;
        this.fPartition = partition;
        this.fCategories = this.fComputerRegistry.getProposalCategories();
        this.fAssistant.addCompletionListener((ICompletionListener)new CompletionListener());
        this.comparator = new EGLCompletionProposalComparator();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(EGLTextMessages.ContentAssistProcessor_computing_proposals, this.fCategories.size() + 1);
        EGLContentAssistInvocationContext context = this.createContext(viewer, this.editor, documentOffset);
        monitor.subTask(EGLTextMessages.ContentAssistProcessor_collecting_proposals);
        List proposals = this.collectProposals(viewer, documentOffset, monitor, context);
        monitor.subTask(EGLTextMessages.ContentAssistProcessor_sorting_proposals);
        List filtered = this.filterAndSortProposals(proposals, monitor, context);
        this.fNumberOfComputedResults = filtered.size();
        ICompletionProposal[] result = filtered.toArray(new ICompletionProposal[filtered.size()]);
        monitor.done();
        return result;
    }

    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, EGLContentAssistInvocationContext context) {
        this.removeAllNullProposals(proposals);
        Collections.sort(proposals, this.comparator);
        return proposals;
    }

    private void removeAllNullProposals(List proposals) {
        ArrayList<Object> nullList = new ArrayList<Object>();
        nullList.add(null);
        proposals.removeAll(nullList);
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected EGLContentAssistInvocationContext createContext(ITextViewer viewer, IEditorPart aEditor, int offset) {
        return new EGLContentAssistInvocationContext(viewer, aEditor, offset);
    }

    private void clearState() {
        this.fErrorMessage = null;
        this.fNumberOfComputedResults = 0;
    }

    private List getCategories() {
        if (this.fCategoryIteration == null) {
            return this.fCategories;
        }
        int iteration = this.fRepetition % this.fCategoryIteration.size();
        this.fAssistant.setStatusMessage(this.createIterationMessage());
        this.fAssistant.setEmptyMessage(this.createEmptyMessage());
        ++this.fRepetition;
        return (List)this.fCategoryIteration.get(iteration);
    }

    private String createIterationMessage() {
        return Messages.format(EGLTextMessages.ContentAssistProcessor_toggle_affordance_update_message, new String[]{this.getCategoryLabel(this.fRepetition), this.fIterationGesture, this.getCategoryLabel(this.fRepetition + 1)});
    }

    private String getCategoryLabel(int repetition) {
        int iteration = repetition % this.fCategoryIteration.size();
        if (iteration == 0) {
            return EGLTextMessages.ContentAssistProcessor_defaultProposalCategory;
        }
        return this.toString((EGLCompletionProposalCategory)((List)this.fCategoryIteration.get(iteration)).get(0));
    }

    private String toString(EGLCompletionProposalCategory category) {
        return category.getDisplayName();
    }

    private String createEmptyMessage() {
        return Messages.format(EGLTextMessages.ContentAssistProcessor_empty_message, new String[]{this.getCategoryLabel(this.fRepetition)});
    }

    private List collectProposals(ITextViewer viewer, int offset, IProgressMonitor monitor, EGLContentAssistInvocationContext context) {
        ArrayList proposals = new ArrayList();
        List providers = this.getCategories();
        for (EGLCompletionProposalCategory cat : providers) {
            List computed = cat.computeCompletionProposals(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '@'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new EGLParameterListValidator();
        }
        return this.fValidator;
    }

    public String getErrorMessage() {
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        if (this.fNumberOfComputedResults > 0) {
            return null;
        }
        return EGLTextMessages.EGLEditor_codeassist_noCompletions;
    }

    private String getIterationGesture() {
        KeySequence binding = this.getIterationBinding();
        return binding != null ? Messages.format(EGLTextMessages.ContentAssistProcessor_toggle_affordance_press_gesture, new Object[]{binding.format()}) : EGLTextMessages.ContentAssistProcessor_toggle_affordance_click_gesture;
    }

    private KeySequence getIterationBinding() {
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence binding = bindingSvc.getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (binding instanceof KeySequence) {
            return (KeySequence)binding;
        }
        return null;
    }

    private void setCategoryIteration() {
        this.fCategoryIteration = this.getCategoryIteration();
    }

    private List getCategoryIteration() {
        ArrayList<List<EGLCompletionProposalCategory>> sequence = new ArrayList<List<EGLCompletionProposalCategory>>();
        sequence.add(this.getDefaultCategories());
        for (EGLCompletionProposalCategory cat : this.getSeparateCategories()) {
            sequence.add(Collections.singletonList(cat));
        }
        return sequence;
    }

    private List getSeparateCategories() {
        ArrayList<EGLCompletionProposalCategory> sorted = new ArrayList<EGLCompletionProposalCategory>();
        for (EGLCompletionProposalCategory category : this.fCategories) {
            if (!category.isSeparateCommand() || !category.hasComputers(this.fPartition)) continue;
            sorted.add(category);
        }
        Collections.sort(sorted, ORDER_COMPARATOR);
        return sorted;
    }

    private List getDefaultCategories() {
        List included = this.getDefaultCategoriesUnchecked();
        if (this.fComputerRegistry.hasUninstalledComputers(this.fPartition, included)) {
            if (this.informUserAboutEmptyDefaultCategory()) {
                included = this.getDefaultCategoriesUnchecked();
            }
            this.fComputerRegistry.resetUnistalledComputers();
        }
        return included;
    }

    private List getDefaultCategoriesUnchecked() {
        ArrayList<EGLCompletionProposalCategory> included = new ArrayList<EGLCompletionProposalCategory>();
        for (EGLCompletionProposalCategory category : this.fCategories) {
            if (!category.isIncluded() || !category.hasComputers(this.fPartition)) continue;
            included.add(category);
        }
        return included;
    }

    private boolean informUserAboutEmptyDefaultCategory() {
        String linkMessage;
        String restoreButtonLabel;
        String message;
        String title;
        Shell shell;
        OptionalMessageDialog dialog;
        int returnValue;
        if (OptionalMessageDialog.isDialogEnabled(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY) && (1034 == (returnValue = (dialog = new OptionalMessageDialog(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY, shell = EDTUIPlugin.getActiveWorkbenchShell(), title = EGLTextMessages.ContentAssistProcessor_all_disabled_title, null, message = EGLTextMessages.ContentAssistProcessor_all_disabled_message, 4, new String[]{restoreButtonLabel = JFaceResources.getString((String)"defaults"), IDialogConstants.CLOSE_LABEL}, 1, linkMessage = Messages.format(EGLTextMessages.ContentAssistProcessor_all_disabled_preference_link, LegacyActionTools.removeMnemonics((String)restoreButtonLabel)), restoreButtonLabel){
            private final /* synthetic */ String val$linkMessage;
            private final /* synthetic */ String val$restoreButtonLabel;
            {
                this.val$linkMessage = string;
                this.val$restoreButtonLabel = string2;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6, $anonymous7);
            }

            @Override
            protected Control createCustomArea(Composite composite) {
                Composite parent = new Composite(composite, 0);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.verticalSpacing = 0;
                parent.setLayout((Layout)layout);
                Composite linkComposite = new Composite(parent, 0);
                layout = new GridLayout();
                layout.marginHeight = this.convertVerticalDLUsToPixels(7);
                layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                linkComposite.setLayout((Layout)layout);
                Link link = new Link(linkComposite, 0);
                link.setText(this.val$linkMessage);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.setReturnCode(1035);
                        this.close();
                    }
                });
                GridData gridData = new GridData(4, 1, true, false);
                gridData.widthHint = this.getMinimumMessageWidth();
                link.setLayoutData((Object)gridData);
                super.createCustomArea(parent);
                return parent;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                Button[] buttons = new Button[]{this.createButton(parent, 1034, this.val$restoreButtonLabel, false), this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true)};
                this.setButtons(buttons);
            }
        }).open()) || 1035 == returnValue)) {
            if (1034 == returnValue) {
                IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
                store.setToDefault("content_assist_category_order");
                store.setToDefault("content_assist_disabled_categories");
            }
            if (1035 == returnValue) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.edt.ide.ui.preferences.CodeAssistPreferenceAdvanced", null, null).open();
            }
            this.fComputerRegistry.reload();
            return true;
        }
        return false;
    }

    private final class CompletionListener
    implements ICompletionListener,
    ICompletionListenerExtension {
        private CompletionListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            if (event.processor != EGLContentAssistProcessor.this) {
                return;
            }
            EGLContentAssistProcessor.this.fIterationGesture = EGLContentAssistProcessor.this.getIterationGesture();
            KeySequence binding = EGLContentAssistProcessor.this.getIterationBinding();
            EGLContentAssistProcessor.this.setCategoryIteration();
            for (EGLCompletionProposalCategory cat : EGLContentAssistProcessor.this.fCategories) {
                cat.sessionStarted();
            }
            EGLContentAssistProcessor.this.fRepetition = 0;
            if (event.assistant instanceof IContentAssistantExtension2) {
                IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                if (EGLContentAssistProcessor.this.fCategoryIteration.size() == 1) {
                    extension.setRepeatedInvocationMode(false);
                    extension.setShowEmptyList(false);
                } else {
                    extension.setRepeatedInvocationMode(true);
                    extension.setStatusLineVisible(true);
                    extension.setStatusMessage(EGLContentAssistProcessor.this.createIterationMessage());
                    extension.setShowEmptyList(true);
                    if (extension instanceof IContentAssistantExtension3) {
                        IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                        ((ContentAssistant)ext3).setRepeatedInvocationTrigger(binding);
                    }
                }
            }
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            if (event.processor != EGLContentAssistProcessor.this) {
                return;
            }
            for (EGLCompletionProposalCategory cat : EGLContentAssistProcessor.this.fCategories) {
                cat.sessionEnded();
            }
            EGLContentAssistProcessor.this.fCategoryIteration = null;
            EGLContentAssistProcessor.this.fRepetition = -1;
            EGLContentAssistProcessor.this.fIterationGesture = null;
            if (event.assistant instanceof IContentAssistantExtension2) {
                IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                extension.setShowEmptyList(false);
                extension.setRepeatedInvocationMode(false);
                extension.setStatusLineVisible(false);
                if (extension instanceof IContentAssistantExtension3) {
                    IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                    ((ContentAssistant)ext3).setRepeatedInvocationTrigger(null);
                }
            }
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }

        public void assistSessionRestarted(ContentAssistEvent event) {
            EGLContentAssistProcessor.this.fRepetition = 0;
        }
    }
}

