/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalcomputers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.ui.editor.EGLContentAssistInvocationContext;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposalComputer;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLContextBoundaryUtility;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLDefinedReferenceCompletions;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.IReferenceCompletion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class ReferenceProposalComputer
extends EGLCompletionProposalComputer {
    @Override
    public List computeCompletionProposals(EGLContentAssistInvocationContext context, IProgressMonitor monitor) {
        LinkedList result = new LinkedList();
        TokenStream tokenStream = new TokenStream(this.getPrefix(context.getViewer(), context.getInvocationOffset()));
        tokenStream.skipPrefix();
        ArrayList<ParseNode> prefixNodes = new ArrayList<ParseNode>();
        ParseStack parseStack = this.getParser().parse(tokenStream);
        prefixNodes.addAll(tokenStream.getPrefixNodes());
        parseStack.performAllReductions(99);
        IReferenceCompletion[] referenceCompletions = this.inNativeFunction(context) ? EGLDefinedReferenceCompletions.getNativeLibraryDefinedCompletions() : EGLDefinedReferenceCompletions.getDefinedCompletions();
        while (parseStack.availableContext() > 0) {
            int i = 0;
            while (i < referenceCompletions.length) {
                List completionProposals = referenceCompletions[i].computeCompletionProposals(parseStack, this.getPrefix(prefixNodes), context.getViewer(), context.getInvocationOffset(), context.getEditor());
                result.addAll(completionProposals);
                ++i;
            }
            List<ParseNode> deletedNodes = Arrays.asList(parseStack.deleteContext(1));
            prefixNodes.addAll(0, deletedNodes);
            if (result.size() > 0 || this.isAtContextBoundary(parseStack.getCurrentState())) break;
        }
        this.deleteDuplicated(result);
        return result;
    }

    private void deleteDuplicated(List result) {
        HashSet<String> calculatedList = new HashSet<String>();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object propObj = iterator.next();
            if (!(propObj instanceof ICompletionProposal)) continue;
            ICompletionProposal proposal = (ICompletionProposal)propObj;
            if (calculatedList.contains(proposal.getDisplayString())) {
                iterator.remove();
                continue;
            }
            calculatedList.add(((ICompletionProposal)propObj).getDisplayString());
        }
    }

    private boolean isAtContextBoundary(int parseState) {
        return EGLContextBoundaryUtility.getInstance().isBoundaryState(parseState);
    }

    @Override
    public List computeContextInformation(EGLContentAssistInvocationContext context, IProgressMonitor monitor) {
        return null;
    }
}

