/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.List;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLConditionalStateProposalHandler
extends EGLAbstractProposalHandler {
    public static final int ALL_STATE = 0;
    public static final int ITEM_STATE = 1;
    public static final int SQL_ITEM_STATE = 2;
    public static final int TEXT_FIELD_STATE = 3;
    public static final int WEB_ITEM_STATE = 4;
    public static final int IO_ERROR_STATE = 5;
    public static final int MODIFIED_STATE = 6;
    public static final int KEY_VALUE = 7;
    public static final int SYS_VALUE = 8;
    public static final String[] ITEM_STATE_STRINGS = new String[]{"blanks", "numeric"};
    public static final String[] SQL_ITEM_STATE_STRINGS = new String[]{"blanks", "numeric", "trunc"};
    public static final String[] TEXT_FIELD_STATE_STRINGS = new String[]{"blanks", "cursor", "data", "modified", "numeric"};
    public static final String[] WEB_ITEM_STATE_STRINGS = new String[]{"blanks", "modified", "numeric"};
    public static final String[] IO_ERROR_STATE_STRINGS = new String[]{"deadLock", "duplicate", "endOfFile", "fileNotAvailable", "fileNotFound", "full", "hardIoError", "invalidFormat", "ioError", "noRecordFound", "softIoError", "unique"};
    public static final String[] MODIFIED_STATE_STRINGS = new String[]{"modified"};
    public static final String[] KEY_VALUE1_STATE_STRINGS = new String[]{"bypass", "enter", "pakey", "pfkey"};
    public static final String[] KEY_VALUE2_STATE_STRINGS = new String[]{"pan", "pfn"};
    private boolean isQualified;
    private IDataBinding targetBinding;

    public EGLConditionalStateProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IDataBinding targetBinding) {
        super(viewer, documentOffset, prefix);
        this.targetBinding = targetBinding;
    }

    public List getProposals() {
        String[] availableStrings;
        String additionalInfo = "";
        switch (this.getType()) {
            case 1: {
                availableStrings = ITEM_STATE_STRINGS;
                additionalInfo = UINlsStrings.CAProposal_ItemState;
                break;
            }
            case 2: {
                availableStrings = SQL_ITEM_STATE_STRINGS;
                additionalInfo = UINlsStrings.CAProposal_SQLItemState;
                break;
            }
            case 3: {
                availableStrings = TEXT_FIELD_STATE_STRINGS;
                additionalInfo = UINlsStrings.CAProposal_TextFieldState;
                break;
            }
            case 4: {
                availableStrings = WEB_ITEM_STATE_STRINGS;
                additionalInfo = UINlsStrings.CAProposal_WebItemState;
                break;
            }
            case 5: {
                availableStrings = IO_ERROR_STATE_STRINGS;
                additionalInfo = UINlsStrings.CAProposal_IOErrorState;
                break;
            }
            case 6: {
                availableStrings = MODIFIED_STATE_STRINGS;
                additionalInfo = UINlsStrings.CAProposal_ModifiedState;
                break;
            }
            case 7: {
                String[] availableStrings2 = KEY_VALUE1_STATE_STRINGS;
                additionalInfo = UINlsStrings.CAProposal_KeyValue;
                List proposals = this.getProposals(availableStrings2, additionalInfo);
                availableStrings2 = KEY_VALUE2_STATE_STRINGS;
                proposals.addAll(this.getProposals(availableStrings2, additionalInfo, 50, 1, ""));
                return proposals;
            }
            default: {
                String[] strings = new String[]{"blanks", "cursor", "data", "numeric", "trunc"};
                additionalInfo = UINlsStrings.CAProposal_ItemState;
                List proposals = this.getProposals(strings, additionalInfo, 55, 0, "");
                strings = new String[]{"deadLock", "duplicate", "endOfFile", "fileNotFound", "full", "hardIoError", "invalidFormat", "ioError", "noRecordFound", "softIoError", "unique"};
                additionalInfo = UINlsStrings.CAProposal_IOErrorState;
                proposals.addAll(this.getProposals(strings, additionalInfo, 54, 0, ""));
                return proposals;
            }
        }
        return this.getProposals(availableStrings, additionalInfo);
    }

    private int getType() {
        if (this.targetBinding != null) {
            switch (this.targetBinding.getKind()) {
                case 8: {
                    return 6;
                }
                case 7: {
                    return 3;
                }
                case 5: 
                case 14: {
                    return 1;
                }
                case 0: {
                    if (!((FunctionParameterBinding)this.targetBinding).isField()) break;
                    return 3;
                }
            }
            ITypeBinding typeBinding = this.targetBinding.getType();
            if (typeBinding != null && IBinding.NOT_FOUND_BINDING != typeBinding && (6 == typeBinding.getKind() || 7 == typeBinding.getKind())) {
                return 5;
            }
        }
        return 0;
    }
}

