/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ElseBlock;
import org.eclipse.edt.compiler.core.ast.LabelStatement;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.OtherwiseClause;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.WhenClause;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLLabelPrecedingControlStatementProposalHandler
extends EGLAbstractProposalHandler {
    public EGLLabelPrecedingControlStatementProposalHandler(ITextViewer viewer, int documentOffset, String prefix) {
        super(viewer, documentOffset, prefix);
    }

    public List getProposals(Node boundNode, IncludeLabelForTester includeLabelTester, int relevance, String img_src) {
        ArrayList<String> labels = new ArrayList<String>();
        Node parent = boundNode.getParent();
        while (parent != null) {
            Node statementParent;
            List statementBlocks;
            Statement statement;
            if (parent instanceof Statement && includeLabelTester.includeLabelFor(statement = (Statement)parent) && (statementBlocks = this.getStatementBlocks(statementParent = statement.getParent())) != null) {
                Statement precedingStatement;
                int statementIndex = -1;
                List blockThatIncludesStatement = null;
                for (List nextBlock : statementBlocks) {
                    statementIndex = nextBlock.indexOf(statement);
                    if (statementIndex <= 0) continue;
                    blockThatIncludesStatement = nextBlock;
                    break;
                }
                if (statementIndex > 0 && (precedingStatement = (Statement)blockThatIncludesStatement.get(statementIndex - 1)) instanceof LabelStatement) {
                    labels.add(((LabelStatement)precedingStatement).getLabel());
                }
            }
            parent = parent.getParent();
        }
        return this.getProposals(labels.toArray(new String[0]), null, relevance, img_src);
    }

    private List getStatementBlocks(Node node) {
        Statement stmt;
        if (node instanceof Statement && (stmt = (Statement)node).canIncludeOtherStatements()) {
            return stmt.getStatementBlocks();
        }
        if (node instanceof WhenClause) {
            return Arrays.asList(((WhenClause)node).getStmts());
        }
        if (node instanceof OtherwiseClause) {
            return Arrays.asList(((OtherwiseClause)node).getStatements());
        }
        if (node instanceof ElseBlock) {
            return Arrays.asList(((ElseBlock)node).getStmts());
        }
        if (node instanceof OnExceptionBlock) {
            return Arrays.asList(((OnExceptionBlock)node).getStmts());
        }
        if (node instanceof NestedFunction) {
            return Arrays.asList(((NestedFunction)node).getStmts());
        }
        if (node instanceof TopLevelFunction) {
            return Arrays.asList(((TopLevelFunction)node).getStmts());
        }
        return null;
    }

    public static interface IncludeLabelForTester {
        public boolean includeLabelFor(Statement var1);
    }
}

