/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBindingImpl;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLNewSettingsBlockProposalHandler
extends EGLAbstractProposalHandler {
    public EGLNewSettingsBlockProposalHandler(ITextViewer viewer, int documentOffset, String prefix) {
        super(viewer, documentOffset, prefix, null);
    }

    public List getProposals(List propertyBlockList, Name name) {
        ArrayList proposals = new ArrayList();
        IBinding binding = name.resolveBinding();
        if (binding instanceof FlexibleRecordBindingImpl) {
            return this.getFlexibleRecordProposals((FlexibleRecordBindingImpl)binding, propertyBlockList);
        }
        if (binding instanceof ExternalTypeBinding) {
            return this.getExternalTypeProposals((ExternalTypeBinding)binding, propertyBlockList);
        }
        return proposals;
    }

    private List getFlexibleRecordProposals(FlexibleRecordBindingImpl flexibleRecordBindingImpl, List propertyBlockList) {
        ArrayList proposals = new ArrayList();
        IDataBinding[] fields = flexibleRecordBindingImpl.getFields();
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                IDataBinding field = fields[i];
                proposals.addAll(this.createProposals(field, propertyBlockList));
                ++i;
            }
        }
        return proposals;
    }

    private List getExternalTypeProposals(ExternalTypeBinding externalTypeBinding, List propertyBlockList) {
        ArrayList proposals = new ArrayList();
        List fields = externalTypeBinding.getDeclaredData();
        if (fields != null) {
            int i = 0;
            while (i < fields.size()) {
                IDataBinding field = (IDataBinding)fields.get(i);
                proposals.addAll(this.createProposals(field, propertyBlockList));
                ++i;
            }
        }
        return proposals;
    }

    public List createProposals(IDataBinding field, List propertyBlockList) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        String displayString = field.getCaseSensitiveName();
        String proposalString = String.valueOf(displayString) + " = ";
        if (displayString.toUpperCase().startsWith(this.getPrefix().toUpperCase()) && !this.containsProperty(displayString, propertyBlockList)) {
            proposals.add(this.createProposal(this.viewer, displayString, proposalString, this.getPrefix(), field.getType().getCaseSensitiveName(), this.getDocumentOffset(), proposalString.length(), 0));
            return proposals;
        }
        return Collections.EMPTY_LIST;
    }

    public EGLCompletionProposal createProposal(ITextViewer viewer, String displayString, String proposalString, String prefix, String additionalInfo, int documentOffset, int cursorPosition, int postSelectionLength) {
        return new EGLCompletionProposal(viewer, displayString, proposalString, additionalInfo, documentOffset - prefix.length(), prefix.length(), cursorPosition, 50, postSelectionLength, "org.eclipse.edt.ide.ui.envvar_obj.gif");
    }
}

