/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.ide.ui.internal.util.CapabilityFilterUtility;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class EGLSystemLibraryProposalHandler
extends EGLAbstractProposalHandler {
    private static Map libraryNamesToStringConstants;

    public EGLSystemLibraryProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor) {
        super(viewer, documentOffset, prefix, editor);
    }

    public List getProposals() {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        ArrayList<String[]> primitiveStrings = new ArrayList<String[]>();
        IFileEditorInput editorInput = (IFileEditorInput)this.editor.getEditorInput();
        ISystemEnvironment env = SystemEnvironmentManager.findSystemEnvironment((IProject)editorInput.getFile().getProject(), null);
        LinkedList contentAssistPartList = new LinkedList();
        contentAssistPartList.addAll(env.getSystemLibraryManager().getLibraries().values());
        contentAssistPartList.addAll(env.getContentAssistPartsManager().getExternalTypeLibraries().values());
        for (IPartBinding nextLibrary : CapabilityFilterUtility.filterParts(contentAssistPartList)) {
            String systemLibraryName = (String)EGLSystemLibraryProposalHandler.getLibraryNamesToStringConstants().get(nextLibrary.getName().toLowerCase());
            if (systemLibraryName == null) {
                systemLibraryName = UINlsStrings.CAProposal_EGLSystemLibrary;
            }
            primitiveStrings.add(new String[]{nextLibrary.getCaseSensitiveName(), systemLibraryName});
        }
        int i = 0;
        while (i < primitiveStrings.size()) {
            String[] primitiveString = (String[])primitiveStrings.get(i);
            if (primitiveString[0].toUpperCase().startsWith(this.getPrefix().toUpperCase())) {
                proposals.add(new EGLCompletionProposal(this.viewer, primitiveString[0], String.valueOf(primitiveString[0]) + ".", primitiveString[1], this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), primitiveString[0].length() + 1, 35, "org.eclipse.edt.ide.ui.libry_obj.gif"));
            }
            ++i;
        }
        return proposals;
    }

    public static Map getLibraryNamesToStringConstants() {
        if (libraryNamesToStringConstants == null) {
            libraryNamesToStringConstants = new HashMap();
            libraryNamesToStringConstants.put("dateTimeLib".toLowerCase(), UINlsStrings.CAProposal_DataTimeLibrary);
            libraryNamesToStringConstants.put("mathLib".toLowerCase(), UINlsStrings.CAProposal_MathLibrary);
            libraryNamesToStringConstants.put("sqlLib".toLowerCase(), UINlsStrings.CAProposal_SQLLibrary);
            libraryNamesToStringConstants.put("strLib".toLowerCase(), UINlsStrings.CAProposal_StringLibrary);
            libraryNamesToStringConstants.put("sysLib".toLowerCase(), UINlsStrings.CAProposal_SystemLibrary);
            libraryNamesToStringConstants.put("sysVar".toLowerCase(), UINlsStrings.CAProposal_SystemVarLibrary);
            libraryNamesToStringConstants.put("serviceLib".toLowerCase(), UINlsStrings.CAProposal_ServiceLibrary);
            libraryNamesToStringConstants.put("httpLib".toLowerCase(), UINlsStrings.CAProposal_HttpLibrary);
            libraryNamesToStringConstants.put("stringLib".toLowerCase(), UINlsStrings.CAProposal_StringLibrary);
            libraryNamesToStringConstants.put("ruiLib".toLowerCase(), UINlsStrings.CAProposal_RuiLibrary);
            libraryNamesToStringConstants.put("jsonLib".toLowerCase(), UINlsStrings.CAProposal_JsonLibrary);
            libraryNamesToStringConstants.put("xmlLib".toLowerCase(), UINlsStrings.CAProposal_XmlLibrary);
        }
        return libraryNamesToStringConstants;
    }
}

