/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfoRequestor;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.search.IPartNameRequestor;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLUseStatementProposalHandler
extends EGLAbstractProposalHandler {
    public EGLUseStatementProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor) {
        super(viewer, documentOffset, prefix, editor);
    }

    public List getProposals() {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        int partTypes = this.getTypes(this.getDocumentOffset(), this.getViewer());
        if (partTypes == 0) {
            return proposals;
        }
        ArrayList types = new ArrayList();
        try {
            new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), null, this.getPrefix().toCharArray(), 1, false, partTypes, this.createProjectSearchScope(), (IPartNameRequestor)new PartInfoRequestor(types), 3, null);
        }
        catch (EGLModelException e) {
            EGLLogger.log((Object)this, e);
        }
        for (PartDeclarationInfo part : types) {
            String partTypeName;
            if (!this.canBeUsedByActivePart(part)) continue;
            switch (part.getPartType()) {
                case '\u0004': {
                    partTypeName = "dataTable";
                    break;
                }
                case '@': {
                    partTypeName = "formGroup";
                    break;
                }
                case '\u0100': {
                    partTypeName = "library";
                    break;
                }
                case ' ': {
                    partTypeName = "form";
                    break;
                }
                case '\u0200': {
                    partTypeName = "handler";
                    break;
                }
                default: {
                    partTypeName = "";
                }
            }
            proposals.add(this.createPartProposal(part, partTypeName));
        }
        return proposals;
    }

    private boolean canBeUsedByActivePart(PartDeclarationInfo partDeclareInfo) {
        IEGLDocument document = (IEGLDocument)this.viewer.getDocument();
        if (((EGLDocument)document).getNewModelEGLFile().getPackageDeclaration() == null) {
            return true;
        }
        return partDeclareInfo.getPackageName() != null && partDeclareInfo.getPackageName().length() > 0;
    }

    private int getTypes(int documentOffset, ITextViewer viewer) {
        IEGLDocument document = (IEGLDocument)viewer.getDocument();
        final int[] result = new int[1];
        Part eglPart = EGLModelUtility.getPartNode(document, documentOffset);
        eglPart.accept((IASTVisitor)new DefaultASTVisitor(){

            public void endVisit(Program program) {
                result[0] = 324;
            }

            public void endVisit(Library library) {
                result[0] = 324;
            }

            public void endVisit(Handler handler) {
                result[0] = 260;
            }

            public void endVisit(Service service) {
                result[0] = 260;
            }

            public void endVisit(FormGroup formGroup) {
                result[0] = 32;
            }
        });
        return result[0];
    }
}

