/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLConditionalStateProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLDeclarationProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLFunctionPartSearchProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLSystemLibraryProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLSystemWordProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.jface.text.ITextViewer;

public class EGLCaseStatementReferenceCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; function a() case (");
        this.addContext("package a; function a() case (a) when (");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList proposals = new ArrayList();
        this.getBoundASTNode(viewer, documentOffset, new String[]{"", "x", "x) end", "x)"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                while (astNode != null) {
                    if (astNode instanceof CaseStatement) {
                        return true;
                    }
                    astNode = astNode.getParent();
                }
                return false;
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                IDataBinding statementTargetBinding = EGLCaseStatementReferenceCompletion.this.getStatementTargetBinding(boundNode);
                if (statementTargetBinding != null && IBinding.NOT_FOUND_BINDING != statementTargetBinding && AbstractBinder.dataBindingIs((IDataBinding)statementTargetBinding, (String[])EGLCORE, (String)"sysVar", (String)"systemType")) {
                    proposals.addAll(new EGLConditionalStateProposalHandler(viewer, documentOffset, prefix, statementTargetBinding).getProposals());
                    return;
                }
                proposals.addAll(new EGLDeclarationProposalHandler(viewer, documentOffset, prefix, boundNode).getProposals(boundNode));
                proposals.addAll(new EGLSystemWordProposalHandler(viewer, documentOffset, prefix, EGLCaseStatementReferenceCompletion.this.editor, boundNode).getProposals(EGLSystemWordProposalHandler.RETURNS, true));
                proposals.addAll(new EGLFunctionPartSearchProposalHandler(viewer, documentOffset, prefix, EGLCaseStatementReferenceCompletion.this.editor, true, boundNode).getProposals());
                proposals.addAll(new EGLSystemLibraryProposalHandler(viewer, documentOffset, prefix, EGLCaseStatementReferenceCompletion.this.editor).getProposals());
            }
        });
        return proposals;
    }

    private IDataBinding getStatementTargetBinding(Node boundNode) {
        while (boundNode != null) {
            CaseStatement caseStatement;
            if (boundNode instanceof CaseStatement && (caseStatement = (CaseStatement)boundNode).hasCriterion()) {
                return caseStatement.getCriterion().resolveDataBinding();
            }
            boundNode = boundNode.getParent();
        }
        return null;
    }
}

