/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.EnumerationDataBinding;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.internal.EGLNewPropertiesHandler;
import org.eclipse.edt.compiler.internal.EGLPropertyRule;
import org.eclipse.edt.compiler.internal.core.lookup.Enumerations.ElementKind;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.edt.ide.ui.internal.util.CapabilityFilterUtility;
import org.eclipse.jface.text.ITextViewer;

public class EGLSubtypeReferenceCompletion
extends EGLAbstractReferenceCompletion {
    String additionalInfoText = "";

    @Override
    protected void precompileContexts() {
        this.addContext("package a; record a type");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, String prefix, ITextViewer viewer, int documentOffset) {
        EDTCoreIDEPlugin.getPlugin();
        ArrayList<EGLCompletionProposal> result = new ArrayList<EGLCompletionProposal>();
        List subTypes = this.getSubtypes(viewer, documentOffset);
        if (subTypes != null) {
            int prefixLength = prefix.length();
            int i = 0;
            while (i < subTypes.size()) {
                if (((String)subTypes.get(i)).toUpperCase().startsWith(prefix.toUpperCase())) {
                    result.add(new EGLCompletionProposal(viewer, null, (String)subTypes.get(i), this.additionalInfoText, documentOffset - prefixLength, prefixLength, ((String)subTypes.get(i)).length(), ""));
                }
                ++i;
            }
        }
        return result;
    }

    private List getSubtypes(final ITextViewer viewer, final int documentOffset) {
        Node eglPart = this.getPart(viewer, documentOffset);
        if (eglPart == null) {
            return null;
        }
        final ArrayList elementKinds = new ArrayList();
        eglPart.accept((IASTVisitor)new DefaultASTVisitor(){

            public void endVisit(Record record) {
                EGLSubtypeReferenceCompletion.this.additionalInfoText = UINlsStrings.CAProposal_RecordType;
                elementKinds.add(ElementKind.RECORDPART);
                elementKinds.add(ElementKind.STRUCTUREDRECORDPART);
                elementKinds.add(ElementKind.VGUIRECORDPART);
            }

            public void endVisit(DataTable table) {
                EGLSubtypeReferenceCompletion.this.additionalInfoText = UINlsStrings.CAProposal_TableType;
                elementKinds.add(ElementKind.DATATABLEPART);
            }

            public void endVisit(Library library) {
                EGLSubtypeReferenceCompletion.this.additionalInfoText = UINlsStrings.CAProposal_LibraryType;
                elementKinds.add(ElementKind.LIBRARYPART);
            }

            public void endVisit(Handler handler) {
                EGLSubtypeReferenceCompletion.this.additionalInfoText = UINlsStrings.CAProposal_HandlerType;
                elementKinds.add(ElementKind.HANDLERPART);
            }

            public void endVisit(TopLevelForm form) {
                EGLSubtypeReferenceCompletion.this.additionalInfoText = UINlsStrings.CAProposal_FormType;
                elementKinds.add(ElementKind.FORMPART);
            }

            public void endVisit(Interface iFace) {
                EGLSubtypeReferenceCompletion.this.additionalInfoText = UINlsStrings.CAProposal_InterfaceType;
                elementKinds.add(ElementKind.INTERFACEPART);
            }

            public void endVisit(ExternalType externalType) {
                EGLSubtypeReferenceCompletion.this.additionalInfoText = UINlsStrings.CAProposal_ExternalTypeType;
                elementKinds.add(ElementKind.EXTERNALTYPEPART);
            }

            public void endVisit(FormGroup fGroup) {
                Node nestedPart = EGLSubtypeReferenceCompletion.this.getNestedPart(viewer, documentOffset);
                nestedPart.accept((IASTVisitor)new DefaultASTVisitor(){

                    public void endVisit(NestedForm nestedForm) {
                        (this).EGLSubtypeReferenceCompletion.this.additionalInfoText = UINlsStrings.CAProposal_FormType;
                        elementKinds.add(ElementKind.FORMPART);
                    }
                });
            }
        });
        Collection rules = CapabilityFilterUtility.filterPropertyRules(EGLNewPropertiesHandler.createRulesForSubtypes((EnumerationDataBinding[])elementKinds.toArray(new EnumerationDataBinding[0])));
        ArrayList<String> subTypes = new ArrayList<String>();
        Iterator iter = rules.iterator();
        while (iter.hasNext()) {
            subTypes.add(((EGLPropertyRule)iter.next()).getName());
        }
        return subTypes;
    }
}

