/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.builder.AccumulatingProblemrRequestor;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RenameDialog
extends InputDialog {
    int nColumns = 4;
    boolean elementNamesEqual = false;
    private StatusInfo fElementStatus;
    private IEGLElement initialElement;

    public RenameDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initInputString, IEGLElement initialElement) {
        super(parentShell, dialogTitle, dialogMessage, initInputString, null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, IUIHelpConstants.EGL_RENAME_DIALOG);
        this.initialElement = initialElement;
        this.fElementStatus = new StatusInfo();
    }

    public static String getInitElementNameToShow(IEGLElement initialElement) {
        String nameToShow = initialElement.getElementName();
        if (initialElement instanceof IEGLFile) {
            nameToShow = initialElement.getElementName().indexOf(46) != -1 ? initialElement.getElementName().substring(0, initialElement.getElementName().indexOf(46)) : initialElement.getElementName();
        }
        return nameToShow;
    }

    protected void validateInput() {
        String errorMessage = null;
        this.fElementStatus.setOK();
        String elementName = this.getText().getText();
        if (elementName.length() > 0) {
            AccumulatingProblemrRequestor pRequstor = new AccumulatingProblemrRequestor();
            ArrayList validationList = pRequstor.getProblems();
            ICompilerOptions compilerOptions = new ICompilerOptions(){

                public boolean isVAGCompatible() {
                    return false;
                }

                public boolean isAliasJSFNames() {
                    return false;
                }
            };
            this.elementNamesEqual = this.initialElement.getElementType() == 6 && this.initialElement.getElementName().equals(String.valueOf(elementName) + ".egl") || elementName.equals(this.initialElement.getElementName());
            switch (this.initialElement.getElementType()) {
                case 6: {
                    if (elementName.indexOf(46) != -1) {
                        this.fElementStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
                        validationList = new ArrayList();
                        break;
                    }
                    EGLNameValidator.validate((String)elementName, (int)31, (IProblemRequestor)pRequstor, (ICompilerOptions)compilerOptions);
                    break;
                }
                case 4: {
                    EGLNameValidator.validate((String)elementName, (int)30, (IProblemRequestor)pRequstor, (ICompilerOptions)compilerOptions);
                    break;
                }
                case 3: {
                    EGLNameValidator.validate((String)elementName, (int)30, (IProblemRequestor)pRequstor, (ICompilerOptions)compilerOptions);
                    break;
                }
                default: {
                    EGLNameValidator.validate((String)elementName, (int)0, (IProblemRequestor)pRequstor, (ICompilerOptions)compilerOptions);
                }
            }
            if (!validationList.isEmpty()) {
                int currentSeverity = -1;
                Problem problem = null;
                int i = 0;
                while (i < validationList.size()) {
                    if (((Problem)validationList.get(i)).getSeverity() == 2) {
                        currentSeverity = 2;
                        problem = (Problem)validationList.get(i);
                        break;
                    }
                    if (((Problem)validationList.get(i)).getSeverity() == 1 && (currentSeverity == 0 || currentSeverity == -1)) {
                        currentSeverity = 1;
                        problem = (Problem)validationList.get(i);
                    } else if (((Problem)validationList.get(i)).getSeverity() == 0 && currentSeverity == -1) {
                        currentSeverity = 0;
                        problem = (Problem)validationList.get(i);
                    }
                    ++i;
                }
                if (problem != null) {
                    String messageFromBundle = DefaultProblemRequestor.getMessageFromBundle((int)problem.getProblemKind(), (String[])problem.getInserts());
                    if (currentSeverity == 2) {
                        this.fElementStatus.setError(messageFromBundle);
                    } else if (currentSeverity == 1) {
                        this.fElementStatus.setWarning(messageFromBundle);
                    } else if (currentSeverity == 0) {
                        this.fElementStatus.setInfo(messageFromBundle);
                    }
                }
            }
            IEGLProject project = this.initialElement.getEGLProject();
            IPackageFragmentRoot root = (IPackageFragmentRoot)this.initialElement.getAncestor(3);
            if (root != null) {
                try {
                    switch (this.initialElement.getElementType()) {
                        case 4: {
                            IPackageFragment pack = root.getPackageFragment(elementName);
                            IPath rootPath = root.getPath();
                            IPath outputPath = root.getEGLProject().getOutputLocation();
                            if (!rootPath.equals((Object)outputPath)) {
                                IPath packagePath = pack.getPath();
                                if (outputPath.isPrefixOf(packagePath)) {
                                    this.fElementStatus.setError(NewWizardMessages.NewPackageWizardPageErrorIsOutputFolder);
                                    break;
                                }
                                if (pack.exists()) {
                                    if (pack.containsEGLResources() || !pack.hasSubpackages()) {
                                        this.fElementStatus.setError(NewWizardMessages.NewPackageWizardPageErrorPackageExists);
                                        break;
                                    }
                                    this.fElementStatus.setError(NewWizardMessages.NewPackageWizardPageWarningPackageNotShown);
                                }
                            }
                            break;
                        }
                        case 6: {
                            IEGLFile cu;
                            IPackageFragment filepack = (IPackageFragment)this.initialElement.getParent();
                            if (filepack != null && (cu = filepack.getEGLFile(String.valueOf(elementName) + ".egl")).getResource().exists()) {
                                this.fElementStatus.setError(NewWizardMessages.NewTypeWizardPageErrorTypeNameExists);
                            }
                            break;
                        }
                        case 3: {
                            IPath newrootpath = root.getPath().removeLastSegments(1).append(elementName);
                            IPackageFragmentRoot newroot = project.findPackageFragmentRoot(newrootpath.makeAbsolute());
                            if (newroot == null || !newroot.getResource().exists()) break;
                            this.fElementStatus.setError(NewWizardMessages.NewSourceFolderWizardPageErrorAlreadyExisting);
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (EGLModelException e) {
                    EGLLogger.log((Object)this, e);
                }
            }
        } else {
            this.fElementStatus.setError(NewWizardMessages.NewPackageWizardPageErrorEmptyName);
        }
        if (this.fElementStatus.getSeverity() == 4) {
            errorMessage = this.fElementStatus.getMessage();
        }
        this.setErrorMessage(errorMessage == null ? "" : errorMessage);
        this.getOkButton().setEnabled(errorMessage == null && !this.elementNamesEqual);
    }
}

