/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import org.eclipse.edt.ide.ui.internal.editor.AbstractAutoIndentStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

public class AutoIndentStrategy
extends AbstractAutoIndentStrategy {
    protected String END_BLOCK = "end";
    protected String ELSE_BLOCK = "else";
    protected String ON_EXCEPTION_BLOCK = "onException";
    protected String TRY_BLOCK = "try";
    protected String OTHERWISE_BLOCK = "otherwise";

    @Override
    protected boolean appendTab(IDocument d, DocumentCommand c) throws BadLocationException {
        if (d.get(c.offset - 1, 1).equals(")")) {
            return true;
        }
        if (this.isMatch(d, c, this.ELSE_BLOCK)) {
            return true;
        }
        if (this.isMatch(d, c, this.TRY_BLOCK)) {
            return true;
        }
        if (this.isMatch(d, c, this.ON_EXCEPTION_BLOCK)) {
            return true;
        }
        return this.isMatch(d, c, this.OTHERWISE_BLOCK);
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.endsWithDelimiter(d, c.text)) {
            this.autoIndentAfterNewLine(d, c);
        } else if (this.endsWith(d, c, this.END_BLOCK)) {
            this.smartInsertAfterBlock(d, c, this.END_BLOCK.length() - 1);
        } else if (this.endsWith(d, c, this.ELSE_BLOCK)) {
            this.smartInsertAfterBlock(d, c, this.ELSE_BLOCK.length() - 1);
        } else if (this.endsWith(d, c, this.OTHERWISE_BLOCK)) {
            this.smartInsertAfterBlock(d, c, this.OTHERWISE_BLOCK.length() - 1);
        } else if (this.endsWith(d, c, this.ON_EXCEPTION_BLOCK)) {
            this.smartInsertAfterBlock(d, c, this.ON_EXCEPTION_BLOCK.length() - 1);
        }
    }
}

