/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragment;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.editor.BinaryReadOnlyFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;

public class BinaryEditorInput
implements IStorageEditorInput {
    private BinaryReadOnlyFile binaryReadOnlyFile;
    private IClassFile classFile;

    public BinaryEditorInput(BinaryReadOnlyFile binaryReadOnlyFile) {
        this.binaryReadOnlyFile = binaryReadOnlyFile;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.binaryReadOnlyFile.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() {
        return this.binaryReadOnlyFile;
    }

    public String getToolTipText() {
        return "file: " + this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setClassFile(IClassFile classFile) {
        this.classFile = classFile;
    }

    public IClassFile getClassFile() {
        if (this.classFile != null) {
            return this.classFile;
        }
        IProject proj = null;
        proj = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(this.binaryReadOnlyFile.getProject());
        if (proj == null) {
            return null;
        }
        IEGLProject eglProj = EGLCore.create((IProject)proj);
        try {
            IPackageFragmentRoot myRoot = eglProj.getPackageFragmentRoot(this.binaryReadOnlyFile.getEGLARPath());
            if (myRoot instanceof EglarPackageFragmentRoot && myRoot.exists()) {
                EglarPackageFragmentRoot packageFragmentRoot = (EglarPackageFragmentRoot)myRoot;
                String pkg = this.binaryReadOnlyFile.getPackage();
                StringTokenizer token = new StringTokenizer(pkg, ".");
                String[] pkgName = new String[token.countTokens()];
                int i = 0;
                while (token.hasMoreTokens()) {
                    pkgName[i++] = token.nextToken().toLowerCase();
                }
                EglarPackageFragment packageFragment = (EglarPackageFragment)packageFragmentRoot.getPackageFragment(pkgName);
                if (packageFragment != null && packageFragment.exists()) {
                    this.classFile = packageFragment.getClassFile(this.binaryReadOnlyFile.getName().toLowerCase());
                }
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return this.classFile;
    }

    public String getFullPath() {
        return this.binaryReadOnlyFile.getFullPath().toString();
    }

    public String getProject() {
        return this.binaryReadOnlyFile.getProject();
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryEditorInput) {
            return this.getFullPath().equals(((BinaryEditorInput)o).getFullPath()) && this.getProject().equals(((BinaryEditorInput)o).getProject());
        }
        return super.equals(o);
    }
}

