/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IOpenable;
import org.eclipse.edt.ide.core.model.IProblemRequestor;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.DocumentAdapter;
import org.eclipse.edt.ide.ui.internal.editor.EGLMarkerAnnotationModel;
import org.eclipse.edt.ide.ui.internal.editor.Partitioner;
import org.eclipse.edt.ide.ui.internal.editor.TextTools;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class DocumentProvider
extends FileDocumentProvider {
    private IBufferFactory fBufferFactory = new BufferFactory();
    private boolean fIsAboutToSave = false;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;
    private TextTools tools = new TextTools(EDTUIPlugin.getDefault().getPreferenceStore());

    public DocumentProvider() {
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = null;
        document = super.createDocument(element);
        if (document != null) {
            IDocumentPartitioner partitioner = this.createDocumentPartitioner();
            document.setDocumentPartitioner(partitioner);
            partitioner.connect(document);
        }
        return document;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (!(element instanceof IFileEditorInput)) {
            return super.createElementInfo(element);
        }
        IFileEditorInput input = (IFileEditorInput)element;
        IEGLFile original = this.createEGLFile(input.getFile());
        if (original != null) {
            try {
                try {
                    this.refreshFile(input.getFile());
                }
                catch (CoreException x) {
                    this.handleCoreException(x, "CoreException - DocumentProvider.createElementInfo()");
                }
                IAnnotationModel m = this.createAnnotationModel(input);
                IProblemRequestor r = m instanceof IProblemRequestor ? (IProblemRequestor)m : null;
                IEGLFile c = (IEGLFile)original.getSharedWorkingCopy(this.getProgressMonitor(), this.fBufferFactory, r);
                DocumentAdapter a = null;
                try {
                    a = (DocumentAdapter)c.getBuffer();
                }
                catch (ClassCastException x) {
                    Status status = new Status(4, "org.eclipse.edt.ide.core", 3, "Shared working copy has wrong buffer", (Throwable)x);
                    throw new CoreException((IStatus)status);
                }
                _FileSynchronizer f = new _FileSynchronizer(input);
                f.install();
                EGLFileInfo info = new EGLFileInfo(a.getDocument(), m, f, c);
                info.setModificationStamp(this.computeModificationStamp((IResource)input.getFile()));
                info.fStatus = a.getStatus();
                info.fEncoding = this.getPersistedEncoding(input);
                m.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
                return info;
            }
            catch (EGLModelException x) {
                throw new CoreException(x.getStatus());
            }
        }
        return super.createElementInfo(element);
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.addListener(listener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.removeListener(listener);
    }

    boolean isConnected(Object element) {
        return this.getElementInfo(element) != null;
    }

    public IResource getUnderlyingResource(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return input.getFile();
        }
        return null;
    }

    protected IEGLFile createEGLFile(IFile file) {
        IEGLElement element = EGLCore.create((IFile)file);
        if (element instanceof IEGLFile) {
            return (IEGLFile)element;
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return new EGLMarkerAnnotationModel((IResource)input.getFile());
        }
        return super.createAnnotationModel(element);
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        String[] types = new String[]{"__dftl_partition_content_type", "__egl_multiline_comment", "__egl_singleline_comment", "__egl_sql", "__egl_sqlCondition"};
        return new Partitioner((IPartitionTokenScanner)this.tools.getEGLPartitionScanner(), types);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof EGLFileInfo) {
            EGLFileInfo eglInfo = (EGLFileInfo)info;
            eglInfo.fCopy.destroy();
            eglInfo.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        super.disposeElementInfo(element, info);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof EGLFileInfo) {
            EGLFileInfo info = (EGLFileInfo)elementInfo;
            info.fCopy.reconcile();
            IEGLFile original = (IEGLFile)info.fCopy.getOriginalElement();
            IResource resource = original.getResource();
            if (resource == null) {
                super.doSaveDocument(monitor, element, document, overwrite);
                return;
            }
            if (resource != null && !overwrite) {
                this.checkSynchronizationState(info.fModificationStamp, resource);
            }
            this.fireElementStateChanging(element);
            try {
                try {
                    this.fIsAboutToSave = true;
                    info.fCopy.commit(overwrite, monitor);
                }
                catch (CoreException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
            }
            finally {
                this.fIsAboutToSave = false;
            }
            AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
            model.updateMarkers(info.fDocument);
            if (resource != null) {
                info.setModificationStamp(this.computeModificationStamp(resource));
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    public void doResetDocument(Object element, IProgressMonitor monitor) throws CoreException {
        if (element == null) {
            return;
        }
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof EGLFileInfo) {
            Document document;
            IStatus status;
            EGLFileInfo info;
            block8: {
                info = (EGLFileInfo)elementInfo;
                status = null;
                try {
                    IEGLFile original = (IEGLFile)info.fCopy.getOriginalElement();
                    IResource resource = original.getResource();
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        try {
                            this.refreshFile(file, monitor);
                        }
                        catch (CoreException x) {
                            this.handleCoreException(x, "CoreException - DocumentProvider.doResetDocument()");
                        }
                        FileEditorInput input = new FileEditorInput(file);
                        document = super.createDocument((Object)input);
                        break block8;
                    }
                    document = new Document();
                }
                catch (CoreException x) {
                    document = new Document();
                    status = x.getStatus();
                }
            }
            this.fireElementContentAboutToBeReplaced(element);
            this.removeUnchangedElementListeners(element, (AbstractDocumentProvider.ElementInfo)info);
            info.fDocument.set(document.get());
            info.fCanBeSaved = false;
            info.fStatus = status;
            this.addUnchangedElementListeners(element, (AbstractDocumentProvider.ElementInfo)info);
            this.fireElementContentReplaced(element);
            this.fireElementDirtyStateChanged(element, false);
        } else {
            super.doResetDocument(element, monitor);
        }
    }

    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                String encoding = this.getEncoding(element);
                if (encoding == null) {
                    encoding = ResourcesPlugin.getEncoding();
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(document.get().getBytes(encoding));
                IFile file = input.getFile();
                file.setContents((InputStream)stream, overwrite, true, monitor);
            }
            catch (IOException x) {
                Status s = new Status(4, "org.eclipse.edt.ide.core", 0, x.getMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
    }

    IEGLFile getWorkingCopy(IEditorInput element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof EGLFileInfo) {
            EGLFileInfo info = (EGLFileInfo)elementInfo;
            return info.fCopy;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.fBufferFactory;
    }

    protected IDocument createEmptyDocument() {
        return new EGLDocument();
    }

    public boolean isSynchronized(Object element) {
        long synStamp;
        long modStamp = this.getModificationStamp(element);
        return modStamp == (synStamp = this.getSynchronizationStamp(element)) && super.isSynchronized(element);
    }

    protected class BufferFactory
    implements IBufferFactory {
        protected BufferFactory() {
        }

        private IDocument internalGetDocument(IFileEditorInput input) throws CoreException {
            IDocument document = DocumentProvider.this.getDocument(input);
            if (document != null) {
                return document;
            }
            return DocumentProvider.this.createDocument(input);
        }

        public IBuffer createBuffer(IOpenable owner) {
            IEGLFile unit;
            IEGLFile original;
            IResource resource;
            if (owner instanceof IEGLFile && (resource = (original = (IEGLFile)(unit = (IEGLFile)owner).getOriginalElement()).getResource()) instanceof IFile) {
                FileEditorInput providerKey = new FileEditorInput((IFile)resource);
                IDocument document = null;
                IStatus status = null;
                try {
                    document = this.internalGetDocument((IFileEditorInput)providerKey);
                }
                catch (CoreException x) {
                    status = x.getStatus();
                    document = new Document();
                }
                DocumentAdapter adapter = new DocumentAdapter((IOpenable)unit, document, (ILineTracker)new DefaultLineTracker(), DocumentProvider.this, providerKey);
                adapter.setStatus(status);
                return adapter;
            }
            return DocumentAdapter.NULL;
        }
    }

    protected class EGLFileInfo
    extends FileDocumentProvider.FileInfo {
        IEGLFile fCopy;

        public EGLFileInfo(IDocument document, IAnnotationModel model, _FileSynchronizer fileSynchronizer, IEGLFile copy) {
            super((FileDocumentProvider)DocumentProvider.this, document, model, (FileDocumentProvider.FileSynchronizer)fileSynchronizer);
            this.fCopy = copy;
        }

        public void setModificationStamp(long timeStamp) {
            this.fModificationStamp = timeStamp;
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList();

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove((Object)listener);
        }
    }

    protected class _FileSynchronizer
    extends FileDocumentProvider.FileSynchronizer {
        public _FileSynchronizer(IFileEditorInput fileEditorInput) {
            super((FileDocumentProvider)DocumentProvider.this, fileEditorInput);
        }
    }
}

