/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.ui.internal.eglarpackager.EglarFileExportOperation;
import org.eclipse.edt.ide.ui.internal.eglarpackager.IEglarBinaryProjectBuilder;
import org.eclipse.edt.ide.ui.internal.eglarpackager.IEglarExportRunnable;
import org.eclipse.edt.ide.ui.internal.eglarpackager.NewEglarFileExportOperation;
import org.eclipse.edt.ide.ui.internal.eglarpackager.PlainEglarBuilder;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.swt.widgets.Shell;

public class EglarPackageData {
    private boolean fExportEGLIRFiles;
    private boolean fExportOutputFolders;
    private boolean fExportEGLFiles;
    private boolean fExportTLFSrcFiles;
    private boolean fUseSourceFolderHierarchy;
    private boolean fBuildIfNeeded;
    private Object[] fElements;
    private IPath fEglarLocation;
    private boolean fOverwrite;
    private boolean fCompress;
    private boolean fSaveDescription;
    private IPath fDescriptionLocation;
    private IPath binaryProjectLocation;
    private String fComment;
    private boolean fExportErrors;
    private boolean fExportWarnings;
    private boolean fIncludeDirectoryEntries;
    private IProject[] fRefactoringProjects = new IProject[0];
    private boolean fRefactoringAware = false;
    private boolean fRefactoringStructural = false;
    private boolean fDeprecationAware = true;
    private RefactoringDescriptorProxy[] fRefactoringDescriptors = new RefactoringDescriptorProxy[0];
    private IEglarBinaryProjectBuilder fEglarBuilder;
    private IEglarBinaryProjectBuilder fBinaryProjectBuilder;
    private String fLaunchConfigurationName;
    private boolean isEglarGeneratable = true;
    private String vendorName;
    private String versionName;

    public EglarPackageData() {
        this.setExportEGLSrcFiles(true);
        this.setExportEGLIRFiles(true);
        this.setExportOutputFolders(false);
        this.setUseSourceFolderHierarchy(false);
        this.setCompress(true);
        this.setSaveDescription(false);
        this.setEglarLocation((IPath)Path.EMPTY);
        this.setBinaryProjectLocation((IPath)Path.EMPTY);
        this.setDescriptionLocation((IPath)Path.EMPTY);
        this.setExportErrors(true);
        this.setExportWarnings(true);
        this.setBuildIfNeeded(true);
        this.setIncludeDirectoryEntries(false);
        this.setEglarGeneratable(true);
        this.setVendorName("");
        this.setVersionName("1.0");
        this.setExportTLFSrcFiles(false);
    }

    public boolean isEglarGeneratable() {
        return this.isEglarGeneratable;
    }

    public void setEglarGeneratable(boolean isEglarGeneratable) {
        this.isEglarGeneratable = isEglarGeneratable;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public IPath getBinaryProjectLocation() {
        return this.binaryProjectLocation;
    }

    public void setBinaryProjectLocation(IPath binaryProjectLocation) {
        this.binaryProjectLocation = binaryProjectLocation;
    }

    public boolean isBinaryProjectExport() {
        return this.binaryProjectLocation != Path.EMPTY;
    }

    public boolean isCompressed() {
        return this.fCompress;
    }

    public void setCompress(boolean state) {
        this.fCompress = state;
    }

    public boolean allowOverwrite() {
        return this.fOverwrite;
    }

    public void setOverwrite(boolean state) {
        this.fOverwrite = state;
    }

    public boolean areEGLIRFilesExported() {
        return this.fExportEGLIRFiles;
    }

    public boolean areEGLSrcFilesExported() {
        return this.fExportEGLFiles;
    }

    public void setExportEGLIRFiles(boolean state) {
        this.fExportEGLIRFiles = state;
    }

    public void setExportEGLSrcFiles(boolean state) {
        this.fExportEGLFiles = state;
    }

    public boolean areOutputFoldersExported() {
        return this.fExportOutputFolders;
    }

    public void setExportOutputFolders(boolean state) {
        this.fExportOutputFolders = state;
    }

    public boolean areGeneratedFilesExported() {
        return this.fExportOutputFolders || this.fExportEGLIRFiles;
    }

    public boolean useSourceFolderHierarchy() {
        return this.fUseSourceFolderHierarchy;
    }

    public void setUseSourceFolderHierarchy(boolean state) {
        this.fUseSourceFolderHierarchy = state;
    }

    public IPath getAbsoluteEglarLocation() {
        if (!this.fEglarLocation.isAbsolute()) {
            IFile file;
            IPath absolutePath;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (this.fEglarLocation.segmentCount() >= 2 && !"..".equals(this.fEglarLocation.segment(0)) && (absolutePath = (file = root.getFile(this.fEglarLocation)).getLocation()) != null) {
                return absolutePath;
            }
            return root.getLocation().append(this.fEglarLocation);
        }
        return this.fEglarLocation;
    }

    public IPath getBaseEglarLocation() {
        if (this.fEglarLocation != null) {
            String fileExt = this.fEglarLocation.getFileExtension();
            if ("eglar".equalsIgnoreCase(fileExt)) {
                return this.fEglarLocation.removeLastSegments(1);
            }
            return this.fEglarLocation;
        }
        return null;
    }

    public IPath getAbsoluteBinaryProjectLocation() {
        if (!this.binaryProjectLocation.isAbsolute()) {
            IFile file;
            IPath absolutePath;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (this.binaryProjectLocation.segmentCount() >= 2 && !"..".equals(this.binaryProjectLocation.segment(0)) && (absolutePath = (file = root.getFile(this.binaryProjectLocation)).getLocation()) != null) {
                return absolutePath;
            }
            return root.getLocation().append(this.binaryProjectLocation);
        }
        return this.binaryProjectLocation;
    }

    public IPath getAbsoluteEglarSrcLocation() {
        String fileExtension;
        IPath eglarLocation = this.getAbsoluteEglarLocation();
        IPath eglarSrcFileName = eglarLocation.removeLastSegments(1);
        String eglarFileFullName = eglarLocation.lastSegment();
        int index = eglarFileFullName.lastIndexOf(fileExtension = eglarLocation.getFileExtension());
        if (index != -1) {
            eglarSrcFileName = eglarSrcFileName.append(String.valueOf(eglarFileFullName.substring(0, index)) + "zip");
        }
        return eglarSrcFileName;
    }

    public IPath getEglarLocation() {
        return this.fEglarLocation;
    }

    public void setEglarLocation(IPath eglarLocation) {
        this.fEglarLocation = eglarLocation;
    }

    public boolean isDescriptionSaved() {
        return this.fSaveDescription;
    }

    public void setSaveDescription(boolean state) {
        this.fSaveDescription = state;
    }

    public IPath getDescriptionLocation() {
        return this.fDescriptionLocation;
    }

    public void setDescriptionLocation(IPath descriptionLocation) {
        this.fDescriptionLocation = descriptionLocation;
    }

    public IFile getDescriptionFile() {
        IPath path = this.getDescriptionLocation();
        if (path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return null;
    }

    public Object[] getElements() {
        if (this.fElements == null) {
            this.setElements(new Object[0]);
        }
        return this.fElements;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public boolean areErrorsExported() {
        return this.fExportErrors;
    }

    public void setExportErrors(boolean exportErrors) {
        this.fExportErrors = exportErrors;
    }

    public boolean exportWarnings() {
        return this.fExportWarnings;
    }

    public void setExportWarnings(boolean exportWarnings) {
        this.fExportWarnings = exportWarnings;
    }

    public boolean isBuildingIfNeeded() {
        return this.fBuildIfNeeded;
    }

    public void setBuildIfNeeded(boolean buildIfNeeded) {
        this.fBuildIfNeeded = buildIfNeeded;
    }

    public IFile[] findIRfilesFor(IFile eglFile) throws CoreException {
        return null;
    }

    public IEglarBinaryProjectBuilder createPlainEglarBuilder() {
        return new PlainEglarBuilder();
    }

    public IEglarExportRunnable createEglarExportRunnable(Shell parent) {
        return new NewEglarFileExportOperation(this, parent);
    }

    public IEglarExportRunnable createBinaryProjectExportRunnable(Shell parent) {
        return null;
    }

    public IEglarExportRunnable createEglarExportRunnable(EglarPackageData[] EglarPackagesData, Shell parent) {
        return new EglarFileExportOperation(EglarPackagesData, parent);
    }

    public boolean isValid() {
        return this.getElements() != null && this.getElements().length > 0 && this.getAbsoluteEglarLocation() != null;
    }

    public boolean areDirectoryEntriesIncluded() {
        return this.fIncludeDirectoryEntries;
    }

    public void setIncludeDirectoryEntries(boolean includeDirectoryEntries) {
        this.fIncludeDirectoryEntries = includeDirectoryEntries;
    }

    public IProject[] getRefactoringProjects() {
        return this.fRefactoringProjects;
    }

    public boolean isExportStructuralOnly() {
        return this.fRefactoringStructural;
    }

    public boolean isRefactoringAware() {
        return this.fRefactoringAware;
    }

    public boolean isDeprecationAware() {
        return this.fDeprecationAware;
    }

    public void setRefactoringProjects(IProject[] projects) {
        Assert.isNotNull((Object)projects);
        this.fRefactoringProjects = projects;
    }

    public void setRefactoringAware(boolean aware) {
        this.fRefactoringAware = aware;
    }

    public void setDeprecationAware(boolean aware) {
        this.fDeprecationAware = aware;
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)descriptors);
        this.fRefactoringDescriptors = descriptors;
    }

    public RefactoringDescriptorProxy[] getRefactoringDescriptors() {
        return this.fRefactoringDescriptors;
    }

    public void setExportStructuralOnly(boolean structural) {
        this.fRefactoringStructural = structural;
    }

    public IEglarBinaryProjectBuilder getEglarBuilder() {
        if (this.fEglarBuilder == null) {
            this.fEglarBuilder = this.createPlainEglarBuilder();
        }
        return this.fEglarBuilder;
    }

    public IEglarBinaryProjectBuilder getBinaryProjectBuilder() {
        return this.fBinaryProjectBuilder;
    }

    public void setEglarBuilder(IEglarBinaryProjectBuilder eglarBuilder) {
        this.fEglarBuilder = eglarBuilder;
    }

    public String getLaunchConfigurationName() {
        return this.fLaunchConfigurationName;
    }

    public void setLaunchConfigurationName(String name) {
        this.fLaunchConfigurationName = name;
    }

    public boolean areTLFSrcFilesExported() {
        return this.fExportTLFSrcFiles;
    }

    public void setExportTLFSrcFiles(boolean fExportTLFSrcFiles) {
        this.fExportTLFSrcFiles = fExportTLFSrcFiles;
    }
}

