/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers.wizards;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.compiler.internal.core.builder.AccumulatingProblemrRequestor;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusUtil;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.HandlerConfiguration;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.NewHandlerWizardMessages;
import org.eclipse.edt.ide.ui.internal.handlers.wizards.RUIHandlerWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class RUIHandlerWizardPage
extends WizardPage {
    private int nColumns = 5;
    private StringDialogField fHandlerDialogField;
    private StringDialogField fHandlerTitleField;
    private boolean hasModifiedTitle = false;
    private StatusInfo fProgramStatus;
    private String handlerTitle;
    protected boolean inputNeedsProcessing = true;

    protected RUIHandlerWizardPage(String pageName) {
        super(pageName);
        this.setTitle(NewHandlerWizardMessages.NewEGLRUIHandlerWizardPageTitle);
        this.setDescription(NewHandlerWizardMessages.NewEGLRUIHandlerWizardPageDescription);
        this.fProgramStatus = new StatusInfo();
        this.handlerTitle = "";
        this.setPageComplete(false);
    }

    private HandlerConfiguration getConfiguration() {
        return ((RUIHandlerWizard)this.getWizard()).getConfiguration();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpConstants.EGL_RUI_HANDLER_DEFINITION);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.nColumns;
        composite.setLayout((Layout)layout);
        this.fHandlerDialogField = new StringDialogField();
        this.fHandlerDialogField.setDialogFieldListener(new HandlerDialogFieldAdapter());
        this.fHandlerDialogField.setLabelText(NewHandlerWizardMessages.NewEGLRUIHandlerWizardPagePartlabel);
        this.fHandlerDialogField.setEnabled(false);
        this.fHandlerDialogField.doFillIntoGrid(composite, this.nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fHandlerDialogField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fHandlerDialogField.getTextControl(null));
        this.fHandlerTitleField = new StringDialogField();
        this.fHandlerTitleField.setDialogFieldListener(new HandlerTitleFieldAdapter());
        this.fHandlerTitleField.setLabelText(NewHandlerWizardMessages.NewEGLRUIHandlerWizardPageTitlelabel);
        this.fHandlerTitleField.setEnabled(true);
        this.fHandlerTitleField.doFillIntoGrid(composite, this.nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fHandlerTitleField.getTextControl(null), this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)this.fHandlerTitleField.getTextControl(null));
        this.fHandlerDialogField.setText(this.getConfiguration().getHandlerName());
        this.handlerTitle = this.getConfiguration().getHandlerName();
        this.fHandlerTitleField.setText(this.handlerTitle);
        this.setControl((Control)composite);
        this.validatePage();
        Dialog.applyDialogFont((Control)parent);
    }

    private void handleHandlerDialogFieldChanged() {
        this.validatePage();
    }

    private void handleHandlerTitleFieldChanged() {
        if (!this.fHandlerTitleField.getText().equals(this.fHandlerDialogField.getText())) {
            this.hasModifiedTitle = true;
        }
        this.handlerTitle = this.fHandlerTitleField.getText();
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected boolean validatePage() {
        this.fProgramStatus.setOK();
        String partName = this.getConfiguration().getHandlerName();
        if (partName.length() == 0) {
            this.fProgramStatus.setError(NewWizardMessages.NewTypeWizardPageErrorEnterPartName);
        } else if (partName.indexOf(46) != -1) {
            this.fProgramStatus.setError(NewWizardMessages.NewTypeWizardPageErrorQualifiedName);
        } else {
            this.validateEGLName(partName, 2, this.fProgramStatus);
        }
        this.updateStatus(new IStatus[]{this.fProgramStatus});
        return this.fProgramStatus.getSeverity() != 4;
    }

    private void updateStatus(IStatus[] iStatus) {
        IStatus status = StatusUtil.getMostSevere(iStatus);
        this.setPageComplete(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    protected void validateEGLName(String name, int nameValidatorConstant, StatusInfo status) {
        AccumulatingProblemrRequestor pRequestor = new AccumulatingProblemrRequestor();
        ICompilerOptions compilerOptions = new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return false;
            }

            public boolean isAliasJSFNames() {
                return false;
            }
        };
        EGLNameValidator.validate((String)name, (int)nameValidatorConstant, (IProblemRequestor)pRequestor, (ICompilerOptions)compilerOptions);
        List validationList = pRequestor.getProblems();
        if (!validationList.isEmpty()) {
            int currentSeverity = -1;
            Problem problem = null;
            int i = 0;
            while (i < validationList.size()) {
                if (((Problem)validationList.get(i)).getSeverity() == 2) {
                    currentSeverity = 2;
                    problem = (Problem)validationList.get(i);
                    break;
                }
                if (((Problem)validationList.get(i)).getSeverity() == 1 && (currentSeverity == 0 || currentSeverity == -1)) {
                    currentSeverity = 1;
                    problem = (Problem)validationList.get(i);
                } else if (((Problem)validationList.get(i)).getSeverity() == 0 && currentSeverity == -1) {
                    currentSeverity = 0;
                    problem = (Problem)validationList.get(i);
                }
                ++i;
            }
            if (problem != null) {
                String messageFromBundle = DefaultProblemRequestor.getMessageFromBundle((int)problem.getProblemKind(), (String[])problem.getInserts());
                if (currentSeverity == 2) {
                    status.setError(messageFromBundle);
                } else if (currentSeverity == 1) {
                    status.setWarning(messageFromBundle);
                } else if (currentSeverity == 0) {
                    status.setInfo(messageFromBundle);
                }
            }
        }
    }

    public boolean isInputNeedsProcessing() {
        return this.inputNeedsProcessing;
    }

    public void setInputNeedsProcessing(boolean b) {
        this.inputNeedsProcessing = b;
    }

    public String getHandlerTitle() {
        return this.handlerTitle;
    }

    public void updateHandlerName() {
        this.fHandlerDialogField.setText(this.getConfiguration().getHandlerName());
    }

    public boolean isPageComplete() {
        return true;
    }

    private class HandlerDialogFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private HandlerDialogFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            RUIHandlerWizardPage.this.handleHandlerDialogFieldChanged();
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }

    private class HandlerTitleFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private HandlerTitleFieldAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            RUIHandlerWizardPage.this.handleHandlerTitleFieldChanged();
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }
}

