/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.ArrayList;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;

public class FunctionOutlineAdapter
extends AbstractOutlineAdapter {
    public FunctionOutlineAdapter(EGLEditor editor) {
        super(editor);
        this.nodeIcon = PluginImages.DESC_OBJS_FUNCTION;
    }

    @Override
    public String getText(Object element) {
        Name funcName = null;
        Node function = (Node)element;
        if (element instanceof TopLevelFunction) {
            funcName = ((TopLevelFunction)element).getName();
        } else if (element instanceof NestedFunction) {
            funcName = ((NestedFunction)element).getName();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(funcName.getCanonicalName());
        buffer.append('(');
        final ArrayList parameters = new ArrayList();
        function.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(TopLevelFunction topLevelFunction) {
                return true;
            }

            public boolean visit(NestedFunction nestedFunction) {
                return true;
            }

            public boolean visit(FunctionParameter functionParameter) {
                parameters.add(functionParameter);
                return false;
            }
        });
        int len = parameters.size();
        if (len > 0) {
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buffer.append(", ");
                }
                FunctionParameter param = (FunctionParameter)parameters.get(i);
                buffer.append(this.formatType(param.getType()));
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public IRegion getHighlightRange(Object element) {
        Name funcName = null;
        if (element instanceof TopLevelFunction) {
            funcName = ((TopLevelFunction)element).getName();
        } else if (element instanceof NestedFunction) {
            funcName = ((NestedFunction)element).getName();
        } else {
            return new Region(0, 0);
        }
        return new Region(funcName.getOffset(), funcName.getLength());
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof NestedFunction) {
            NestedFunction field = (NestedFunction)element;
            this.nodeIcon = field.isPrivate() ? PluginImages.DESC_OBJS_PRIVATE_FUNCTION : PluginImages.DESC_OBJS_FUNCTION;
        }
        return super.getImage(element);
    }
}

