/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.AbstractOutlineAdapter;
import org.eclipse.jface.text.IRegion;

public class ProgramOutlineAdapter
extends AbstractOutlineAdapter {
    public ProgramOutlineAdapter(EGLEditor editor) {
        super(editor);
        this.nodeIcon = PluginImages.DESC_OBJS_PGM;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        Program program = (Program)parentElement;
        return this.filterOutProperties(program.getContents()).toArray();
    }

    @Override
    public String getText(Object element) {
        Program program = (Program)element;
        StringBuffer buffer = new StringBuffer();
        buffer.append(program.getName().getCanonicalName());
        ProgramParameter[] parameters = program.getParameters().toArray(new ProgramParameter[0]);
        if (parameters.length > 0) {
            buffer.append('(');
            int i = 0;
            while (i < parameters.length) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.formatType(parameters[i].getType()));
                ++i;
            }
            buffer.append(')');
        }
        String programType = "BasicProgram";
        if (program.hasSubType()) {
            programType = program.getSubType().getCanonicalString();
        }
        buffer.append(programType == null ? "" : " : " + programType);
        return buffer.toString();
    }

    @Override
    public IRegion getHighlightRange(Object element) {
        Program programNode = (Program)element;
        return this.getPartNameHighlightRange((Part)programNode);
    }
}

