/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix;

import java.util.ArrayList;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.quickfix.EGLCorrectionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EGLCorrectionAssistant
extends QuickAssistAssistant {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Position fPosition;
    private Annotation[] fCurrentAnnotations;
    private boolean fIsProblemLocationAvailable;
    private boolean fIsCompletionActive;

    public EGLCorrectionAssistant(ITextEditor editor) {
        this.fEditor = editor;
        EGLCorrectionProcessor processor = new EGLCorrectionProcessor(this);
        this.setQuickAssistProcessor(processor);
        this.enableColoredLabels(PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS"));
        this.setInformationControlCreator(this.getInformationControlCreator());
        this.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                EGLCorrectionAssistant.this.fIsCompletionActive = false;
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                EGLCorrectionAssistant.this.fIsCompletionActive = true;
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, "");
            }
        };
    }

    public void install(ISourceViewer sourceViewer) {
        super.install(sourceViewer);
        this.fViewer = sourceViewer;
    }

    public void uninstall() {
        super.uninstall();
    }

    public String showPossibleQuickAssists() {
        boolean isReinvoked = false;
        this.fIsProblemLocationAvailable = false;
        if (this.fIsCompletionActive && this.isUpdatedOffset()) {
            isReinvoked = true;
            this.restorePosition();
            this.hide();
            this.fIsProblemLocationAvailable = true;
        }
        this.fPosition = null;
        this.fCurrentAnnotations = null;
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return super.showPossibleQuickAssists();
        }
        ArrayList resultingAnnotations = new ArrayList(20);
        try {
            Point selectedRange = this.fViewer.getSelectedRange();
            int currOffset = selectedRange.x;
            int currLength = selectedRange.y;
            boolean goToClosest = currLength == 0 && !isReinvoked;
            int newOffset = EGLCorrectionAssistant.collectQuickFixableAnnotations(this.fEditor, currOffset, goToClosest, resultingAnnotations);
            if (newOffset != currOffset) {
                this.storePosition(currOffset, currLength);
                this.fViewer.setSelectedRange(newOffset, 0);
                this.fViewer.revealRange(newOffset, 0);
                this.fIsProblemLocationAvailable = true;
                if (this.fIsCompletionActive) {
                    this.hide();
                }
            }
        }
        catch (BadLocationException e) {
            EDTUIPlugin.log(e);
        }
        this.fCurrentAnnotations = resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
        return super.showPossibleQuickAssists();
    }

    private void storePosition(int currOffset, int currLength) {
        this.fPosition = new Position(currOffset, currLength);
    }

    public boolean isUpdatedOffset() {
        return this.fPosition != null;
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }

    /*
     * Unable to fully structure code
     */
    public static int collectQuickFixableAnnotations(ITextEditor editor, int invocationLocation, boolean goToClosest, ArrayList resultingAnnotations) throws BadLocationException {
        model = EDTUIPlugin.getDefault().getEGLDocumentProvider().getAnnotationModel(editor.getEditorInput());
        if (model == null) {
            return invocationLocation;
        }
        iter = model.getAnnotationIterator();
        if (!goToClosest) ** GOTO lbl38
        lineInfo = EGLCorrectionAssistant.getRegionOfInterest(editor, invocationLocation);
        if (lineInfo == null) {
            return invocationLocation;
        }
        rangeStart = lineInfo.getOffset();
        rangeEnd = rangeStart + lineInfo.getLength();
        allAnnotations = new ArrayList<Annotation>();
        allPositions = new ArrayList<Position>();
        bestOffset = 0x7FFFFFFF;
        while (iter.hasNext()) {
            annot = (Annotation)iter.next();
            if (!EGLCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !EGLCorrectionAssistant.isInside(pos.offset, rangeStart, rangeEnd)) continue;
            allAnnotations.add(annot);
            allPositions.add(pos);
            bestOffset = EGLCorrectionAssistant.processAnnotation(annot, pos, invocationLocation, bestOffset);
        }
        if (bestOffset == 0x7FFFFFFF) {
            return invocationLocation;
        }
        i = 0;
        while (i < allPositions.size()) {
            pos = (Position)allPositions.get(i);
            if (EGLCorrectionAssistant.isInside(bestOffset, pos.offset, pos.offset + pos.length)) {
                resultingAnnotations.add(allAnnotations.get(i));
            }
            ++i;
        }
        return bestOffset;
lbl-1000:
        // 1 sources

        {
            annot = (Annotation)iter.next();
            if (!EGLCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !EGLCorrectionAssistant.isInside(invocationLocation, pos.offset, pos.offset + pos.length)) continue;
            resultingAnnotations.add(annot);
lbl38:
            // 3 sources

            ** while (iter.hasNext())
        }
lbl39:
        // 1 sources

        return invocationLocation;
    }

    private static IRegion getRegionOfInterest(ITextEditor editor, int invocationLocation) throws BadLocationException {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document.getLineInformationOfOffset(invocationLocation);
    }

    private static boolean isInside(int offset, int start, int end) {
        return offset == start || offset == end || offset > start && offset < end;
    }

    private static int processAnnotation(Annotation annot, Position pos, int invocationLocation, int bestOffset) {
        int newClosestPosition;
        int posBegin = pos.offset;
        int posEnd = posBegin + pos.length;
        if (EGLCorrectionAssistant.isInside(invocationLocation, posBegin, posEnd)) {
            return invocationLocation;
        }
        if (bestOffset != invocationLocation && (newClosestPosition = EGLCorrectionAssistant.computeBestOffset(posBegin, invocationLocation, bestOffset)) != -1 && newClosestPosition != bestOffset && EGLCorrectionProcessor.hasCorrections(annot)) {
            return newClosestPosition;
        }
        return bestOffset;
    }

    private static int computeBestOffset(int newOffset, int invocationLocation, int bestOffset) {
        if (newOffset <= invocationLocation) {
            if (bestOffset > invocationLocation) {
                return newOffset;
            }
            if (bestOffset <= newOffset) {
                return newOffset;
            }
            return -1;
        }
        if (newOffset <= bestOffset) {
            return newOffset;
        }
        return -1;
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    public boolean isProblemLocationAvailable() {
        return this.fIsProblemLocationAvailable;
    }

    public Annotation[] getAnnotationsAtOffset() {
        return this.fCurrentAnnotations;
    }
}

