/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.wizards.sqldb;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.ui.dse.dialogs.ConnectionDisplayProperty;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.generator.eglsource.EglSourceGenerator;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Parameter;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.record.NewRecordSummaryPage;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizard;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.internal.record.conversion.sqldb.DataToolsObjectsToEglSource;
import org.eclipse.edt.ide.ui.internal.record.wizards.sqldb.RecordFromSqlDatabasePage;
import org.eclipse.edt.ide.ui.internal.record.wizards.sqldb.RecordFromSqlDatabaseWizardConfiguration;
import org.eclipse.edt.ide.ui.internal.record.wizards.sqldb.RecordFromSqlDatabaseWizardConfigurationBidi;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.ide.ui.internal.util.UISQLUtility;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizard;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizard;
import org.eclipse.edt.ide.ui.wizards.BindingSQLDatabaseConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class RecordFromSqlDatabaseWizard
extends TemplateWizard
implements IWorkbenchWizard,
IPageChangingListener,
IMessageHandler {
    private RecordFromSqlDatabaseWizardConfiguration config;
    protected RecordFromSqlDatabasePage sqlDbPage;
    protected NewRecordSummaryPage summaryPage;
    protected IStructuredSelection selection;
    protected List<String> messages = new ArrayList<String>();

    public RecordFromSqlDatabaseWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
        boolean isBidi = EGLBasePlugin.getPlugin().getPreferenceStore().getBoolean("BidiEnabledOption");
        this.config = isBidi ? new RecordFromSqlDatabaseWizardConfigurationBidi() : new RecordFromSqlDatabaseWizardConfiguration();
        this.sqlDbPage = new RecordFromSqlDatabasePage(this.config);
        this.summaryPage = new NewRecordSummaryPage((ISelection)this.selection);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.sqlDbPage);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public void init(IWorkbench arg0, IStructuredSelection selection) {
        this.selection = selection;
    }

    @Override
    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, this.createFinishOperation());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Exception exception) {}
        return true;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer != null) {
            ((WizardDialog)wizardContainer).addPageChangingListener((IPageChangingListener)this);
        }
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() == this.summaryPage) {
            IRunnableWithProgress op = this.createPreviewOperation();
            try {
                this.getContainer().run(true, true, op);
            }
            catch (InterruptedException interruptedException) {
                event.doit = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected IRunnableWithProgress createPreviewOperation() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (RecordFromSqlDatabaseWizard.this.messages != null) {
                    RecordFromSqlDatabaseWizard.this.messages.clear();
                }
                final String results = RecordFromSqlDatabaseWizard.this.generateRecords(monitor, false);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).RecordFromSqlDatabaseWizard.this.summaryPage.setContent(results);
                        List<String> messages = RecordFromSqlDatabaseWizard.this.getMessages();
                        if (messages != null && messages.size() > 0) {
                            (this).RecordFromSqlDatabaseWizard.this.summaryPage.setMessages(messages);
                        }
                    }
                });
            }
        };
    }

    protected IRunnableWithProgress createFinishOperation() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String results = RecordFromSqlDatabaseWizard.this.generateRecords(monitor, true);
                ((NewRecordWizard)RecordFromSqlDatabaseWizard.this.getParentWizard()).setContentObj(results);
            }
        };
    }

    protected String generateRecords(IProgressMonitor monitor, boolean isFinished) throws InterruptedException {
        List tables = this.config.getSelectedTables();
        monitor.beginTask("Generating record parts", tables.size());
        StringBuffer buffer = new StringBuffer();
        IManagedConnection managedConnection = this.config.getDatabaseConnection().getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo");
        if (managedConnection != null) {
            IFile eglddFile;
            ConnectionInfo connection = (ConnectionInfo)managedConnection.getConnection().getRawConnection();
            DataToolsObjectsToEglSource d = new DataToolsObjectsToEglSource();
            for (Object object : tables) {
                if (monitor.isCanceled()) break;
                try {
                    Table table = (Table)object;
                    monitor.subTask(table.getName());
                    EglSourceGenerator generator = new EglSourceGenerator((AbstractGeneratorCommand)d);
                    EglContext context = generator.makeContext((AbstractGeneratorCommand)d);
                    context.put((Object)"dataDefinition", (Object)connection.getDatabaseDefinition());
                    context.put((Object)"tableNameQualified", (Object)this.config.isQualifiedTableNames());
                    context.put((Object)"dbMessageHandler", (Object)this);
                    d.generate(table, generator, null);
                    buffer.append(generator.getResult());
                    monitor.worked(1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (isFinished && this.config.isSaveConnectionToDeploymentDescriptor() && (eglddFile = CoreUtility.getOrCreateEGLDDFileHandle(((EGLFileWizard)this.getParentWizard()).getConfiguration())) != null) {
                EGLDeploymentRoot deploymentRoot = null;
                try {
                    deploymentRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(eglddFile, false);
                    IConnectionProfile profile = connection.getConnectionProfile();
                    ConnectionDisplayProperty[] properties = EGLSQLUtility.getConnectionDisplayProperties((IConnectionProfile)profile);
                    BindingSQLDatabaseConfiguration sqlConfig = new BindingSQLDatabaseConfiguration();
                    UISQLUtility.setBindingSQLDatabaseConfiguration(sqlConfig, properties);
                    Deployment deployment = deploymentRoot.getDeployment();
                    DeploymentFactory factory = DeploymentFactory.eINSTANCE;
                    Bindings bindings = deployment.getBindings();
                    if (bindings == null) {
                        bindings = factory.createBindings();
                        deployment.setBindings(bindings);
                    }
                    EList existedBindings = bindings.getBinding();
                    boolean existed = false;
                    for (Binding binding : existedBindings) {
                        if (org.eclipse.edt.javart.resources.egldd.Binding.BINDING_DB_SQL.equals(binding.getType()) && binding.getParameters() != null) {
                            for (Parameter p : binding.getParameters().getParameter()) {
                                if (!"dbms".equals(p.getName()) || !sqlConfig.getDbms().equals(p.getValue())) continue;
                                existed = true;
                                break;
                            }
                        }
                        if (existed) break;
                    }
                    if (!existed) {
                        sqlConfig.executeAddBinding(bindings);
                    }
                    if (!EGLDDRootHelper.isWorkingModelSharedByUserClients(eglddFile)) {
                        EGLDDRootHelper.saveEGLDDFile(eglddFile, deploymentRoot);
                    }
                }
                finally {
                    if (deploymentRoot != null) {
                        EGLDDRootHelper.releaseSharedWorkingModel(eglddFile, false);
                    }
                }
            }
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        return buffer.toString();
    }

    @Override
    public void addMessage(String message) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(message);
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }
}

