/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.results.views;

import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.results.views.AbstractResultsViewPart;
import org.eclipse.edt.ide.ui.internal.results.views.EditorAbstractResultsListViewerAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;

public class AbstractResultsListViewer
extends ListViewer {
    private AbstractResultsViewPart viewPart;
    private EditorAbstractResultsListViewerAction selectAllAction;
    private EditorAbstractResultsListViewerAction deselectAllAction;
    private EditorAbstractResultsListViewerAction copyAction;

    public AbstractResultsListViewer(Composite parent, AbstractResultsViewPart viewPart) {
        super(new List(parent, 66306));
        this.viewPart = viewPart;
        this.setUseHashlookup(true);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.createActions();
        this.createContextMenu();
        this.addGlobalActions();
    }

    public void createActions() {
        this.selectAllAction = new EditorAbstractResultsListViewerAction(UINlsStrings.SelectAllLabel, this.viewPart, 1);
        this.deselectAllAction = new EditorAbstractResultsListViewerAction(UINlsStrings.DeselectAllLabel, this.viewPart, 2);
        this.deselectAllAction.setEnabled(false);
        this.addSelectionChangedListener((ISelectionChangedListener)this.deselectAllAction);
        this.copyAction = new EditorAbstractResultsListViewerAction(UINlsStrings.CopyLabel, this.viewPart, 3);
        this.copyAction.setEnabled(false);
        this.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractResultsListViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.getList());
        this.getList().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.selectAllAction);
        manager.add((IAction)this.deselectAllAction);
        manager.add((IAction)this.copyAction);
    }

    private void addGlobalActions() {
        IActionBars actionBars = this.viewPart.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.selectAllAction);
        actionBars.setGlobalActionHandler("copy", (IAction)this.copyAction);
        actionBars.updateActionBars();
    }
}

