/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.results.views;

import java.util.List;
import org.eclipse.edt.ide.ui.internal.results.views.ResultsMultiPageViewer;
import org.eclipse.edt.ide.ui.internal.results.views.ResultsViewModel;
import org.eclipse.edt.ide.ui.internal.results.views.ResultsViewModelUpdateManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractResultsViewPart
extends ViewPart {
    private ResultsMultiPageViewer multiPageViewer = null;
    private Label noResultsViewLabel = null;
    private PageBook pageBook = null;
    private boolean hasValidMultiPageViewer = false;
    private ResultsViewModelUpdateManager viewerModelUpdateManager = new ResultsViewModelUpdateManager();

    public void addViewer(String tabTitle, List problems, Object resultsIdentifier, IAction action) {
        CTabItem mappedTab = this.viewerModelUpdateManager.getTabForPart(resultsIdentifier);
        if (mappedTab == null) {
            int pageIndex = this.addNewViewer(tabTitle, problems, resultsIdentifier, action);
            ResultsViewModel model = new ResultsViewModel(resultsIdentifier);
            this.viewerModelUpdateManager.addModel(model, (Item)this.getMultiPageViewer().getContainer().getItem(pageIndex));
            this.getMultiPageViewer().setActivePage(pageIndex);
        } else {
            this.getMultiPageViewer().setActivePage(mappedTab);
        }
    }

    public abstract int addNewViewer(String var1, List var2, Object var3, IAction var4);

    public void closeMyViewerIfNecessary(Object resultsIdentifier) {
        CTabItem matchingTab = this.viewerModelUpdateManager.getTabForPart(resultsIdentifier);
        if (matchingTab != null) {
            this.removeViewer(matchingTab);
        }
    }

    public void createPartControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.noResultsViewLabel = new Label((Composite)this.pageBook, 64);
        this.noResultsViewLabel.setText(this.getDefaultText());
        this.multiPageViewer = new ResultsMultiPageViewer((Composite)this.pageBook);
        this.multiPageViewer.getContainer().addCTabFolderListener((CTabFolderListener)new CTabFolderAdapter(){

            public void itemClosed(CTabFolderEvent e) {
                AbstractResultsViewPart.this.removeViewer(e);
            }
        });
        this.pageBook.showPage((Control)this.noResultsViewLabel);
        this.setTitle(this.getTitle());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.pageBook, this.helpContext());
    }

    public Object getAppropriateResultsIdentifier() {
        CTabItem selectedTab = this.getMultiPageViewer().getTabForCurrentViewer();
        return this.viewerModelUpdateManager.getResultsIdentifierForTab(selectedTab);
    }

    public abstract String getDefaultText();

    public boolean getHasValidMultiPageViewer() {
        return this.hasValidMultiPageViewer;
    }

    public abstract String getTitle();

    public abstract String helpContext();

    public PageBook getPageBook() {
        return this.pageBook;
    }

    public ResultsMultiPageViewer getMultiPageViewer() {
        return this.multiPageViewer;
    }

    public ISelection getSelection() {
        return this.getMultiPageViewer().getSelection();
    }

    public void removeViewer(CTabFolderEvent selEvent) {
        CTabItem selTab = (CTabItem)selEvent.item;
        this.removeViewer(selTab);
    }

    protected void removeViewer(CTabItem selTab) {
        this.getMultiPageViewer().removeViewer(selTab);
        this.viewerModelUpdateManager.removeModel((Item)selTab);
        if (this.getMultiPageViewer().getContainer().getItemCount() == 0) {
            this.hasValidMultiPageViewer = false;
            this.pageBook.showPage((Control)this.noResultsViewLabel);
        }
    }

    public void setFocus() {
        this.getMultiPageViewer().setFocus();
    }

    public void setHasValidMultiPageViewer(boolean state) {
        this.hasValidMultiPageViewer = state;
    }

    public void setResults(List problems, Object resultsIdentifier) {
        CTabItem matchingTab = this.viewerModelUpdateManager.getTabForPart(resultsIdentifier);
        if (matchingTab != null) {
            this.getMultiPageViewer().setResults(problems, matchingTab);
        }
    }
}

