/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.TypeBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Parameter;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.PrimitiveType;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceConfiguration;
import org.eclipse.edt.ide.ui.wizards.ExtractInterfaceFrExternalTypeConfiguration;

public class ExternalType2RuiInterfaceConverter {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String INDENT = "  ";

    private ExternalType2RuiInterfaceConverter() {
    }

    public static Map convert(ExtractInterfaceFrExternalTypeConfiguration config) {
        HashSet completedTypes = new HashSet();
        HashMap buffers = new HashMap();
        StringBuffer interfaceBuf = new StringBuffer();
        List econfigs = config.getExtractInterfaceConfigurations();
        for (ExtractInterfaceConfiguration econfig : econfigs) {
            Part part = econfig.getTheBoundPart();
            if (!(part instanceof ExternalType)) continue;
            ExternalType2RuiInterfaceConverter.convert(econfig, (ExternalType)part, interfaceBuf, buffers, completedTypes, config.getFPackage());
        }
        StringBuffer defaultBuf = ExternalType2RuiInterfaceConverter.getBuffer(config.getFPackage(), buffers);
        defaultBuf.insert(0, interfaceBuf);
        return buffers;
    }

    private static void convert(final ExtractInterfaceConfiguration config, ExternalType et, final StringBuffer interfaceBuf, final Map buffers, final HashSet completedTypes, final String currFilePkgName) {
        interfaceBuf.append("interface");
        interfaceBuf.append(' ');
        interfaceBuf.append(config.getInterfaceName());
        interfaceBuf.append(" {@");
        interfaceBuf.append("xml");
        interfaceBuf.append("{");
        interfaceBuf.append("name");
        interfaceBuf.append("=\"");
        interfaceBuf.append(ExternalType2RuiInterfaceConverter.getHostProgramName(et));
        interfaceBuf.append("\" }}");
        interfaceBuf.append(NEWLINE);
        et.accept((IASTVisitor)new DefaultASTVisitor(){
            private int idx;

            public boolean visit(ExternalType externaltype) {
                return true;
            }

            public boolean visit(NestedFunction nestedFunction) {
                if (config.getFunctionSelectionState(this.idx++) && !nestedFunction.isPrivate()) {
                    ExternalType2RuiInterfaceConverter.handleFunction(nestedFunction, interfaceBuf, buffers, completedTypes, currFilePkgName);
                }
                return false;
            }
        });
        interfaceBuf.append("end");
        interfaceBuf.append(NEWLINE);
        interfaceBuf.append(NEWLINE);
    }

    private static void handleFunction(NestedFunction func, StringBuffer interfaceBuf, final Map buffers, final HashSet completedTypes, String currFilePkgName) {
        Type retType;
        interfaceBuf.append(INDENT);
        interfaceBuf.append(' ');
        interfaceBuf.append("function");
        interfaceBuf.append(' ');
        interfaceBuf.append(func.getName().getCaseSensitiveIdentifier());
        interfaceBuf.append("( ");
        DefaultASTVisitor recordVisitor = new DefaultASTVisitor(){

            public boolean visit(NestedFunction nestedFunction) {
                return true;
            }

            public boolean visit(SimpleName name) {
                ExternalType2RuiInterfaceConverter.createNewFlexRecord(name.resolveBinding(), buffers, completedTypes);
                return false;
            }

            public boolean visit(QualifiedName name) {
                ExternalType2RuiInterfaceConverter.createNewFlexRecord(name.resolveBinding(), buffers, completedTypes);
                return false;
            }
        };
        List parms = func.getFunctionParameters();
        int numParms = parms == null ? 0 : parms.size();
        int parmIndex = 0;
        while (parmIndex < numParms) {
            FunctionParameter functionParameter = (FunctionParameter)parms.get(parmIndex);
            if (parmIndex > 0) {
                interfaceBuf.append(", ");
            }
            interfaceBuf.append(functionParameter.getName().getIdentifier());
            interfaceBuf.append(' ');
            if (functionParameter.getType().getKind() == 0) {
                interfaceBuf.append(ExtractInterfaceConfiguration.getQualifiedTypeString((Parameter)functionParameter, currFilePkgName, true));
                ExternalType2RuiInterfaceConverter.createNewFlexRecord(((NameType)functionParameter.getType()).getName().resolveBinding(), buffers, completedTypes);
            } else if (functionParameter.getType().isPrimitiveType()) {
                interfaceBuf.append(ExternalType2RuiInterfaceConverter.type((PrimitiveType)functionParameter.getType()));
            }
            interfaceBuf.append(' ');
            interfaceBuf.append(functionParameter.getUseType() == null ? FunctionParameter.UseType.INOUT.toString() : functionParameter.getUseType().toString());
            ++parmIndex;
        }
        interfaceBuf.append(" )");
        Type type = retType = func.getReturnDeclaration() == null ? null : func.getReturnType();
        if (retType != null) {
            interfaceBuf.append(' ');
            interfaceBuf.append("returns");
            interfaceBuf.append("( ");
            if (retType.getKind() == 0) {
                interfaceBuf.append(((NameType)retType).getName().getCanonicalName());
                ((NameType)retType).getName().accept((IASTVisitor)recordVisitor);
            } else if (retType.isPrimitiveType()) {
                interfaceBuf.append(ExternalType2RuiInterfaceConverter.type((PrimitiveType)retType));
            }
            interfaceBuf.append(" )");
        }
        interfaceBuf.append(" {@");
        interfaceBuf.append("xml");
        interfaceBuf.append("{");
        interfaceBuf.append("name");
        interfaceBuf.append("=\"");
        interfaceBuf.append(ExternalType2RuiInterfaceConverter.getHostFunctionName(func));
        interfaceBuf.append("\"}};\n");
    }

    private static StringBuffer getBuffer(String qualifier, Map buffers) {
        StringBuffer buf = (StringBuffer)buffers.get(qualifier);
        if (buf == null) {
            buf = new StringBuffer();
            buffers.put(qualifier, buf);
        }
        return buf;
    }

    private static String getHostProgramName(ExternalType et) {
        return et.getIdentifier();
    }

    private static String getHostFunctionName(NestedFunction function) {
        return function.getName().getIdentifier();
    }

    private static void createNewFlexRecord(IBinding binding, Map buffers, HashSet completedTypes) {
        FixedRecordBinding rec;
        if (!(Binding.isValidBinding((IBinding)binding) && binding.isTypeBinding() && ((TypeBinding)binding).getKind() == 6 && completedTypes.add((rec = (FixedRecordBinding)binding).getPackageQualifiedName()))) {
            return;
        }
        ExternalType2RuiInterfaceConverter.createNewFlexRecord(rec.getName(), ExternalType2RuiInterfaceConverter.getQualifier((IPartBinding)rec), rec.getStructureItems(), buffers, completedTypes);
    }

    private static void createNewFlexRecord(String recordName, String quailifier, List fields, Map buffers, HashSet completedTypes) {
        StringBuffer recordBuf = new StringBuffer();
        recordBuf.append("record " + recordName + " type " + "BasicRecord" + NEWLINE);
        int numFields = fields == null ? 0 : fields.size();
        int i = 0;
        while (i < numFields) {
            ExternalType2RuiInterfaceConverter.convert((StructureItemBinding)fields.get(i), quailifier, recordBuf, buffers, completedTypes);
            ++i;
        }
        recordBuf.append("end" + NEWLINE + NEWLINE);
        StringBuffer qualifierBuf = ExternalType2RuiInterfaceConverter.getBuffer(quailifier, buffers);
        qualifierBuf.append(recordBuf);
    }

    private static String type(PrimitiveType primitiveType) {
        return ExternalType2RuiInterfaceConverter.type(primitiveType.getPrimitive(), primitiveType.getPrimLength(), primitiveType.getPrimDecimals());
    }

    private static String type(PrimitiveTypeBinding primitiveTypeBinding) {
        return ExternalType2RuiInterfaceConverter.type(primitiveTypeBinding.getPrimitive(), String.valueOf(primitiveTypeBinding.getLength()), String.valueOf(primitiveTypeBinding.getDecimals()));
    }

    private static String type(Primitive primitive, String lengthValue, String precisionValue) {
        String length = "";
        String precision = "";
        if (lengthValue != null) {
            precision = "( " + lengthValue;
            if (precisionValue != null) {
                precision = String.valueOf(precision) + ", " + precisionValue;
            }
            precision = String.valueOf(precision) + " )";
            length = "( " + lengthValue + " )";
        }
        switch (primitive.getType()) {
            case 3: {
                return "boolean";
            }
            case 9: {
                return "hex" + length;
            }
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: {
                return "string";
            }
            case 23: {
                return "date";
            }
            case 27: {
                return "time";
            }
            case 28: {
                return "timeStamp";
            }
            case 26: {
                return "interval";
            }
            case 10: {
                return "int";
            }
            case 18: {
                return "smallInt";
            }
            case 1: {
                return "bigInt";
            }
            case 8: {
                return "smallFloat";
            }
            case 17: {
                return "float";
            }
            case 2: 
            case 13: 
            case 15: 
            case 16: {
                return "num" + precision;
            }
            case 7: {
                return "decimal" + precision;
            }
            case 12: {
                return "money" + precision;
            }
        }
        return "any";
    }

    private static String getTypeNameForSubstructuredFieldRecord(StructureItemBinding sField) {
        StringBuffer sbuf = new StringBuffer(sField.getParentQualifiedName().replaceAll("\\.", "_"));
        sbuf.insert(0, String.valueOf(sField.getDeclaringPart().getName()) + "_");
        return sbuf.toString();
    }

    private static String getQualifier(IPartBinding binding) {
        String[] parts;
        if (Binding.isValidBinding((IBinding)binding) && (parts = binding.getPackageName()) != null && parts.length > 0) {
            String qualifier = "";
            int idx = 0;
            while (idx < parts.length) {
                if (idx > 0) {
                    qualifier = String.valueOf(qualifier) + '.';
                }
                qualifier = String.valueOf(qualifier) + parts[idx];
                ++idx;
            }
            return qualifier;
        }
        return "";
    }

    private static void convert(StructureItemBinding sField, String quailifier, StringBuffer sbuf, Map buffers, HashSet completedTypes) {
        sbuf.append(INDENT);
        sbuf.append(String.valueOf(sField.getName()) + " ");
        if (sField.getChildren() != null && sField.getChildren().size() > 0) {
            StructureItemBinding binding = (StructureItemBinding)sField.getChildren().get(0);
            if (Binding.isValidBinding((IBinding)binding)) {
                String subRecordName = ExternalType2RuiInterfaceConverter.getTypeNameForSubstructuredFieldRecord(sField);
                sbuf.append(subRecordName);
                ExternalType2RuiInterfaceConverter.createNewFlexRecord(subRecordName, quailifier, sField.getChildren(), buffers, completedTypes);
            }
        } else if (sField.getType().getKind() == 3) {
            sbuf.append(ExternalType2RuiInterfaceConverter.type((PrimitiveTypeBinding)sField.getType()));
        }
        if (sField.hasOccurs()) {
            sbuf.append("[" + sField.getOccurs() + "]");
        }
        sbuf.append(";" + NEWLINE);
    }
}

