/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingProviderRegistry;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardProvider;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.wizards.EGLDDBindingConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class EGLDDBindingWizard
extends EGLPartWizard {
    protected int currentPageIndex = 0;
    protected IWizardPage[] PAGES;
    private Object fNewBinding;

    public EGLDDBindingWizard() {
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_EXTERNALSERVICE);
    }

    public void init(IWorkbench workbench, IProject proj, EGLDeploymentRoot root) {
        this.getEGLDDBindingConfiguration().init(workbench, proj, root);
        this.initBindingConfiguration(proj, root);
        this.setWindowTitle(NewWizardMessages.EGLDDBindingWizTitle);
    }

    private void initBindingConfiguration(IProject proj, EGLDeploymentRoot root) {
        EGLDDBindingWizardProvider[] providers = EGLDDBindingProviderRegistry.singleton.getEGLDDBindingWizardProviders();
        int i = 0;
        while (i < providers.length) {
            providers[i].bindingconfigurationClass.init(root, proj);
            ++i;
        }
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new EGLDDBindingConfiguration();
        }
        return this.configuration;
    }

    @Override
    public EGLPackageConfiguration getConfiguration(String pageName) {
        EGLDDBindingWizardProvider[] providers = EGLDDBindingProviderRegistry.singleton.getEGLDDBindingWizardProviders();
        int i = 0;
        while (i < providers.length) {
            EGLDDBindingWizardPages[] pages = providers[i].eglDDBindingWizardPages;
            int j = 0;
            while (j < pages.length) {
                if (pages[j].name.equals(pageName)) {
                    return providers[i].bindingconfigurationClass;
                }
                ++j;
            }
            ++i;
        }
        return super.getConfiguration(pageName);
    }

    private EGLDDBindingConfiguration getEGLDDBindingConfiguration() {
        return (EGLDDBindingConfiguration)this.getConfiguration();
    }

    public boolean canFinish() {
        return this.PAGES != null && this.canPagePathFinish(this.PAGES);
    }

    @Override
    public void addPages() {
        EGLDDBindingWizardPage page1 = new EGLDDBindingWizardPage("WIZPAGENAME_EGLDDBindingWizardPage");
        this.addPage((IWizardPage)page1);
        EGLDDBindingWizardProvider[] providers = EGLDDBindingProviderRegistry.singleton.getEGLDDBindingWizardProviders();
        int i = 0;
        while (i < providers.length) {
            EGLDDBindingWizardPages[] pages = providers[i].eglDDBindingWizardPages;
            int j = 0;
            while (j < pages.length) {
                this.addPage((IWizardPage)pages[j].wizardpage);
                ++j;
            }
            ++i;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.updatePagePathAndNextPage(page);
    }

    public IWizardPage updatePagePathAndNextPage(IWizardPage currentPage) {
        String currPageName = currentPage.getName();
        IWizardPage nextPage = null;
        if (currPageName.equals("WIZPAGENAME_EGLDDBindingWizardPage")) {
            int bindingType = this.getEGLDDBindingConfiguration().getBindingType();
            EGLDDBindingWizardProvider[] providers = EGLDDBindingProviderRegistry.singleton.getEGLDDBindingWizardProviders();
            int i = 0;
            while (i < providers.length) {
                if (providers[i].bindingId == bindingType) {
                    IWizardPage[] pages = new IWizardPage[providers[i].eglDDBindingWizardPages.length + 1];
                    int j = 0;
                    while (j < providers[i].eglDDBindingWizardPages.length) {
                        pages[j + 1] = providers[i].eglDDBindingWizardPages[j].wizardpage;
                        ++j;
                    }
                    pages[0] = this.getPage("WIZPAGENAME_EGLDDBindingWizardPage");
                    this.PAGES = pages;
                    nextPage = pages[1];
                    ++this.currentPageIndex;
                    break;
                }
                ++i;
            }
        } else if (currPageName.equals("WIZPAGENAME_EGLBindingWizardPage")) {
            nextPage = this.currentPageIndex < this.PAGES.length ? this.PAGES[++this.currentPageIndex] : null;
        }
        return nextPage;
    }

    @Override
    public boolean performFinish() {
        try {
            this.executeFinishOperations();
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EGLLogger.log((Object)this, e);
            }
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            EGLLogger.log((Object)this, e);
            return false;
        }
        return true;
    }

    private void executeFinishOperations() throws InvocationTargetException, InterruptedException {
        this.fNewBinding = this.getEGLDDBindingConfiguration().executeAddBinding((IRunnableContext)this.getContainer());
    }

    public Object getNewBinding() {
        return this.fNewBinding;
    }
}

