/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.ServiceWizardPage;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;
import org.eclipse.edt.ide.ui.wizards.ServiceConfiguration;
import org.eclipse.edt.ide.ui.wizards.ServiceOperation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ServiceWizard
extends EGLPartWizard
implements INewWizard {
    private static final String WIZPAGENAME_ServiceWizardPage = "WIZPAGENAME_ServiceWizardPage";
    ServiceConfiguration configuration;
    ServiceWizardPage servicewizPage;

    public ServiceWizard() {
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_NEWEGLSERVICE);
        this.servicewizPage = new ServiceWizardPage(WIZPAGENAME_ServiceWizardPage);
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ServiceConfiguration();
        }
        return this.configuration;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.getConfiguration().init(workbench, selection);
        this.setWindowTitle(NewWizardMessages.NewEGLServiceWizardPageTitle);
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)this.servicewizPage);
    }

    protected ServiceOperation getServiceOperation() {
        ISchedulingRule rule = this.getCurrentSchedulingRule();
        ServiceOperation operation = null;
        operation = rule != null ? new ServiceOperation((ServiceConfiguration)this.getConfiguration(), this.servicewizPage.getSuperInterfaces(), this.servicewizPage.getCalledBasicPrograms(), rule) : new ServiceOperation((ServiceConfiguration)this.getConfiguration(), this.servicewizPage.getSuperInterfaces(), this.servicewizPage.getCalledBasicPrograms());
        return operation;
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        try {
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)this.getServiceOperation());
        }
        catch (InterruptedException e) {
            boolean dialogResult = false;
            if (e.getMessage().indexOf(58) != -1) {
                PartTemplateException pe = new PartTemplateException(e.getMessage());
                if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_NOT_FOUND) == 0) {
                    dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_ServiceWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                } else if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_DISABLED) != 0 && pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_CORRUPTED) == 0) {
                    dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_ServiceWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                }
                if (dialogResult) {
                    return this.performFinish();
                }
                return false;
            }
            e.printStackTrace();
            EGLLogger.log((Object)this, e);
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                e.printStackTrace();
                EGLLogger.log((Object)this, e);
            }
            return false;
        }
        this.openResource(this.configuration.getFile());
        return true;
    }
}

