/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.PPListElement;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.PPListElementSorter;
import org.eclipse.edt.ide.ui.internal.wizards.buildpaths.PPListLabelProvider;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProjectsWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IEGLProject fCurrJProject;
    private List<String> ImportProjectList;
    private List<String> fSelectedImportProjectList;
    private List<PPListElement> projects;
    private CheckedListDialogField fProjectsList;

    public void setfSelectedImportProjectList(List<String> fSelectedImportProjectList) {
        this.fSelectedImportProjectList = fSelectedImportProjectList;
        if (this.ImportProjectList == null) {
            this.ImportProjectList = fSelectedImportProjectList;
        }
    }

    public void updateSelectedImportProjectList(List<String> newSelectedImportProjectList) {
        ArrayList<PPListElement> newCheckedList = new ArrayList<PPListElement>();
        List currentCheckedList = this.fProjectsList.getCheckedElements();
        if (this.fProjectsList != null && this.projects != null) {
            String prjName;
            for (PPListElement prjElement : this.projects) {
                prjName = prjElement.getPath().lastSegment();
                if (!newSelectedImportProjectList.contains(prjName) || this.fSelectedImportProjectList.contains(prjName)) continue;
                newCheckedList.add(prjElement);
            }
            for (PPListElement prjElement : currentCheckedList) {
                prjName = prjElement.getPath().lastSegment();
                if (!newSelectedImportProjectList.contains(prjName) && this.fSelectedImportProjectList.contains(prjName)) continue;
                newCheckedList.add(prjElement);
            }
            this.fProjectsList.setCheckedElements(newCheckedList);
        }
    }

    public ProjectsWorkbookPage(ListDialogField classPathList) {
        this.fClassPathList = classPathList;
        ProjectsListListener listener = new ProjectsListListener();
        String[] buttonLabels = new String[]{NewWizardMessages.ProjectsWorkbookPageProjectsCheckallButton, NewWizardMessages.ProjectsWorkbookPageProjectsUncheckallButton};
        this.fProjectsList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new PPListLabelProvider());
        this.fProjectsList.setDialogFieldListener(listener);
        this.fProjectsList.setLabelText(NewWizardMessages.ProjectsWorkbookPageProjectsLabel);
        this.fProjectsList.setCheckAllButtonIndex(0);
        this.fProjectsList.setUncheckAllButtonIndex(1);
        this.fProjectsList.setViewerSorter(new PPListElementSorter());
    }

    public void init(IEGLProject jproject) {
        this.updateProjectsList(jproject);
    }

    private void updateProjectsList(IEGLProject currJProject) {
        try {
            IEGLModel jmodel = currJProject.getEGLModel();
            IEGLProject[] jprojects = jmodel.getEGLProjects();
            this.projects = new ArrayList<PPListElement>(jprojects.length);
            ArrayList<PPListElement> checkedProjects = new ArrayList<PPListElement>(jprojects.length);
            List cpelements = this.fClassPathList.getElements();
            int i = cpelements.size() - 1;
            while (i >= 0) {
                PPListElement cpelem = (PPListElement)cpelements.get(i);
                if (this.isEntryKind(cpelem.getEntryKind())) {
                    checkedProjects.add(cpelem);
                    this.projects.add(cpelem);
                }
                --i;
            }
            i = 0;
            while (i < jprojects.length) {
                IProject proj = jprojects[i].getProject();
                if (!currJProject.getProject().getName().equals(proj.getProject().getName())) {
                    boolean found = false;
                    for (PPListElement cpelem : this.projects) {
                        if (!proj.getName().equals(cpelem.getPath().lastSegment())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.projects.add(new PPListElement(this.fCurrJProject, 2, proj.getFullPath(), (IResource)proj));
                    }
                }
                ++i;
            }
            for (PPListElement prjElement : this.projects) {
                if (this.fSelectedImportProjectList == null || !this.fSelectedImportProjectList.contains(prjElement.getPath().lastSegment())) continue;
                checkedProjects.add(prjElement);
            }
            this.fProjectsList.setElements(this.projects);
            this.fProjectsList.setCheckedElements(checkedProjects);
        }
        catch (EGLModelException eGLModelException) {
            this.fProjectsList.setElements(new ArrayList(5));
        }
        this.fCurrJProject = currJProject;
    }

    private boolean checkIfBinaryProjExisting(List<PPListElement> existingProjects, PPListElement toCompare) {
        for (PPListElement current : existingProjects) {
            if (!current.getPath().lastSegment().equals(toCompare.getPath().lastSegment())) continue;
            return true;
        }
        return false;
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fProjectsList}, true, 0, 0, 5, 5);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getListControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(buttonBarWidth);
        return composite;
    }

    private void updateEGLPathList() {
        List projelements = this.fProjectsList.getCheckedElements();
        boolean remove = false;
        List cpelements = this.fClassPathList.getElements();
        int i = cpelements.size() - 1;
        while (i >= 0) {
            PPListElement cpe = (PPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind()) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                remove = true;
            }
            --i;
        }
        i = 0;
        while (i < projelements.size()) {
            cpelements.add(projelements.get(i));
            ++i;
        }
        if (remove || projelements.size() > 0) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    @Override
    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    @Override
    public void setSelection(List selElements) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    @Override
    public boolean isEntryKind(int kind) {
        return kind == 2;
    }

    private class ProjectsListListener
    implements IDialogFieldListener {
        private ProjectsListListener() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (ProjectsWorkbookPage.this.fCurrJProject != null) {
                ProjectsWorkbookPage.this.updateEGLPathList();
            }
        }
    }
}

