/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.generators;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.deployment.core.model.Restservice;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class ServiceUtilities {
    public static final String REST_SERVICE_ROOT_ID_ELEM = "restservices";

    public static String getUriMappingFileName(String contextRoot) {
        return String.valueOf(contextRoot) + "-uri.xml";
    }

    static boolean isStateful(Part part) {
        boolean isStateful = false;
        Annotation annot = part.getAnnotation("EGL Java Gen Service Stateful annotation");
        if (annot != null) {
            Object value = annot.getValue();
            isStateful = value instanceof Boolean ? (Boolean)value : false;
        }
        return isStateful;
    }

    static String getUri(LogicAndDataPart part, Restservice restService) {
        String uri = restService.getUri();
        if (uri.charAt(0) != '/') {
            uri = String.valueOf('/') + uri;
        }
        return uri;
    }

    public static String getRestServiceRoot() {
        return REST_SERVICE_ROOT_ID_ELEM;
    }

    public static boolean isTomcatProject(IProject project) {
        try {
            IRuntime primaryRuntime;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null && (primaryRuntime = facetedProject.getPrimaryRuntime()) != null) {
                org.eclipse.wst.server.core.IRuntime runtime = FacetUtil.getRuntime((IRuntime)primaryRuntime);
                return runtime != null && runtime.getRuntimeType() != null && runtime.getRuntimeType().getName().toLowerCase().contains("tomcat");
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return false;
    }
}

