/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.internal.testserver;

import eglx.lang.AnyException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.core.model.Restservice;
import org.eclipse.edt.ide.deployment.services.internal.testserver.EGLBasicDataSource1;
import org.eclipse.edt.ide.deployment.services.internal.testserver.EGLBasicDataSource2;
import org.eclipse.edt.ide.deployment.services.internal.testserver.SimpleDataSource;
import org.eclipse.edt.ide.testserver.TestServer;
import org.eclipse.edt.javart.JEERunUnit;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.javart.ide.IDEBindingResourceProcessor;
import org.eclipse.edt.javart.resources.StartupInfo;
import org.eclipse.edt.javart.resources.egldd.RuntimeDeploymentDesc;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;
import org.eclipse.edt.javart.services.servlet.rest.rpc.PreviewServiceServlet;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.plus.webapp.PlusDescriptorProcessor;
import org.eclipse.jetty.xml.XmlConfiguration;

public class ConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 10L;
    public static final String SERVLET_PATH = "config";
    public static final String ARG_DEFAULT_DD = "defaultDD";
    public static final String ARG_DD_ADDED = "ddAdded";
    public static final String ARG_DD_REMOVED = "ddRemoved";
    public static final String ARG_ORDERED_DDS = "orderedDDs";
    public static final String MAPPING_ARG_DELIMETER = "|";
    public static final String MAPPING_DELIMETER = ";";
    private final PreviewServiceServlet previewServlet;
    private final IDEBindingResourceProcessor bindingProcessor;
    private final TestServer server;
    private int nextDataSourceId;
    private List<String> orderedDDNames;
    private List<String> addedResourceRefs;
    private List<NamingEntry> addedDataSources;
    private final String basicDataSourceClassName;

    public ConfigServlet(PreviewServiceServlet previewServlet, IDEBindingResourceProcessor bindingProcessor, TestServer server) {
        this.previewServlet = previewServlet;
        this.bindingProcessor = bindingProcessor;
        this.server = server;
        this.orderedDDNames = new ArrayList<String>();
        this.addedResourceRefs = new ArrayList<String>();
        this.addedDataSources = new ArrayList<NamingEntry>();
        String className = null;
        try {
            Class.forName("org.apache.tomcat.dbcp.dbcp.BasicDataSource");
            className = EGLBasicDataSource1.class.getCanonicalName();
        }
        catch (Throwable throwable) {}
        if (className == null) {
            try {
                Class.forName("org.apache.commons.dbcp.BasicDataSource");
                className = EGLBasicDataSource2.class.getCanonicalName();
            }
            catch (Throwable throwable) {}
        }
        this.basicDataSourceClassName = className;
        if (this.basicDataSourceClassName == null) {
            TestServer.logWarning((String)"Apache's BasicDataSource class is not on the classpath so connection pooling for JNDI data sources will not be used. To enable connection pooling you can add an Apache Tomcat runtime to your workspace via Preferences > Server > Runtime Environments.");
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initRunUnit();
        String addedDDs = req.getParameter(ARG_DD_ADDED);
        String removedDDs = req.getParameter(ARG_DD_REMOVED);
        String defaultDD = req.getParameter(ARG_DEFAULT_DD);
        String orderedDDs = req.getParameter(ARG_ORDERED_DDS);
        boolean reconfigure = false;
        if (addedDDs != null && addedDDs.length() > 0) {
            reconfigure = true;
            this.parseDDFiles(addedDDs, true);
        }
        if (removedDDs != null && removedDDs.length() > 0) {
            reconfigure = true;
            this.parseDDFiles(removedDDs, false);
        }
        if (defaultDD != null) {
            this.server.logInfo("Default DD changed: " + defaultDD);
            try {
                this.bindingProcessor.setDefaultDD(defaultDD);
            }
            catch (AnyException e) {
                this.server.log((Exception)((Object)e));
            }
        }
        if (orderedDDs != null) {
            boolean bl = reconfigure = this.parseOrderedDDs(orderedDDs) || reconfigure;
        }
        if (reconfigure) {
            this.initRunUnit();
            this.previewServlet.clearServiceMappings();
            this.clearJNDIEnvironment();
            this.configureServiceMappings();
            this.configureJNDIEnvironment();
        }
    }

    protected void initRunUnit() {
        if (Runtime.getRunUnit() == null) {
            Runtime.setThreadRunUnit((RunUnit)new JEERunUnit(new StartupInfo("ConfigServlet", "", null)));
        }
    }

    public void parseDDFiles(String ddFiles, boolean added) {
        this.initRunUnit();
        List parsed = this.bindingProcessor.getResourceLocator().parseDDArgument(ddFiles, added);
        for (String[] next : parsed) {
            if (added) {
                this.server.logInfo("DD file added or changed: " + next[0] + ", " + next[1]);
                continue;
            }
            this.server.logInfo("DD file removed: " + next[0] + ", " + next[1]);
        }
    }

    public boolean parseOrderedDDs(String ddFiles) {
        this.server.logInfo("Parsing DD file order argument: " + ddFiles);
        List<String> oldNames = this.orderedDDNames;
        this.orderedDDNames = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(ddFiles, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            this.orderedDDNames.add(tok.nextToken());
        }
        int size = this.orderedDDNames.size();
        if (size == oldNames.size()) {
            int i = 0;
            while (i < size) {
                if (!oldNames.get(i).equals(this.orderedDDNames.get(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public void configureServiceMappings() {
        this.initRunUnit();
        List<String> names = this.orderedDDNames;
        int size = names.size();
        int i = size - 1;
        while (i >= 0) {
            RuntimeDeploymentDesc dd = this.bindingProcessor.getResourceLocator().getDeploymentDesc(names.get(i));
            if (dd instanceof DeploymentDesc) {
                List services = ((DeploymentDesc)dd).getRestservices();
                for (Restservice service : services) {
                    String className = service.getImplementation();
                    String uri = className.length() > 0 && className.charAt(0) != '/' ? String.valueOf('/') + className : className;
                    this.previewServlet.addServiceMapping(uri, className, service.isStateful());
                    this.server.logInfo("rest service mapping added: " + uri);
                }
            }
            --i;
        }
    }

    public void clearJNDIEnvironment() {
        for (String name : this.addedResourceRefs) {
            this.removeResourceRef(name);
        }
        for (NamingEntry entry : this.addedDataSources) {
            this.removeDataSource(entry);
        }
        this.addedResourceRefs.clear();
        this.addedDataSources.clear();
    }

    public void configureJNDIEnvironment() {
        this.initRunUnit();
        Map<String, IDEBindingResourceProcessor.SQLConnectionInfo> dataSources = this.getSQLDataSources();
        for (Map.Entry<String, IDEBindingResourceProcessor.SQLConnectionInfo> entry : dataSources.entrySet()) {
            try {
                String dataSourceClass;
                IDEBindingResourceProcessor.SQLConnectionInfo info = entry.getValue();
                Properties settings = new Properties();
                settings.put("driverClassName", info.driverClass);
                settings.put("username", info.username);
                settings.put("password", info.password);
                settings.put("url", info.url);
                if (this.basicDataSourceClassName != null) {
                    settings.put("maxActive", "5");
                    settings.put("maxIdle", "2");
                    settings.put("maxWait", "5000");
                    dataSourceClass = this.basicDataSourceClassName;
                } else {
                    dataSourceClass = SimpleDataSource.class.getCanonicalName();
                }
                this.addDataSource(entry.getKey(), dataSourceClass, settings);
            }
            catch (Exception e) {
                this.server.log(e);
            }
        }
        Set<String> refs = this.getSQLResourceRefs();
        block3: for (String jndiName : refs) {
            for (NamingEntry entry : this.addedDataSources) {
                if (!entry.getJndiName().equals(jndiName)) continue;
                this.addResourceRef(jndiName, DataSource.class);
                continue block3;
            }
        }
    }

    public void addDataSource(String name, String className, Properties settings) throws Exception {
        StringBuilder buf = new StringBuilder(200);
        String id = "ds" + ++this.nextDataSourceId;
        buf.append("<Configure id=\"Server\" class=\"org.eclipse.jetty.webapp.WebAppContext\"><New id=\"");
        buf.append(id);
        buf.append("\" class=\"org.eclipse.jetty.plus.jndi.Resource\"><Arg><Ref id=\"Server\"/></Arg><Arg>");
        buf.append(name);
        buf.append("</Arg><Arg><New class=\"");
        buf.append(className);
        buf.append("\">");
        for (Map.Entry<Object, Object> entry : settings.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            buf.append("<Set name=\"");
            buf.append(key);
            buf.append("\">");
            buf.append(value);
            buf.append("</Set>");
        }
        buf.append("</New></Arg></New></Configure>");
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.server.getWebApp().getClassLoader());
        try {
            XmlConfiguration config = new XmlConfiguration(buf.toString());
            config.configure((Object)this.server.getWebApp());
            Object boundResource = config.getIdMap().get(id);
            if (boundResource instanceof NamingEntry) {
                this.addedDataSources.add((NamingEntry)boundResource);
            }
            this.server.logInfo("data source added: name=" + name + " class=" + className);
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedLoader);
        }
    }

    public boolean removeDataSource(String name) {
        for (NamingEntry entry : this.addedDataSources) {
            if (!entry.getJndiName().equals(name)) continue;
            return this.removeDataSource(entry);
        }
        return false;
    }

    public boolean removeDataSource(NamingEntry dataSource) {
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.server.getWebApp().getClassLoader());
        try {
            dataSource.release();
            this.server.logInfo("data source removed: name=" + dataSource.getJndiName());
            return true;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedLoader);
        }
    }

    public void addResourceRef(String name, Class type) {
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.server.getWebApp().getClassLoader());
        try {
            try {
                PlusDescriptorProcessor processor = new PlusDescriptorProcessor();
                processor.bindResourceRef(this.server.getWebApp(), name, type);
                if (!this.addedResourceRefs.contains(name)) {
                    this.addedResourceRefs.add(name);
                }
                this.server.logInfo("resource-ref added: name=" + name + " type=" + type.getCanonicalName());
            }
            catch (Exception e) {
                this.server.log(e);
                Thread.currentThread().setContextClassLoader(savedLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedLoader);
        }
    }

    public boolean removeResourceRef(String name) {
        ClassLoader savedLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.server.getWebApp().getClassLoader());
        try {
            if (!name.startsWith("java:comp/env/")) {
                name = "java:comp/env/" + name;
            }
            InitialContext ctx = new InitialContext();
            ctx.unbind(name);
            this.server.logInfo("resource-ref removed: name=" + name);
            return true;
        }
        catch (Exception e) {
            this.server.log(e);
            return false;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedLoader);
        }
    }

    protected Map<String, IDEBindingResourceProcessor.SQLConnectionInfo> getSQLDataSources() {
        this.initRunUnit();
        HashMap<String, IDEBindingResourceProcessor.SQLConnectionInfo> dataSources = new HashMap<String, IDEBindingResourceProcessor.SQLConnectionInfo>();
        List<String> names = this.orderedDDNames;
        int size = names.size();
        int i = size - 1;
        while (i >= 0) {
            try {
                RuntimeDeploymentDesc dd = this.bindingProcessor.getResourceLocator().getDeploymentDesc(names.get(i));
                List bindings = dd.getSqlDatabaseBindings();
                for (SQLDatabaseBinding binding : bindings) {
                    String jndiName;
                    if (!binding.isDeployAsJndi()) continue;
                    IDEBindingResourceProcessor.SQLConnectionInfo info = null;
                    if (binding.isUseURI()) {
                        String uri = binding.getUri();
                        if (uri != null && uri.startsWith("workspace://")) {
                            info = this.bindingProcessor.getParsedConnectionProfileSettings(uri.substring(12));
                        }
                    } else {
                        info = new IDEBindingResourceProcessor.SQLConnectionInfo();
                        info.url = binding.getSqlDB();
                        info.driverClass = binding.getSqlJDBCDriverClass();
                        info.username = binding.getSqlID();
                        info.password = binding.getSqlPassword();
                        info.defaultSchema = binding.getSqlSchema();
                    }
                    if (info == null || (jndiName = binding.getJndiName()) == null || (jndiName = jndiName.trim()).length() <= 0 || dataSources.containsKey(jndiName)) continue;
                    dataSources.put(jndiName, info);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --i;
        }
        return dataSources;
    }

    protected Set<String> getSQLResourceRefs() {
        this.initRunUnit();
        HashSet<String> refs = new HashSet<String>();
        List<String> names = this.orderedDDNames;
        int size = names.size();
        int i = size - 1;
        while (i >= 0) {
            try {
                RuntimeDeploymentDesc dd = this.bindingProcessor.getResourceLocator().getDeploymentDesc(names.get(i));
                List bindings = dd.getSqlDatabaseBindings();
                for (SQLDatabaseBinding binding : bindings) {
                    String jndiName = null;
                    if (binding.isDeployAsJndi()) {
                        jndiName = binding.getJndiName();
                    } else if (binding.isUseURI() && binding.getUri() != null && binding.getUri().startsWith("jndi://")) {
                        jndiName = binding.getUri().substring(7);
                    }
                    if (jndiName == null || (jndiName = jndiName.trim()).length() <= 0) continue;
                    refs.add(jndiName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --i;
        }
        return refs;
    }
}

