/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.internal.testserver;

import eglx.lang.AnyException;
import eglx.lang.SysLib;
import java.io.InputStream;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.services.internal.testserver.ConfigServlet;
import org.eclipse.edt.ide.testserver.AbstractConfigurator;
import org.eclipse.edt.ide.testserver.TestServer;
import org.eclipse.edt.javart.ide.IDEBindingResourceProcessor;
import org.eclipse.edt.javart.ide.IDEResourceLocator;
import org.eclipse.edt.javart.services.servlet.proxy.AjaxProxyServlet;
import org.eclipse.edt.javart.services.servlet.rest.rpc.PreviewServiceServlet;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import resources.edt.binding.BindingResourceProcessor;

public class ServicesConfigurator
extends AbstractConfigurator {
    private String initialOrderedDDNames;
    private String initialDDFiles;
    private String initialDefaultDD;
    private ConfigServlet configServlet;
    private PreviewServiceServlet previewServlet;
    private IDEBindingResourceProcessor bindingProcessor;

    public int processNextArgument(List<String> arguments, int currentIndex) {
        String arg = arguments.get(currentIndex);
        if ("-odd".equals(arg)) {
            if (currentIndex + 1 < arguments.size()) {
                this.initialOrderedDDNames = arguments.get(currentIndex + 1).trim();
                ++currentIndex;
            } else {
                TestServer.logWarning((String)("Missing ordered deployment descriptor name list value for argument \"" + arg + "\""));
            }
            ++currentIndex;
        } else if ("-dd".equals(arg)) {
            if (currentIndex + 1 < arguments.size()) {
                this.initialDDFiles = arguments.get(currentIndex + 1).trim();
                ++currentIndex;
            } else {
                TestServer.logWarning((String)("Missing deployment descriptor file list value for argument \"" + arg + "\""));
            }
            ++currentIndex;
        } else if ("-ddd".equals(arg)) {
            if (currentIndex + 1 < arguments.size()) {
                this.initialDefaultDD = arguments.get(currentIndex + 1).trim();
                ++currentIndex;
            } else {
                TestServer.logWarning((String)("Missing default deployment descriptor value for argument \"" + arg + "\""));
            }
            ++currentIndex;
        }
        return currentIndex;
    }

    public void preStartup() throws Exception {
        this.server.appendConfiguration((Configuration)new EnvConfiguration());
    }

    public void configure() {
        WebAppContext context = this.server.getWebApp();
        this.previewServlet = new PreviewServiceServlet();
        context.addServlet(new ServletHolder((Servlet)this.previewServlet), "/restservices/*");
        context.addServlet(new ServletHolder((Servlet)new AjaxProxyServlet()), "/___proxy");
        this.bindingProcessor = new IDEBindingResourceProcessor(this.server.getIDEPort().intValue(), new IDEResourceLocator());
        SysLib.setBindingResourceProcessor((BindingResourceProcessor)this.bindingProcessor);
        if (this.initialDefaultDD != null) {
            try {
                this.bindingProcessor.setDefaultDD(this.initialDefaultDD);
            }
            catch (AnyException e) {
                this.server.log((Exception)((Object)e));
            }
        }
        try {
            this.bindingProcessor.getResourceLocator().setDDParser(DeploymentDesc.class.getMethod("createDeploymentDescriptor", String.class, InputStream.class));
        }
        catch (Exception e) {
            this.server.log("Could not use full deployment descriptor parser. REST services will not be available!");
            this.server.log(e);
        }
        this.configServlet = new ConfigServlet(this.previewServlet, this.bindingProcessor, this.server);
        context.addServlet(new ServletHolder((Servlet)this.configServlet), "/config");
        if (this.initialDDFiles != null && this.initialDDFiles.length() > 0) {
            this.configServlet.parseDDFiles(this.initialDDFiles, true);
        }
        if (this.initialOrderedDDNames != null && this.initialOrderedDDNames.length() > 0) {
            this.configServlet.parseOrderedDDs(this.initialOrderedDDNames);
        }
    }

    public void postConfigure() throws Exception {
        this.configServlet.configureServiceMappings();
        this.configServlet.configureJNDIEnvironment();
    }
}

