/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.operation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.gen.deployment.javascript.DeploymentDescGenerator;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.operation.AbstractDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.DeploymentResultMessageRequestor;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.rui.internal.util.Utils;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;

public class GenerateServiceBindJSFileOperation
extends AbstractDeploymentOperation {
    public static final String BIND_JS_FILE_SUFFIX = "-bnd.js";
    private String targetProjectName;
    private DeploymentDesc ddModel;
    private DeploymentContext context;

    public void preCheck(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        DeploymentDesc desc;
        if (context.getStatus() != 1 && (desc = context.getDeploymentDesc()).getRestBindings() != null && desc.getRestBindings().size() > 0) {
            context.setStatus(1);
        }
    }

    public void execute(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        if (context.getDeploymentDesc().getRUIApplication() == null || context.getDeploymentDesc().getRUIApplication().getRUIHandlers().size() == 0) {
            return;
        }
        this.context = context;
        this.ddModel = context.getDeploymentDesc();
        DeploymentResultMessageRequestor messageRequestor = new DeploymentResultMessageRequestor(resultsCollector);
        this.generateBindFile(context.getDeploymentDesc(), context.getTargetProject(), monitor, messageRequestor);
        for (DeploymentDesc egldd : context.getDependentModels()) {
            this.generateBindFile(egldd, context.getTargetProject(), monitor, messageRequestor);
        }
    }

    private void generateBindFile(DeploymentDesc egldd, IProject targetProject, IProgressMonitor monitor, DeploymentResultMessageRequestor messageRequestor) {
        try {
            DeploymentDescGenerator generator = new DeploymentDescGenerator();
            ByteArrayInputStream is = new ByteArrayInputStream(generator.generateBindFile(egldd));
            IFolder projectRootFolder = Utils.getContextDirectory((IProject)targetProject);
            IPath targetFilePath = projectRootFolder.getFullPath().append((IPath)new Path(String.valueOf(egldd.getName().toLowerCase()) + BIND_JS_FILE_SUFFIX));
            IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetFilePath);
            if (targetFile.exists()) {
                targetFile.setContents((InputStream)is, true, true, monitor);
            } else {
                targetFile.create((InputStream)is, true, monitor);
            }
            ((InputStream)is).close();
            messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8316", null, (String[])new String[]{targetFile.getProjectRelativePath().toPortableString()}));
        }
        catch (Exception e) {
            messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8306", null, (String[])new String[]{DeploymentUtilities.createExceptionMessage((Throwable)e)}));
        }
    }
}

