/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.EGLWidgetDefinitionDeleteStragegy;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class DeleteWidgetDefinitionOperation {
    public static final String DELETE_WIDGET_NAME_SAPERATOR = ":";
    private IEGLDocument currentDocument;
    private IFile currentFile;
    private TextEdit textEdit;

    public DeleteWidgetDefinitionOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public void deleteWidgetDefinition(String fieldName) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    File fileAST = this.currentDocument.getNewModelEGLFile();
                    String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
                    IPart modelPart = sharedWorkingCopy.getPart(partName);
                    ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
                    EGLWidgetDefinitionDeleteStragegy deleteStrategy = new EGLWidgetDefinitionDeleteStragegy(this.currentDocument, modelPart, rewrite);
                    deleteStrategy.deleteWidgetDefinition(fieldName);
                    deleteStrategy.modifyFormManagerEntities();
                    this.textEdit = deleteStrategy.getTextEdit();
                    if (this.textEdit != null) {
                        this.textEdit.apply((IDocument)this.currentDocument);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Delete Widget Reference: Error deleting reference", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Delete Widget Reference: Error creating working copy", (Throwable)e));
        }
    }
}

