/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.document.utils.EGLContainerUpdateStrategy;
import org.eclipse.edt.ide.rui.document.utils.EGLRUIHandlerUpdateStrategy;
import org.eclipse.edt.ide.rui.document.utils.EGLRUIWidgetUpdateStrategy;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class InsertWidgetReferenceOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;
    private int totalCharactersAdded;

    public InsertWidgetReferenceOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public int insertWidgetReference(final String insertText, int containerOffset, int containerLength, final int containerIndex) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    Node container = DocumentUtil.getWidgetNode(this.currentDocument, containerOffset, containerLength);
                    container.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(Handler handler) {
                            String typeName = InternUtil.intern((String)new String(handler.getSubType().getCanonicalName()));
                            if (typeName == Util.RUIHANDLER) {
                                EGLRUIHandlerUpdateStrategy updateStrategy = new EGLRUIHandlerUpdateStrategy(handler, InsertWidgetReferenceOperation.this.currentDocument);
                                InsertWidgetReferenceOperation.this.totalCharactersAdded = updateStrategy.updateHandler(insertText, containerIndex);
                            } else if (typeName == Util.RUIWIDGET) {
                                EGLRUIWidgetUpdateStrategy updateStrategy = new EGLRUIWidgetUpdateStrategy(handler, InsertWidgetReferenceOperation.this.currentDocument);
                                InsertWidgetReferenceOperation.this.totalCharactersAdded = updateStrategy.insertTargetWidget(insertText);
                            }
                            return false;
                        }

                        public boolean visit(NewExpression newExpression) {
                            EGLContainerUpdateStrategy updateStrategy = new EGLContainerUpdateStrategy((Node)newExpression, InsertWidgetReferenceOperation.this.currentDocument);
                            InsertWidgetReferenceOperation.this.totalCharactersAdded = updateStrategy.updateContainer(insertText, containerIndex);
                            return false;
                        }

                        public boolean visit(SimpleName simpleName) {
                            EGLContainerUpdateStrategy updateStrategy = new EGLContainerUpdateStrategy((Node)simpleName, InsertWidgetReferenceOperation.this.currentDocument);
                            InsertWidgetReferenceOperation.this.totalCharactersAdded = updateStrategy.updateContainer(insertText, containerIndex);
                            return false;
                        }
                    });
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Insert Widget Reference: Error inserting widget reference", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Insert Widget Reference: Error creating working copy", (Throwable)e));
        }
        return this.totalCharactersAdded;
    }
}

