/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.project;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.rui.internal.project.CommonUtilities;
import org.eclipse.edt.ide.rui.internal.wizards.RuiNewWizardMessages;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ImportSampleCodeOperation
extends WorkspaceModifyOperation {
    private String resourcePluginName = "org.eclipse.edt.ide.ui.resources";
    private String libraryResourceFolder = "/org.eclipse.edt.ide.ui.rui/";
    private String sampleProjectName;
    private String destinationProjectName;

    public ImportSampleCodeOperation(ISchedulingRule rule, String sampleProjectName, String destinationProjectName) {
        super(rule);
        this.sampleProjectName = sampleProjectName;
        this.destinationProjectName = destinationProjectName;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.sampleProjectName != null && this.destinationProjectName != null) {
            this.importSampleCode(monitor);
        }
    }

    private void importSampleCode(IProgressMonitor monitor) {
        block18: {
            IProject destProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.destinationProjectName);
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (destProject.exists()) {
                try {
                    try {
                        URL url = CommonUtilities.getWidgetProjectURL(this.resourcePluginName, this.libraryResourceFolder, this.sampleProjectName);
                        if (url == null) break block18;
                        ZipFile sampleSource = new ZipFile(url.getFile());
                        try {
                            Enumeration<? extends ZipEntry> entries = sampleSource.entries();
                            monitor.beginTask(String.valueOf(RuiNewWizardMessages.ImportTask) + this.destinationProjectName, sampleSource.size());
                            while (entries.hasMoreElements()) {
                                ZipEntry entry = entries.nextElement();
                                monitor.subTask(entry.getName());
                                try {
                                    if (entry.isDirectory()) {
                                        destProject.getFolder((IPath)new Path(entry.getName())).create(true, true, monitor);
                                    } else {
                                        IFile file = destProject.getFile((IPath)new Path(entry.getName()));
                                        if (!file.getName().equals(".project")) {
                                            if (!file.exists()) {
                                                file.create(sampleSource.getInputStream(entry), true, monitor);
                                            } else {
                                                file.setContents(sampleSource.getInputStream(entry), true, true, monitor);
                                            }
                                        }
                                    }
                                }
                                catch (Exception exception) {}
                                monitor.worked(1);
                            }
                        }
                        finally {
                            sampleSource.close();
                        }
                    }
                    catch (Exception e) {
                        EGLLogger.log((Object)((Object)this), (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
    }
}

