/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.internal.core.builder.AccumulatingProblemrRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.gen.javascript.JavaScriptAliaser;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.DeleteWidgetDefinitionOperation;
import org.eclipse.edt.ide.rui.document.utils.DeleteWidgetReferenceOperation;
import org.eclipse.edt.ide.rui.document.utils.DocumentCache;
import org.eclipse.edt.ide.rui.document.utils.GetEventHandlerFunctionsOperation;
import org.eclipse.edt.ide.rui.document.utils.GetEventValueOperation;
import org.eclipse.edt.ide.rui.document.utils.GridLayoutOperation;
import org.eclipse.edt.ide.rui.document.utils.IVEConstants;
import org.eclipse.edt.ide.rui.document.utils.InsertEventHandlingFunctionOperation;
import org.eclipse.edt.ide.rui.document.utils.InsertFieldOperation;
import org.eclipse.edt.ide.rui.document.utils.InsertFunctionOperation;
import org.eclipse.edt.ide.rui.document.utils.InsertWidgetOperation;
import org.eclipse.edt.ide.rui.document.utils.InsertWidgetReferenceOperation;
import org.eclipse.edt.ide.rui.document.utils.MoveWidgetReferenceOperation;
import org.eclipse.edt.ide.rui.document.utils.NameGenerator;
import org.eclipse.edt.ide.rui.document.utils.RemoveEventValueOperation;
import org.eclipse.edt.ide.rui.document.utils.RemoveLayoutPropertyValueOperation;
import org.eclipse.edt.ide.rui.document.utils.RemovePropertyValueOperation;
import org.eclipse.edt.ide.rui.document.utils.SetEventValueOperation;
import org.eclipse.edt.ide.rui.document.utils.SetLayoutPropertyValueOperation;
import org.eclipse.edt.ide.rui.document.utils.SetPropertyValueOperation;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.server.EventValue;
import org.eclipse.edt.ide.rui.server.PropertyValue;
import org.eclipse.edt.ide.rui.utils.JavaScriptPreviewGenerator;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.edt.ide.rui.utils.WorkingCopyGenerationResult;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public class EvEditorProvider {
    private static int PROVIDER_KEY = 0;
    public static final IPath ROOT_GENERATION_DIRECTORY = Activator.getDefault().getStateLocation();
    protected IEGLDocument _currentDocument = null;
    protected IFile _currentFile = null;
    protected EGLEditor _eglEditor = null;
    protected IPath _generationDirectory = null;
    protected WorkingCopyGenerationResult _generationResult = null;
    protected JavaScriptPreviewGenerator _generator = null;
    protected DocumentCache _documentCache = null;
    protected IDocumentPartitioner _documentPartitioner = null;
    public static IWorkbenchPage workbenchPage;

    public EvEditorProvider(EGLEditor eglEditor) {
        this._eglEditor = eglEditor;
        this._currentFile = ((IFileEditorInput)this._eglEditor.getEditorInput()).getFile();
        this._currentDocument = (IEGLDocument)this._eglEditor.getDocumentProvider().getDocument((Object)this._eglEditor.getEditorInput());
        this._generator = new JavaScriptPreviewGenerator(this._currentFile);
        this._generationDirectory = ROOT_GENERATION_DIRECTORY.append(Integer.toString(++PROVIDER_KEY));
        this._documentCache = new DocumentCache(this._currentDocument, this._currentFile);
        workbenchPage = eglEditor.getSite().getPage();
        this.cleanupGeneratedJavaScript();
    }

    public void eglpathUpdated() {
        this._generator = new JavaScriptPreviewGenerator(this._currentFile);
    }

    public boolean canCreateRUIHandler() {
        return false;
    }

    public void cleanupGeneratedJavaScript() {
        File genDir = this._generationDirectory.toFile();
        if (genDir.exists()) {
            this.deleteFiles(genDir);
            genDir.delete();
        }
    }

    public IPath getGenerationDirectory() {
        return this._generationDirectory;
    }

    public void create(IProject widgetProject, String strWidgetPackage, String strWidgetType, int iStatementOffset, int iStatementLength, int iIndex, String widgetTemplate, String functionTemplate, String strWidgetName) {
        this._documentCache.clear();
        String fieldName = strWidgetName;
        if (fieldName == null) {
            NameGenerator generator = new NameGenerator(this._currentFile);
            fieldName = generator.generateFieldName(strWidgetType);
        }
        if (fieldName != null) {
            int insertIndex = 0;
            try {
                IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this._currentFile);
                IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
                sharedWorkingCopy.reconcile(false, null);
                try {
                    String partName = new Path(this._currentFile.getName()).removeFileExtension().toString();
                    IPart part = sharedWorkingCopy.getPart(partName);
                    if (part.exists()) {
                        insertIndex = part.getFields().length;
                        if (iStatementOffset == 0 && iStatementLength == 0) {
                            iStatementOffset = part.getSourceRange().getOffset();
                            iStatementLength = part.getSourceRange().getLength();
                        }
                    }
                }
                finally {
                    sharedWorkingCopy.destroy();
                }
            }
            catch (EGLModelException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Create: Error creating new variable", (Throwable)e));
            }
            try {
                this.clearDocumentPartitioner();
                InsertWidgetReferenceOperation operation = new InsertWidgetReferenceOperation(this._currentDocument, this._currentFile);
                operation.insertWidgetReference(fieldName, iStatementOffset, iStatementLength, iIndex);
                InsertWidgetOperation insertWidgetOp = new InsertWidgetOperation(this._currentDocument, this._currentFile);
                insertWidgetOp.insertWidget(fieldName, strWidgetPackage, strWidgetType, widgetTemplate, insertIndex);
                if (functionTemplate != null) {
                    InsertFunctionOperation insertFunctionOperation = new InsertFunctionOperation(this._currentDocument, this._currentFile);
                    insertFunctionOperation.insertFunction(functionTemplate);
                }
            }
            finally {
                this.restoreDocumentPartitioner();
            }
        }
    }

    public void createField(String fieldTypePackage, String fieldName, String fieldType, String template) {
        this._documentCache.clear();
        int insertIndex = 0;
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this._currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                String partName = new Path(this._currentFile.getName()).removeFileExtension().toString();
                IPart part = sharedWorkingCopy.getPart(partName);
                if (part.exists()) {
                    insertIndex = part.getFields().length;
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Create: Error creating new variable", (Throwable)e));
        }
        InsertFieldOperation insertFieldOperation = new InsertFieldOperation(this._currentDocument, this._currentFile);
        insertFieldOperation.insertField(fieldTypePackage, fieldName, fieldType, template, insertIndex);
    }

    public NestedFunction createEventHandlingFunction(String strName) {
        InsertEventHandlingFunctionOperation operation = new InsertEventHandlingFunctionOperation(this._currentDocument, this._currentFile);
        operation.insertFunction(strName);
        return null;
    }

    public void createRUIHandler() {
    }

    public int delete(int iParentStatementOffset, int iParentStatementLength, int iWidgetIndex) {
        this._documentCache.clear();
        if (iParentStatementOffset == 0 && iParentStatementLength == 0) {
            try {
                IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this._currentFile);
                IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
                sharedWorkingCopy.reconcile(false, null);
                try {
                    String partName = new Path(this._currentFile.getName()).removeFileExtension().toString();
                    IPart part = sharedWorkingCopy.getPart(partName);
                    if (part.exists()) {
                        iParentStatementOffset = part.getSourceRange().getOffset();
                        iParentStatementLength = part.getSourceRange().getLength();
                    }
                }
                finally {
                    sharedWorkingCopy.destroy();
                }
            }
            catch (EGLModelException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Delete: Error deleting variable", (Throwable)e));
            }
        }
        try {
            this.clearDocumentPartitioner();
            DeleteWidgetReferenceOperation deleteReferenceOperation = new DeleteWidgetReferenceOperation(this._currentDocument, this._currentFile);
            int deleted = deleteReferenceOperation.deleteWidgetReference(iParentStatementOffset, iParentStatementLength, iWidgetIndex);
            DeleteWidgetDefinitionOperation deleteDefinitionOperation = new DeleteWidgetDefinitionOperation(this._currentDocument, this._currentFile);
            String deletedWidgetName = deleteReferenceOperation.getDeletedWidgetName();
            if (deletedWidgetName.contains(":")) {
                String[] deletedWidgetNames = deletedWidgetName.split(":");
                int i = 0;
                while (i < deletedWidgetNames.length) {
                    deleteDefinitionOperation.deleteWidgetDefinition(deletedWidgetNames[i]);
                    ++i;
                }
            } else {
                deleteDefinitionOperation.deleteWidgetDefinition(deleteReferenceOperation.getDeletedWidgetName());
            }
            int n = deleted;
            return n;
        }
        finally {
            this.restoreDocumentPartitioner();
        }
    }

    private void deleteFiles(File directory) {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.deleteFiles(files[i]);
            }
            files[i].delete();
            ++i;
        }
    }

    public void generateJavaScript() {
        this._generationResult = this._generator.generateJavaScript(this._generationDirectory);
    }

    public String getEventDefaultFunctionName(String strEventName) {
        NameGenerator generator = new NameGenerator(this._currentFile);
        return generator.generateFieldName(strEventName);
    }

    public String[] getEventHandlingFunctionNames() {
        GetEventHandlerFunctionsOperation operation = new GetEventHandlerFunctionsOperation(this._currentDocument, this._currentFile);
        return operation.getFunctions();
    }

    public int getFunctionFirstLineOffset(String functionName) {
        GetEventHandlerFunctionsOperation operation = new GetEventHandlerFunctionsOperation(this._currentDocument, this._currentFile);
        return operation.getFunctionFirstLineOffset(functionName);
    }

    public int[] getFunctionNameRange(String functionName) {
        GetEventHandlerFunctionsOperation operation = new GetEventHandlerFunctionsOperation(this._currentDocument, this._currentFile);
        return operation.getFunctionNameRange(functionName);
    }

    public WorkingCopyGenerationResult getLastGenerationResult() {
        return this._generationResult;
    }

    public EventValue getEventValue(int iStatementOffset, int iStatementLength, String strEventName) {
        GetEventValueOperation operation = new GetEventValueOperation(this._currentDocument, this._currentFile);
        return operation.getEventValue(strEventName, iStatementOffset, iStatementLength);
    }

    public PropertyValue getPropertyValue(int iStatementOffset, int iStatementLength, String strPropertyName, String strPropertyType) {
        return this._documentCache.getPropertyValue(iStatementOffset, iStatementLength, strPropertyName, strPropertyType);
    }

    public PropertyValue getLayoutPropertyValue(int iStatementOffset, int iStatementLength, String strPropertyName, String strPropertyType) {
        return this._documentCache.getLayoutPropertyValue(iStatementOffset, iStatementLength, strPropertyName, strPropertyType);
    }

    public String getWebPageURL(String strPortNumber) {
        StringBuffer result = new StringBuffer();
        IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this._currentFile);
        if (modelFile.exists()) {
            String[] packageName = ((EGLFile)modelFile).getPackageName();
            result.append("http://localhost:");
            result.append(strPortNumber);
            result.append("/");
            result.append(modelFile.getEGLProject().getElementName());
            result.append("/");
            result.append(JavaScriptAliaser.packageNameAlias((String[])packageName, (char)'/'));
            result.append("/");
            result.append(JavaScriptAliaser.getAlias((String)new Path(modelFile.getElementName()).removeFileExtension().addFileExtension("html").toString()));
        }
        return result.toString().replaceAll(" ", "%20");
    }

    public String getWidgetDefaultName(String strWidgetType) {
        NameGenerator generator = new NameGenerator(this._currentFile);
        return generator.generateFieldName(strWidgetType);
    }

    public String getWidgetProjectName(String strWidgetPackageName, String strWidgetTypeName) {
        IEGLProject project = EGLCore.create((IProject)this._currentFile.getProject());
        try {
            IPart part = project.findPart(strWidgetPackageName, strWidgetTypeName);
            if (part != null && part.exists()) {
                return part.getEGLProject().getElementName();
            }
        }
        catch (EGLModelException eGLModelException) {}
        return "";
    }

    public List getWidgetNames() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this._currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    String partName = new Path(this._currentFile.getName()).removeFileExtension().toString();
                    IPart modelPart = sharedWorkingCopy.getPart(partName);
                    IField[] fields = modelPart.getFields();
                    int i = 0;
                    while (i < fields.length) {
                        IField field = fields[i];
                        result.add(field.getElementName());
                        ++i;
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Widget Namesr: Error getting field name", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Widget Names: Error building names list", (Throwable)e));
        }
        return result;
    }

    public List getExistingFunctionNames() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this._currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    String partName = new Path(this._currentFile.getName()).removeFileExtension().toString();
                    IPart modelPart = sharedWorkingCopy.getPart(partName);
                    IFunction[] functions = modelPart.getFunctions();
                    int i = 0;
                    while (i < functions.length) {
                        IFunction function = functions[i];
                        result.add(function.getElementName());
                        ++i;
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "getFunctionNames: Error generating function name", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Get Function Names: Error building names list", (Throwable)e));
        }
        return result;
    }

    public boolean isVESupportType() {
        return Util.isVESupportType(this._currentFile, this._currentDocument);
    }

    public boolean isRUIWidget() {
        return Util.isRUIWidget(this._currentFile);
    }

    public String getRUIWidgetId() {
        return Util.getRUIWidgetId(this._currentFile);
    }

    public boolean isValidName(String strName) {
        if (strName == null || strName.length() == 0) {
            return false;
        }
        if (strName.length() > 128) {
            return false;
        }
        ICompilerOptions compilerOptions = new ICompilerOptions(){

            public boolean isVAGCompatible() {
                return false;
            }

            public boolean isAliasJSFNames() {
                return false;
            }
        };
        AccumulatingProblemrRequestor pRequestor = new AccumulatingProblemrRequestor();
        EGLNameValidator.validate((String)strName, (int)1, (IProblemRequestor)pRequestor, (ICompilerOptions)compilerOptions);
        return pRequestor.getProblems().size() == 0;
    }

    public int[] move(int iSourceParentStatementOffset, int iSourceParentStatementLength, int iSourceChildIndex, int iTargetParentStatementOffset, int iTargetParentStatementLength, int iTargetChildIndex) {
        this._documentCache.clear();
        if (iSourceParentStatementOffset == 0 && iSourceParentStatementLength == 0 || iTargetParentStatementOffset == 0 && iTargetParentStatementLength == 0) {
            try {
                IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this._currentFile);
                IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
                sharedWorkingCopy.reconcile(false, null);
                try {
                    String partName = new Path(this._currentFile.getName()).removeFileExtension().toString();
                    IPart part = sharedWorkingCopy.getPart(partName);
                    if (part.exists()) {
                        if (iSourceParentStatementOffset == 0 && iSourceParentStatementLength == 0) {
                            iSourceParentStatementOffset = part.getSourceRange().getOffset();
                            iSourceParentStatementLength = part.getSourceRange().getLength();
                        }
                        if (iTargetParentStatementOffset == 0 && iTargetParentStatementLength == 0) {
                            iTargetParentStatementOffset = part.getSourceRange().getOffset();
                            iTargetParentStatementLength = part.getSourceRange().getLength();
                        }
                    }
                }
                finally {
                    sharedWorkingCopy.destroy();
                }
            }
            catch (EGLModelException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Move: Error moving variable", (Throwable)e));
            }
        }
        try {
            this.clearDocumentPartitioner();
            MoveWidgetReferenceOperation operation = new MoveWidgetReferenceOperation(this._currentDocument, this._currentFile);
            int[] nArray = operation.moveWidget(iSourceParentStatementOffset, iSourceParentStatementLength, iSourceChildIndex, iTargetParentStatementOffset, iTargetParentStatementLength, iTargetChildIndex);
            return nArray;
        }
        finally {
            this.restoreDocumentPartitioner();
        }
    }

    public void gridlayoutOpertion(int iSourceParentStatementOffset, int iSourceParentStatementLength, int row, int column, int operationType) {
        this._documentCache.clear();
        try {
            this.clearDocumentPartitioner();
            GridLayoutOperation operation = new GridLayoutOperation(this._currentDocument, this._currentFile);
            operation.doOpeation(iSourceParentStatementOffset, iSourceParentStatementLength, row, column, operationType);
        }
        finally {
            this.restoreDocumentPartitioner();
        }
    }

    public boolean requiresDependentProjects(IProject projectEditorInput, IProject projectDependency) {
        EGLProject eglProject = (EGLProject)EGLCore.create((IProject)projectEditorInput);
        return !projectEditorInput.equals((Object)projectDependency) && !eglProject.isOnEGLPath((IResource)projectDependency);
    }

    public void setEventValue(int iStatementOffset, int iStatementLength, String strEventName, String strEventvalue) {
        this._documentCache.clear();
        if (strEventvalue != null && !"".equals(strEventvalue)) {
            SetEventValueOperation operation = new SetEventValueOperation(this._currentDocument, this._currentFile);
            operation.setEventValue(strEventName, strEventvalue, iStatementOffset, iStatementLength);
        } else {
            RemoveEventValueOperation operation = new RemoveEventValueOperation(this._currentDocument, this._currentFile);
            operation.removeEventValue(strEventName, iStatementOffset, iStatementLength);
        }
    }

    public int setPropertyValue(int iStatementOffset, int iStatementLength, String strPropertyName, String strPropertyType, PropertyValue propertyValue) {
        Object operation;
        String theValue;
        this._documentCache.clear();
        StringBuffer thePropertyValue = new StringBuffer();
        ArrayList values = propertyValue.values;
        if (IVEConstants.STRING_ARRAY_TYPE.equals(strPropertyType)) {
            thePropertyValue.append("[");
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                thePropertyValue.append("\"" + this.escape(value) + "\"");
                if (!iterator.hasNext()) continue;
                thePropertyValue.append(",");
            }
            thePropertyValue.append("]");
        } else if (IVEConstants.STRING_TYPE.equals(strPropertyType)) {
            theValue = (String)values.get(0);
            if (theValue.length() > 0) {
                thePropertyValue.append("\"" + this.escape(theValue) + "\"");
            }
        } else if (IVEConstants.COLOR_TYPE.equals(strPropertyType)) {
            theValue = (String)values.get(0);
            if (theValue.length() > 0) {
                thePropertyValue.append("\"" + theValue + "\"");
            }
        } else {
            thePropertyValue.append((String)values.get(0));
        }
        int charactersChanged = 0;
        if (thePropertyValue.length() > 0) {
            operation = new SetPropertyValueOperation(this._currentDocument, this._currentFile);
            charactersChanged = ((SetPropertyValueOperation)operation).setPropertyValue(strPropertyName, thePropertyValue.toString(), strPropertyType, iStatementOffset, iStatementLength);
        } else {
            operation = new RemovePropertyValueOperation(this._currentDocument, this._currentFile);
            charactersChanged = ((RemovePropertyValueOperation)operation).removePropertyValue(strPropertyName, iStatementOffset, iStatementLength);
        }
        return charactersChanged;
    }

    public int setLayoutPropertyValue(int iStatementOffset, int iStatementLength, String strPropertyName, String strPropertyType, PropertyValue propertyValue) {
        Object operation;
        String theValue;
        this._documentCache.clear();
        StringBuffer thePropertyValue = new StringBuffer();
        ArrayList values = propertyValue.values;
        if (IVEConstants.STRING_ARRAY_TYPE.equals(strPropertyType)) {
            thePropertyValue.append("[");
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                thePropertyValue.append("\"" + this.escape(value) + "\"");
                if (!iterator.hasNext()) continue;
                thePropertyValue.append(",");
            }
            thePropertyValue.append("]");
        } else if (IVEConstants.STRING_TYPE.equals(strPropertyType)) {
            theValue = (String)values.get(0);
            if (theValue.length() > 0) {
                thePropertyValue.append("\"" + this.escape(theValue) + "\"");
            }
        } else if (IVEConstants.COLOR_TYPE.equals(strPropertyType)) {
            theValue = (String)values.get(0);
            if (theValue.length() > 0) {
                thePropertyValue.append("\"" + theValue + "\"");
            }
        } else {
            thePropertyValue.append((String)values.get(0));
        }
        int charactersChanged = 0;
        if (thePropertyValue.length() > 0) {
            operation = new SetLayoutPropertyValueOperation(this._currentDocument, this._currentFile);
            charactersChanged = ((SetLayoutPropertyValueOperation)operation).setPropertyValue(strPropertyName, thePropertyValue.toString(), strPropertyType, iStatementOffset, iStatementLength);
        } else {
            operation = new RemoveLayoutPropertyValueOperation(this._currentDocument, this._currentFile);
            charactersChanged = ((RemoveLayoutPropertyValueOperation)operation).removePropertyValue(strPropertyName, iStatementOffset, iStatementLength);
        }
        return charactersChanged;
    }

    public void clearCache() {
        this._documentCache.clear();
    }

    private void clearDocumentPartitioner() {
        this._documentPartitioner = this._currentDocument.getDocumentPartitioner();
        this._documentPartitioner.disconnect();
        this._currentDocument.setDocumentPartitioner(null);
    }

    private void restoreDocumentPartitioner() {
        this._currentDocument.setDocumentPartitioner(this._documentPartitioner);
        this._documentPartitioner.connect((IDocument)this._currentDocument);
    }

    private String escape(String value) {
        String str = value;
        str = str.replaceAll("\\\\", "\\\\\\\\");
        str = str.replaceAll("\\\"", "\\\\\"");
        str = str.replaceAll("\\\b", "\\\\b");
        str = str.replaceAll("\\\f", "\\\\f");
        str = str.replaceAll("\\\n", "\\\\n");
        str = str.replaceAll("\\\r", "\\\\r");
        str = str.replaceAll("\\\t", "\\\\t");
        return str;
    }
}

