/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.edt.debug.core.IEGLStackFrame;
import org.eclipse.edt.debug.core.IEGLThread;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaThread;
import org.eclipse.edt.debug.core.java.SMAPUtil;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugTarget;
import org.eclipse.edt.debug.internal.core.java.EGLJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;

public class EGLJavaThread
extends EGLJavaDebugElement
implements IEGLJavaThread {
    private static final EGLJavaStackFrame[] EMPTY_FRAMES = new EGLJavaStackFrame[0];
    private final IJavaThread javaThread;
    private EGLJavaStackFrame[] eglFrames;
    private IStackFrame[] previousJavaFrames;
    private Map<IStackFrame, EGLJavaStackFrame> currentStackFrames;
    private Map<IStackFrame, EGLJavaStackFrame> previousStackFrames;
    private boolean steppingFromEGL;
    private final Object evaluationLock = new Object();

    public EGLJavaThread(EGLJavaDebugTarget target, IJavaThread thread) {
        super(target);
        this.javaThread = thread;
        this.disposeStackFrames();
    }

    protected void disposeStackFrames() {
        if (this.currentStackFrames != null && this.currentStackFrames != Collections.EMPTY_MAP) {
            this.previousStackFrames = this.currentStackFrames;
        }
        this.currentStackFrames = null;
        this.eglFrames = null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IThread.class || adapter == EGLJavaThread.class || adapter == IEGLThread.class || adapter == IEGLJavaThread.class) {
            return this;
        }
        if (adapter == IStackFrame.class || adapter == EGLJavaStackFrame.class || adapter == IEGLStackFrame.class || adapter == IEGLJavaStackFrame.class) {
            try {
                return this.getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (adapter == IJavaThread.class) {
            return this.javaThread;
        }
        return super.getAdapter(adapter);
    }

    public boolean canResume() {
        return this.javaThread.canResume();
    }

    public boolean canSuspend() {
        return this.javaThread.canSuspend();
    }

    public boolean isSuspended() {
        return this.javaThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.javaThread.resume();
    }

    public void suspend() throws DebugException {
        this.javaThread.suspend();
    }

    public boolean canStepInto() {
        return this.javaThread.canStepInto();
    }

    public boolean canStepOver() {
        return this.javaThread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.javaThread.canStepReturn();
    }

    public boolean isStepping() {
        return this.javaThread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.updateSteppingFromEGL(null);
        this.javaThread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.updateSteppingFromEGL(null);
        this.javaThread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.updateSteppingFromEGL(null);
        this.javaThread.stepReturn();
    }

    public void updateSteppingFromEGL(IJavaStackFrame frame) {
        if (frame == null) {
            frame = this.eglFrames == null || this.eglFrames.length == 0 ? null : this.eglFrames[0].getJavaStackFrame();
        }
        this.steppingFromEGL = frame != null ? SMAPUtil.isEGLStratum(frame) : false;
    }

    public boolean canTerminate() {
        return this.javaThread.canTerminate();
    }

    public boolean isTerminated() {
        return this.javaThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.javaThread.terminate();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        this.refreshFrames();
        return this.eglFrames;
    }

    protected synchronized void refreshFrames() throws DebugException {
        if (this.eglFrames == null) {
            IStackFrame[] javaFrames = this.javaThread.getStackFrames();
            if (javaFrames.length > 0) {
                int size = 0;
                EGLJavaStackFrame[] newEGLFrames = new EGLJavaStackFrame[javaFrames.length];
                this.currentStackFrames = new HashMap<IStackFrame, EGLJavaStackFrame>(javaFrames.length);
                int indexOfTopEGLFrame = -1;
                int i = 0;
                while (i < javaFrames.length) {
                    if (SMAPUtil.isEGLStratum((IJavaStackFrame)javaFrames[i])) {
                        indexOfTopEGLFrame = i;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < javaFrames.length) {
                    if (!this.getEGLJavaDebugTarget().filterRuntimes() || indexOfTopEGLFrame == -1 || !this.steppingFromEGL && indexOfTopEGLFrame > i || i == 0 || !this.filterFrameType((IJavaStackFrame)javaFrames[i]) && (i + 1 < javaFrames.length || !this.isMainMethod((IJavaStackFrame)javaFrames[i]))) {
                        EGLJavaStackFrame frame;
                        EGLJavaStackFrame eGLJavaStackFrame = frame = this.previousStackFrames == null ? null : this.previousStackFrames.get(javaFrames[i]);
                        if (frame == null) {
                            frame = new EGLJavaStackFrame((IJavaStackFrame)javaFrames[i], this);
                        } else {
                            frame.bind((IJavaStackFrame)javaFrames[i]);
                        }
                        this.currentStackFrames.put(javaFrames[i], frame);
                        newEGLFrames[size++] = frame;
                    }
                    ++i;
                }
                if (size == newEGLFrames.length) {
                    this.eglFrames = newEGLFrames;
                } else {
                    this.eglFrames = new EGLJavaStackFrame[size];
                    System.arraycopy(newEGLFrames, 0, this.eglFrames, 0, size);
                }
            } else {
                this.currentStackFrames = Collections.EMPTY_MAP;
                this.eglFrames = EMPTY_FRAMES;
            }
            this.previousJavaFrames = javaFrames;
        }
    }

    public boolean hasStackFrames() throws DebugException {
        return this.javaThread.hasStackFrames();
    }

    public int getPriority() throws DebugException {
        return this.javaThread.getPriority();
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return this.javaThread.getName();
    }

    public IBreakpoint[] getBreakpoints() {
        return this.javaThread.getBreakpoints();
    }

    @Override
    public void handleDebugEvents(DebugEvent[] events) {
        if (events == null || events.length == 0) {
            return;
        }
        ArrayList<DebugEvent> savedEvents = new ArrayList<DebugEvent>();
        Object src = events[0].getSource();
        if (src == this.javaThread) {
            boolean bpHit = false;
            int i = 0;
            while (i < events.length) {
                if (events[i].getDetail() == 16 && events[i].getKind() == 2) {
                    bpHit = true;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < events.length) {
                switch (events[i].getKind()) {
                    case 4: {
                        this.fireCreationEvent();
                        break;
                    }
                    case 8: {
                        this.getEGLJavaDebugTarget().removeThread(this.javaThread);
                        this.fireTerminateEvent();
                        break;
                    }
                    case 1: {
                        IJavaStackFrame topJavaFrame;
                        if (this.steppingFromEGL && this.getEGLJavaDebugTarget().filterRuntimes() && events[i].getDetail() == 1) {
                            EGLJavaStackFrame topEGLFrame;
                            topJavaFrame = this.previousJavaFrames == null || this.previousJavaFrames.length == 0 ? null : this.previousJavaFrames[0];
                            EGLJavaStackFrame eGLJavaStackFrame = topEGLFrame = this.eglFrames == null || this.eglFrames.length == 0 ? null : this.eglFrames[0];
                            if (topEGLFrame != null && topEGLFrame.getJavaStackFrame() == topJavaFrame) {
                                try {
                                    topEGLFrame.setLineBeforeStepInto(topEGLFrame.getLineNumber());
                                }
                                catch (DebugException debugException) {
                                    topEGLFrame.setLineBeforeStepInto(-1);
                                }
                            }
                        }
                        savedEvents.add(events[i]);
                        break;
                    }
                    case 2: {
                        IJavaStackFrame topJavaFrame;
                        if (!bpHit && this.steppingFromEGL && this.getEGLJavaDebugTarget().filterRuntimes() && events[i].getDetail() == 8) {
                            try {
                                topJavaFrame = (IJavaStackFrame)this.javaThread.getTopStackFrame();
                                if (topJavaFrame != null) {
                                    int frameCount = this.javaThread.getFrameCount();
                                    if (frameCount == 1 && this.isMainMethod(topJavaFrame)) {
                                        topJavaFrame.resume();
                                        break;
                                    }
                                    if (this.shouldStepInto(topJavaFrame)) {
                                        topJavaFrame.stepInto();
                                        break;
                                    }
                                    if (this.shouldStepReturn(topJavaFrame)) {
                                        if (frameCount == 1) {
                                            topJavaFrame.resume();
                                        }
                                        int indexOfTopEGLFrame = -1;
                                        IStackFrame[] javaFrames = this.javaThread.getStackFrames();
                                        int j = 0;
                                        while (j < javaFrames.length) {
                                            if (SMAPUtil.isEGLStratum((IJavaStackFrame)javaFrames[j])) {
                                                indexOfTopEGLFrame = j;
                                                break;
                                            }
                                            ++j;
                                        }
                                        if (indexOfTopEGLFrame == -1) {
                                            topJavaFrame.resume();
                                            break;
                                        }
                                        topJavaFrame.stepReturn();
                                        break;
                                    }
                                    EGLJavaStackFrame topEGLFrame = (EGLJavaStackFrame)this.getTopStackFrame();
                                    if (topEGLFrame != null && topEGLFrame.getJavaStackFrame() == topJavaFrame && topEGLFrame.getLineBeforeStepInto() != -1 && topEGLFrame.getLineBeforeStepInto() == topEGLFrame.getLineNumber()) {
                                        this.stepInto();
                                        break;
                                    }
                                }
                            }
                            catch (DebugException debugException) {}
                        }
                        this.disposeStackFrames();
                        savedEvents.add(events[i]);
                        break;
                    }
                    default: {
                        savedEvents.add(events[i]);
                    }
                }
                ++i;
            }
        }
        if (savedEvents.size() > 0) {
            super.handleDebugEvents(savedEvents.toArray(new DebugEvent[savedEvents.size()]));
        }
    }

    private boolean filterFrameType(IJavaStackFrame frame) throws DebugException {
        return this.shouldStepInto(frame) || this.shouldStepReturn(frame);
    }

    private boolean shouldStepReturn(IJavaStackFrame frame) throws DebugException {
        if (!SMAPUtil.isEGLStratum(frame)) {
            String type = frame.getDeclaringTypeName();
            return type.startsWith("java.") || type.startsWith("javax.") || type.startsWith("com.ibm.") || type.startsWith("com.sun.") || type.startsWith("sun.") || type.startsWith("org.apache.") || type.startsWith("org.mortbay.");
        }
        return false;
    }

    private boolean shouldStepInto(IJavaStackFrame frame) throws DebugException {
        if (SMAPUtil.isEGLStratum(frame)) {
            return frame.getLineNumber() == -1;
        }
        String type = frame.getDeclaringTypeName();
        return type.startsWith("org.eclipse.edt.") || type.startsWith("egl.") || type.startsWith("eglx.");
    }

    private boolean isMainMethod(IJavaStackFrame frame) throws DebugException {
        return frame.isStatic() && "main".equals(frame.getName()) && "([Ljava/lang/String;)V".equals(frame.getSignature());
    }

    @Override
    public IJavaThread getJavaThread() {
        return this.javaThread;
    }

    @Override
    public Object getJavaDebugElement() {
        return this.getJavaThread();
    }

    @Override
    public Object getEvaluationLock() {
        return this.evaluationLock;
    }
}

