/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.EDTDebugCoreMessages;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaValue;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.VariableUtil;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class CalendarVariable
extends EGLJavaVariable {
    private static final String ESTRING_CLASS = "org.eclipse.edt.runtime.java.eglx.lang.EString";
    private static final String DATE_METHOD = "asStringDate";
    private static final String TIME_METHOD = "asStringTime";
    private static final String TIMESTAMP_METHOD = "asStringTimestamp";
    private static final String TIMESTAMP_FORMAT_YEAR = "yyyy";
    private static final String TIMESTAMP_FORMAT_MONTH = "MM";
    private static final String TIMESTAMP_FORMAT_DAY = "dd";
    private static final String TIMESTAMP_FORMAT_HOUR = "HH";
    private static final String TIMESTAMP_FORMAT_MINUTE = "mm";
    private static final String TIMESTAMP_FORMAT_SECOND = "ss";
    private static final String TIMESTAMP_FORMAT_FRACTION1 = "f";
    private static final String TIMESTAMP_FORMAT_FRACTION2 = "ff";
    private static final String TIMESTAMP_FORMAT_FRACTION3 = "fff";
    private static final String TIMESTAMP_FORMAT_FRACTION4 = "ffff";
    private static final String TIMESTAMP_FORMAT_FRACTION5 = "fffff";
    private static final String TIMESTAMP_FORMAT_FRACTION6 = "ffffff";

    public CalendarVariable(IDebugTarget target, IJavaVariable javaVariable, SMAPVariableInfo variableInfo, IEGLJavaStackFrame frame, IEGLJavaValue parent) {
        super(target, javaVariable, variableInfo, frame, parent);
    }

    @Override
    protected IEGLJavaValue createEGLValue(IJavaValue javaValue) {
        return new EGLJavaValue(this.getDebugTarget(), javaValue, this){

            @Override
            public String getValueString() throws DebugException {
                if (this.javaValue.isNull()) {
                    return "null";
                }
                if (this.javaValue instanceof IJavaObject) {
                    IJavaValue result = "eglx.lang.EDate".equals(((CalendarVariable)CalendarVariable.this).variableInfo.type) ? this.formatDate() : ("eglx.lang.ETime".equals(((CalendarVariable)CalendarVariable.this).variableInfo.type) ? this.formatTime() : this.formatTimestamp());
                    if (result == null) {
                        return EDTDebugCoreMessages.ErrorRetrievingValue;
                    }
                    return result.getValueString();
                }
                return super.getValueString();
            }

            protected IJavaValue formatDate() {
                return VariableUtil.invokeStaticMethod(CalendarVariable.this.getEGLStackFrame().getEGLThread(), CalendarVariable.this.getEGLStackFrame().getJavaStackFrame(), CalendarVariable.ESTRING_CLASS, CalendarVariable.DATE_METHOD, "(Ljava/util/Calendar;)Ljava/lang/String;", new IJavaValue[]{this.javaValue});
            }

            protected IJavaValue formatTime() {
                return VariableUtil.invokeStaticMethod(CalendarVariable.this.getEGLStackFrame().getEGLThread(), CalendarVariable.this.getEGLStackFrame().getJavaStackFrame(), CalendarVariable.ESTRING_CLASS, CalendarVariable.TIME_METHOD, "(Ljava/util/Calendar;)Ljava/lang/String;", new IJavaValue[]{this.javaValue});
            }

            protected IJavaValue formatTimestamp() {
                int endCode;
                int startCode;
                int idx2;
                String pattern = null;
                int idx = ((CalendarVariable)CalendarVariable.this).variableInfo.type.lastIndexOf("eglx.lang.ETimestamp(");
                if (idx != -1 && (idx2 = ((CalendarVariable)CalendarVariable.this).variableInfo.type.lastIndexOf(")")) != -1) {
                    pattern = ((CalendarVariable)CalendarVariable.this).variableInfo.type.substring(idx + "eglx.lang.ETimestamp(".length(), idx2);
                }
                if (pattern == null) {
                    startCode = 0;
                    endCode = 5;
                } else {
                    startCode = pattern.startsWith(CalendarVariable.TIMESTAMP_FORMAT_YEAR) ? 0 : (pattern.startsWith(CalendarVariable.TIMESTAMP_FORMAT_MONTH) ? 1 : (pattern.startsWith(CalendarVariable.TIMESTAMP_FORMAT_DAY) ? 2 : (pattern.startsWith(CalendarVariable.TIMESTAMP_FORMAT_HOUR) ? 3 : (pattern.startsWith(CalendarVariable.TIMESTAMP_FORMAT_MINUTE) ? 4 : (pattern.startsWith(CalendarVariable.TIMESTAMP_FORMAT_SECOND) ? 5 : (pattern.startsWith(CalendarVariable.TIMESTAMP_FORMAT_FRACTION1) ? 6 : 0))))));
                    endCode = pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_YEAR) ? 0 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_MONTH) ? 1 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_DAY) ? 2 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_HOUR) ? 3 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_MINUTE) ? 4 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_SECOND) ? 5 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_FRACTION6) ? 11 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_FRACTION5) ? 10 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_FRACTION4) ? 9 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_FRACTION3) ? 8 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_FRACTION2) ? 7 : (pattern.endsWith(CalendarVariable.TIMESTAMP_FORMAT_FRACTION1) ? 6 : 5)))))))))));
                }
                IJavaDebugTarget javaTarget = this.getEGLJavaDebugTarget().getJavaDebugTarget();
                return VariableUtil.invokeStaticMethod(CalendarVariable.this.getEGLStackFrame().getEGLThread(), CalendarVariable.this.getEGLStackFrame().getJavaStackFrame(), CalendarVariable.ESTRING_CLASS, CalendarVariable.TIMESTAMP_METHOD, "(Ljava/util/Calendar;II)Ljava/lang/String;", new IJavaValue[]{this.javaValue, javaTarget.newValue(startCode), javaTarget.newValue(endCode)});
            }

            @Override
            public IVariable[] getVariables() {
                return VariableUtil.EMPTY_VARIABLES;
            }

            @Override
            public boolean hasVariables() {
                return false;
            }

            @Override
            public String computeDetail() {
                try {
                    return this.getValueString();
                }
                catch (DebugException e) {
                    return e.getLocalizedMessage();
                }
            }
        };
    }

    @Override
    protected boolean shouldCheckJavaElementAdapter() {
        return false;
    }
}

