/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.variables;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaValue;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.VariableUtil;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class ListVariable
extends EGLJavaVariable {
    public ListVariable(IDebugTarget target, IJavaVariable javaVariable, SMAPVariableInfo variableInfo, IEGLJavaStackFrame frame, IEGLJavaValue parent) {
        super(target, javaVariable, variableInfo, frame, parent);
    }

    @Override
    protected IEGLJavaValue createEGLValue(IJavaValue javaValue) {
        return new ListValue(this.getDebugTarget(), javaValue, this);
    }

    @Override
    protected boolean shouldCheckJavaElementAdapter() {
        return false;
    }

    private class ListValue
    extends EGLJavaValue {
        public ListValue(IDebugTarget target, IJavaValue value, EGLJavaVariable parent) {
            super(target, value, parent);
        }

        @Override
        public synchronized IVariable[] getVariables() throws DebugException {
            IJavaValue toArrayValue;
            if (this.children != null) {
                return this.children;
            }
            if (this.javaValue instanceof IJavaObject && (toArrayValue = VariableUtil.runSendMessage(ListVariable.this.getEGLStackFrame().getEGLThread(), (IJavaObject)this.javaValue, null, "toArray", "()[Ljava/lang/Object;", false)) != null) {
                int idx2;
                IVariable[] vars = toArrayValue.getVariables();
                ArrayList<IEGLJavaVariable> list = new ArrayList<IEGLJavaVariable>(vars.length);
                SMAPVariableInfo parentInfo = this.parentVariable.getVariableInfo();
                String elementType = parentInfo.type;
                int idx = elementType.indexOf(60);
                if (idx != -1 && (idx2 = elementType.lastIndexOf(62)) != -1) {
                    elementType = elementType.substring(idx + 1, idx2);
                }
                IVariable[] iVariableArray = vars;
                int n = vars.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariable var = iVariableArray[n2];
                    if (var instanceof IJavaVariable) {
                        String eglName;
                        String javaName = var.getName();
                        if (javaName.length() > 2 && javaName.charAt(0) == '[' && javaName.charAt(javaName.length() - 1) == ']') {
                            try {
                                int index = Integer.parseInt(javaName.substring(1, javaName.length() - 1)) + 1;
                                StringBuilder buf = new StringBuilder(javaName.length() + 1);
                                buf.append('[');
                                buf.append(index);
                                buf.append(']');
                                eglName = buf.toString();
                            }
                            catch (NumberFormatException numberFormatException) {
                                eglName = javaName;
                            }
                        } else {
                            eglName = javaName;
                        }
                        SMAPVariableInfo info = new SMAPVariableInfo(eglName, javaName, elementType, parentInfo.lineDeclared, parentInfo.smapEntry);
                        list.add(VariableUtil.createEGLVariable((IJavaVariable)var, info, this.parentVariable.getEGLStackFrame(), this));
                    }
                    ++n2;
                }
                this.children = list.toArray(new IEGLJavaVariable[list.size()]);
            }
            if (this.children == null) {
                this.children = super.getVariables();
            }
            return this.children;
        }

        @Override
        public String getValueString() {
            return this.javaValue.isNull() ? "null" : "";
        }

        @Override
        public String computeDetail() {
            return this.getValueString();
        }
    }
}

