/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.edt.debug.core.DebugUtil;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugMessages;
import org.eclipse.edt.debug.ui.launching.AbstractEGLApplicationTab;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RUILoadMainTab
extends AbstractEGLApplicationTab
implements ModifyListener,
SelectionListener {
    protected Label fProjectLabel;
    protected Text fProjectText;
    protected Button fProjectBrowseButton;
    protected Label fHandlerFileLabel;
    protected Text fHandlerFileText;
    protected Button fHandlerFileSearchButton;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createVerticalSpacer(composite, 1);
        Composite projectComposite = new Composite(composite, 0);
        GridLayout projectLayout = new GridLayout();
        projectLayout.numColumns = 2;
        projectLayout.marginHeight = 0;
        projectLayout.marginWidth = 0;
        projectComposite.setLayout((Layout)projectLayout);
        GridData gd = new GridData(768);
        projectComposite.setLayoutData((Object)gd);
        this.fProjectLabel = this.createLabel(projectComposite, RUIDebugMessages.rui_load_main_tab_project_label);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjectLabel.setLayoutData((Object)gd);
        this.fProjectText = this.createText(projectComposite);
        gd = new GridData(768);
        this.fProjectText.setLayoutData((Object)gd);
        this.fProjectText.addModifyListener((ModifyListener)this);
        this.fProjectBrowseButton = this.createPushButton(projectComposite, RUIDebugMessages.rui_load_main_tab_browse_button, null);
        this.fProjectBrowseButton.addSelectionListener((SelectionListener)this);
        this.createVerticalSpacer(composite, 1);
        Composite handlerFileComposite = new Composite(composite, 0);
        GridLayout handlerFileLayout = new GridLayout();
        handlerFileLayout.numColumns = 2;
        handlerFileLayout.marginHeight = 0;
        handlerFileLayout.marginWidth = 0;
        handlerFileComposite.setLayout((Layout)handlerFileLayout);
        gd = new GridData(768);
        handlerFileComposite.setLayoutData((Object)gd);
        this.fHandlerFileLabel = this.createLabel(handlerFileComposite, RUIDebugMessages.rui_load_main_tab_handler_file_label);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fHandlerFileLabel.setLayoutData((Object)gd);
        this.fHandlerFileText = this.createText(handlerFileComposite);
        gd = new GridData(768);
        this.fHandlerFileText.setLayoutData((Object)gd);
        this.fHandlerFileText.addModifyListener((ModifyListener)this);
        this.fHandlerFileSearchButton = this.createPushButton(handlerFileComposite, RUIDebugMessages.rui_load_main_tab_search_button, null);
        this.fHandlerFileSearchButton.addSelectionListener((SelectionListener)this);
        this.fHandlerFileSearchButton.setEnabled(false);
        this.createVerticalSpacer(composite, 1);
        Composite handlerComposite = new Composite(composite, 0);
        GridLayout handlerLayout = new GridLayout();
        handlerLayout.numColumns = 2;
        handlerLayout.marginHeight = 0;
        handlerLayout.marginWidth = 0;
        handlerComposite.setLayout((Layout)handlerLayout);
        gd = new GridData(768);
        handlerComposite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.edt.debug.javascript.rui_handler_launch");
    }

    protected Label createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        return label;
    }

    protected Text createText(Composite parent) {
        Text text = new Text(parent, 2052);
        text.setText("");
        text.addModifyListener((ModifyListener)this);
        text.setEnabled(true);
        return text;
    }

    protected Button createButton(Composite parent, int style, String label) {
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    protected void createVerticalSpacer(Composite parent, int numColumns) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = numColumns;
        label.setLayoutData((Object)gridData);
    }

    public void modifyText(ModifyEvent e) {
        this.updateLaunchConfigurationDialog();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.fProjectBrowseButton) {
            this.handleBrowseButtonPushed();
        } else if (e.getSource() == this.fHandlerFileSearchButton) {
            this.handleHandlerFileSearchButtonPushed();
        }
        this.updateLaunchConfigurationDialog();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.getSource() == this.fProjectBrowseButton) {
            this.handleBrowseButtonPushed();
        } else if (e.getSource() == this.fHandlerFileSearchButton) {
            this.handleHandlerFileSearchButtonPushed();
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void handleBrowseButtonPushed() {
        String project = this.browseForProject();
        if (project != null) {
            this.fProjectText.setText(project);
        }
    }

    protected String getProjectName() {
        return this.fProjectText.getText();
    }

    protected void handleHandlerFileSearchButtonPushed() {
        IEGLElement part = this.browseForPart(512, new String[]{"RUIHandler", "RUIWidget"}, RUIDebugMessages.rui_load_main_tab_handler_file_search_title, RUIDebugMessages.rui_load_main_tab_handler_file_search_message);
        if (part != null) {
            this.fHandlerFileText.setText(part.getResource().getProjectRelativePath().toString());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.updateProjectNameFromConfig(configuration);
        this.updateHandlerFileFromConfig(configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = this.fProjectText.getText().trim();
        if (projectName.length() < 1) {
            this.setErrorMessage(RUIDebugMessages.rui_load_launch_configuration_no_project_specified);
            this.fHandlerFileSearchButton.setEnabled(false);
            return false;
        }
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            this.setErrorMessage(RUIDebugMessages.rui_load_launch_configuration_invalid_project);
            this.fHandlerFileSearchButton.setEnabled(false);
            return false;
        }
        this.fHandlerFileSearchButton.setEnabled(true);
        String handlerFileName = this.fHandlerFileText.getText().trim();
        if (handlerFileName.length() < 1) {
            this.setErrorMessage(RUIDebugMessages.rui_load_launch_configuration_no_handler_file_specified);
            return false;
        }
        if (!DebugUtil.isEGLFileName((String)handlerFileName)) {
            this.setErrorMessage(RUIDebugMessages.rui_load_launch_configuration_invalid_handler_file);
            return false;
        }
        IFile file = project.getFile(handlerFileName);
        if (!file.exists()) {
            this.setErrorMessage(RUIDebugMessages.rui_load_main_tab_handler_file_not_in_project);
            return false;
        }
        if (!Util.isVESupportType((IFile)file)) {
            this.setErrorMessage(RUIDebugMessages.rui_load_launch_configuration_file_not_handler);
            return false;
        }
        return true;
    }

    public void dispose() {
        this.fProjectLabel = null;
        this.fProjectText = null;
        this.fProjectBrowseButton = null;
        this.fHandlerFileSearchButton = null;
        this.fHandlerFileLabel = null;
        this.fHandlerFileText = null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String projectName = this.fProjectText.getText().trim();
        configuration.setAttribute("org.eclipse.edt.debug.javascript.attr_project_name", projectName);
        configuration.setAttribute("org.eclipse.edt.debug.javascript.attr_handler_file", this.fHandlerFileText.getText().trim());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IResource resource = DebugUtil.getContext();
        if (resource != null) {
            if (DebugUtil.isEGLFileName((String)resource.getName())) {
                this.initializeProject(resource, configuration);
                this.initializeConfigName(resource, configuration);
                if (resource.getType() == 1 && Util.isVESupportType((IFile)((IFile)resource))) {
                    this.initializeHandlerFile(resource, configuration);
                }
            } else {
                this.initializeProject(resource, configuration);
            }
        } else {
            configuration.setAttribute("org.eclipse.edt.debug.javascript.attr_project_name", null);
        }
    }

    protected void initializeHandlerFile(IResource resource, ILaunchConfigurationWorkingCopy configuration) {
        String pathStr = resource.getFullPath().toString();
        int index = pathStr.indexOf(47, 1);
        configuration.setAttribute("org.eclipse.edt.debug.javascript.attr_handler_file", pathStr.substring(index + 1));
    }

    protected void initializeProject(IResource resource, ILaunchConfigurationWorkingCopy configuration) {
        IProject project = resource.getProject();
        String name = null;
        if (project != null && project.exists()) {
            name = project.getName();
        }
        configuration.setAttribute("org.eclipse.edt.debug.javascript.attr_project_name", name);
    }

    protected void updateProjectNameFromConfig(ILaunchConfiguration configuration) {
        try {
            this.fProjectText.setText(configuration.getAttribute("org.eclipse.edt.debug.javascript.attr_project_name", ""));
        }
        catch (CoreException coreException) {
            this.fProjectText.setText("");
        }
    }

    protected void updateHandlerFileFromConfig(ILaunchConfiguration configuration) {
        try {
            this.fHandlerFileText.setText(configuration.getAttribute("org.eclipse.edt.debug.javascript.attr_handler_file", ""));
        }
        catch (CoreException coreException) {
            this.fHandlerFileText.setText("");
        }
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getName() {
        return RUIDebugMessages.rui_load_main_tab_name;
    }
}

