/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLStackFrame;
import org.eclipse.edt.debug.core.IEGLThread;
import org.eclipse.edt.debug.core.IEGLVariable;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugElement;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugMessages;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugTarget;
import org.eclipse.edt.debug.javascript.internal.model.RUIThread;
import org.eclipse.edt.debug.javascript.internal.model.RUIVariable;
import org.eclipse.osgi.util.NLS;

public class RUIStackFrame
extends RUIDebugElement
implements IEGLStackFrame {
    private static final IEGLVariable[] EMPTY_VARIABLES = new IEGLVariable[0];
    private static final IRegisterGroup[] EMPTY_REGISTERS = new IRegisterGroup[0];
    private RUIThread fThread;
    private String fFileName;
    private int fLineNumber;
    private int fId;
    private String fFunctionName;
    private String fProgramName;
    private IVariable[] fVariables;
    private List fCurrentVariables;
    private Hashtable fVariablesHash;
    private Hashtable fVariablesHashOld;
    private static final IVariable WATCH_EXPRS_NOT_SUPPORTED_VAR = new IVariable(){
        private final IValue value = new IValue(){

            public String getReferenceTypeName() throws DebugException {
                return "";
            }

            public String getValueString() throws DebugException {
                return RUIDebugMessages.rui_stack_frame_watch_exprs_unsupported;
            }

            public IVariable[] getVariables() throws DebugException {
                return EMPTY_VARIABLES;
            }

            public boolean hasVariables() throws DebugException {
                return false;
            }

            public boolean isAllocated() throws DebugException {
                return false;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public ILaunch getLaunch() {
                return null;
            }

            public String getModelIdentifier() {
                return null;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };

        public String getName() throws DebugException {
            return null;
        }

        public String getReferenceTypeName() throws DebugException {
            return null;
        }

        public IValue getValue() throws DebugException {
            return this.value;
        }

        public boolean hasValueChanged() throws DebugException {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public void setValue(String expression) throws DebugException {
        }

        public void setValue(IValue value) throws DebugException {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(String expression) throws DebugException {
            return false;
        }

        public boolean verifyValue(IValue value) throws DebugException {
            return false;
        }
    };

    public RUIStackFrame(RUIThread thread, int id, String programName, String fileName, String functionName, int lineNumber) {
        super((RUIDebugTarget)thread.getDebugTarget());
        this.initialize(thread, id, programName, fileName, functionName, lineNumber);
    }

    public RUIStackFrame(RUIDebugTarget target) {
        super(target);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == RUIStackFrame.class || adapter == IEGLStackFrame.class || adapter == IStackFrame.class) {
            return this;
        }
        if (adapter == IThread.class || adapter == IEGLThread.class || adapter == RUIThread.class) {
            return this.getThread();
        }
        return super.getAdapter(adapter);
    }

    public void initialize(RUIStackFrame other) {
        this.fLineNumber = other.fLineNumber;
        this.fCurrentVariables = other.fCurrentVariables;
        this.initialize(other.fThread, other.fId, other.fProgramName, other.fFileName, other.fFunctionName, other.fLineNumber);
    }

    private void initialize(RUIThread thread, int id, String programName, String fileName, String functionName, int lineNumber) {
        int oldSize;
        this.fThread = thread;
        this.fId = id;
        this.fProgramName = programName;
        this.fFileName = fileName;
        this.fFunctionName = functionName;
        this.fLineNumber = lineNumber;
        this.fVariablesHashOld = this.fVariablesHash;
        int hashSize = 10;
        if (this.fVariablesHashOld != null && (oldSize = this.fVariablesHashOld.size()) > hashSize) {
            hashSize = oldSize;
        }
        this.fVariablesHash = new Hashtable(hashSize);
        this.fVariables = null;
    }

    public RUIVariable getCorrespondingVariable(RUIVariable newVar, RUIVariable parent) {
        String qualifiedName;
        if (parent != null) {
            qualifiedName = String.valueOf(parent.getQualifiedName()) + "." + newVar.getName();
            newVar.setQualifiedName(qualifiedName);
        } else {
            qualifiedName = newVar.getQualifiedName();
        }
        RUIVariable answer = this.findVariableInOldHash(qualifiedName);
        if (answer == null) {
            answer = newVar;
        } else {
            answer.initialize(this, parent, newVar);
        }
        this.addVariableToHash(answer);
        return answer;
    }

    private void addVariableToHash(RUIVariable variable) {
        if (variable != null) {
            this.fVariablesHash.put(variable.getQualifiedName(), variable);
        }
    }

    private RUIVariable findVariableInOldHash(String qualifiedName) {
        if (this.fVariablesHashOld != null) {
            return (RUIVariable)((Object)this.fVariablesHashOld.get(qualifiedName));
        }
        return null;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public String getName() throws DebugException {
        return NLS.bind((String)RUIDebugMessages.rui_stack_frame_label_basic, (Object[])new String[]{this.fFunctionName, Integer.toString(this.fLineNumber), this.fProgramName});
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return EMPTY_REGISTERS;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.fVariables != null) {
            return this.fVariables;
        }
        if (this.fCurrentVariables == null || this.fCurrentVariables.size() == 0) {
            this.fVariables = EMPTY_VARIABLES;
            return this.fVariables;
        }
        int size = this.fCurrentVariables.size();
        this.fVariables = new IVariable[size];
        int i = 0;
        while (i < size) {
            this.fVariables[i] = this.getCorrespondingVariable((RUIVariable)((Object)this.fCurrentVariables.get(i)), null);
            ++i;
        }
        return this.fVariables;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.isSuspended() && !this.isTerminated() && this.fCurrentVariables != null && this.fCurrentVariables.size() > 0;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        ((RUIThread)this.getThread()).stepOver(this);
    }

    public void stepReturn() throws DebugException {
        ((RUIThread)this.getThread()).stepReturn(this);
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fFileName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RUIStackFrame) {
            RUIStackFrame sf = (RUIStackFrame)((Object)obj);
            return sf.fId == this.fId && sf.fFileName.equals(this.fFileName) && sf.fFunctionName.equals(this.fFunctionName) && sf.fProgramName.equals(this.fProgramName);
        }
        return false;
    }

    public int hashCode() {
        return this.getSourceName().hashCode() + this.fId;
    }

    public String getProgramName() {
        return this.fProgramName;
    }

    public String getFunctionName() {
        return this.fFunctionName;
    }

    public void addVariable(IVariable var) {
        if (this.fCurrentVariables == null) {
            this.fCurrentVariables = new ArrayList();
        }
        this.fCurrentVariables.add(var);
    }

    public int getId() {
        return this.fId;
    }

    public String getProgramFile() {
        return this.fFileName;
    }

    public IVariable evaluateWatchExpression(String expression) throws DebugException {
        return WATCH_EXPRS_NOT_SUPPORTED_VAR;
    }
}

