/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.List;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.ExceptionBlock;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Parameter;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.TryStatement;

public class TryStatementTemplate
extends JavaTemplate {
    public void genStatementBody(TryStatement stmt, Context ctx, TabbedWriter out) {
        out.print("try ");
        ctx.invoke("genStatement", (Statement)stmt.getTryBlock(), (TemplateContext)ctx, out);
        List blocks = stmt.getExceptionBlocks();
        if (blocks.isEmpty()) {
            String exTemp = ctx.nextTempName();
            out.println("catch ( java.lang.Exception " + exTemp + " )");
            out.println('{');
            out.println("org.eclipse.edt.javart.util.JavartUtil.checkHandleable( " + exTemp + " );");
            out.println('}');
        } else {
            ExceptionBlock anyExBlock = null;
            ExceptionBlock nullValueExBlock = null;
            ExceptionBlock javaOjbectExBlock = null;
            int specialBlocksCount = 0;
            for (ExceptionBlock exceptionBlock : blocks) {
                String sig = exceptionBlock.getException().getType().getTypeSignature();
                if (sig.equals("eglx.lang.AnyException")) {
                    anyExBlock = exceptionBlock;
                    ++specialBlocksCount;
                    continue;
                }
                if (sig.equals("eglx.lang.NullValueException")) {
                    nullValueExBlock = exceptionBlock;
                    ++specialBlocksCount;
                    continue;
                }
                if (sig.equals("eglx.java.JavaObjectException")) {
                    javaOjbectExBlock = exceptionBlock;
                    ++specialBlocksCount;
                    continue;
                }
                this.genOnException(exceptionBlock, ctx, out);
            }
            if (specialBlocksCount == 1) {
                ExceptionBlock block = anyExBlock != null ? anyExBlock : (nullValueExBlock != null ? nullValueExBlock : javaOjbectExBlock);
                this.genOneSpecialOnException(block, ctx, out);
            } else if (specialBlocksCount > 1) {
                this.genSpecialOnExceptions(anyExBlock, nullValueExBlock, javaOjbectExBlock, ctx, out);
            }
        }
    }

    public void genOnException(ExceptionBlock exceptionBlock, Context ctx, TabbedWriter out) {
        Parameter ex = exceptionBlock.getException();
        CommonUtilities.generateSmapExtension((Member)ex, (Context)ctx);
        out.print("catch (" + ctx.getNativeImplementationMapping(ex.getType()) + " ");
        ctx.invoke("genName", (EObject)ex, new Object[]{ctx, out});
        out.print(") ");
        ctx.invoke("genStatement", (Statement)exceptionBlock, (TemplateContext)ctx, out);
    }

    public void genOneSpecialOnException(ExceptionBlock exceptionBlock, Context ctx, TabbedWriter out) {
        Parameter ex = exceptionBlock.getException();
        String exClass = ctx.getNativeImplementationMapping(ex.getType());
        String exTemp = ctx.nextTempName();
        out.println("catch ( java.lang.Exception " + exTemp + " )");
        out.println('{');
        out.println("org.eclipse.edt.javart.util.JavartUtil.checkHandleable( " + exTemp + " );");
        CommonUtilities.generateSmapExtension((Member)ex, (Context)ctx);
        out.print(String.valueOf(exClass) + ' ');
        ctx.invoke("genName", (EObject)ex, new Object[]{ctx, out});
        out.println(';');
        out.println("if ( " + exTemp + " instanceof " + exClass + " )");
        out.println('{');
        ctx.invoke("genName", (EObject)ex, new Object[]{ctx, out});
        out.println(" = (" + exClass + ")" + exTemp + ';');
        out.println('}');
        if (!ex.getType().getTypeSignature().equals("eglx.lang.AnyException")) {
            out.println("else if ( " + exTemp + " instanceof eglx.lang.AnyException )");
            out.println('{');
            out.println("throw (eglx.lang.AnyException)" + exTemp + ';');
            out.println('}');
        }
        out.println("else");
        out.println('{');
        ctx.invoke("genName", (EObject)ex, new Object[]{ctx, out});
        out.print(" = ");
        if (!ex.getType().getTypeSignature().equals("eglx.lang.AnyException")) {
            out.print("(" + exClass + ')');
        }
        out.println("org.eclipse.edt.javart.util.JavartUtil.makeEglException(" + exTemp + ");");
        out.println('}');
        ctx.invoke("genStatement", (Statement)exceptionBlock, (TemplateContext)ctx, out);
        out.println('}');
    }

    public void genSpecialOnExceptions(ExceptionBlock anyExBlock, ExceptionBlock nullValueExBlock, ExceptionBlock javaOjbectExBlock, Context ctx, TabbedWriter out) {
        String exClass;
        Parameter ex;
        String exTemp = ctx.nextTempName();
        out.println("catch ( java.lang.Exception " + exTemp + " )");
        out.println('{');
        out.println("org.eclipse.edt.javart.util.JavartUtil.checkHandleable( " + exTemp + " );");
        if (nullValueExBlock != null) {
            ex = nullValueExBlock.getException();
            exClass = ctx.getNativeImplementationMapping(ex.getType());
            out.println("if ( " + exTemp + " instanceof " + exClass + " || " + exTemp + " instanceof java.lang.NullPointerException )");
            out.println('{');
            CommonUtilities.generateSmapExtension((Member)ex, (Context)ctx);
            out.print(String.valueOf(exClass) + ' ');
            ctx.invoke("genName", (EObject)ex, new Object[]{ctx, out});
            out.println(" = (" + exClass + ")org.eclipse.edt.javart.util.JavartUtil.makeEglException(" + exTemp + ");");
            ctx.invoke("genStatement", (Statement)nullValueExBlock, (TemplateContext)ctx, out);
            out.println('}');
        }
        if (javaOjbectExBlock != null) {
            ex = javaOjbectExBlock.getException();
            exClass = ctx.getNativeImplementationMapping(ex.getType());
            if (nullValueExBlock != null) {
                out.print("else ");
            }
            out.println("if ( org.eclipse.edt.javart.util.JavartUtil.isJavaObjectException(" + exTemp + ") )");
            out.println('{');
            CommonUtilities.generateSmapExtension((Member)ex, (Context)ctx);
            out.print(String.valueOf(exClass) + ' ');
            ctx.invoke("genName", (EObject)ex, new Object[]{ctx, out});
            out.println(" = (" + exClass + ")org.eclipse.edt.javart.util.JavartUtil.makeEglException(" + exTemp + ");");
            ctx.invoke("genStatement", (Statement)javaOjbectExBlock, (TemplateContext)ctx, out);
            out.println('}');
        }
        out.println("else");
        out.println('{');
        if (anyExBlock != null) {
            ex = anyExBlock.getException();
            exClass = ctx.getNativeImplementationMapping(ex.getType());
            CommonUtilities.generateSmapExtension((Member)ex, (Context)ctx);
            out.print(String.valueOf(exClass) + ' ');
            ctx.invoke("genName", (EObject)ex, new Object[]{ctx, out});
            out.println(" = org.eclipse.edt.javart.util.JavartUtil.makeEglException(" + exTemp + ");");
            ctx.invoke("genStatement", (Statement)anyExBlock, (TemplateContext)ctx, out);
        } else {
            out.println("throw (eglx.lang.AnyException)" + exTemp + ';');
        }
        out.println('}');
        out.println('}');
    }

    public void genStatementEnd(TryStatement stmt, Context ctx, TabbedWriter out) {
    }
}

