/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.java.jtopen.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.BidiConversionProperties;
import java.io.UnsupportedEncodingException;
import org.eclipse.edt.runtime.java.eglx.lang.EString;

public class AS400Text
extends com.ibm.as400.access.AS400Text {
    private static final long serialVersionUID = 1L;
    private boolean retainTrailingSpaces;
    private int characterLength;

    public AS400Text(int length, AS400 system, boolean retainTrailingSpaces) {
        this(length, AS400Text.getSystemEncoding(system), retainTrailingSpaces);
    }

    public AS400Text(int length, String encoding, boolean retainTrailingSpaces) {
        super(AS400Text.calculateByteLength(length, encoding), encoding);
        this.retainTrailingSpaces = retainTrailingSpaces;
        this.characterLength = length;
    }

    private static String getSystemEncoding(AS400 system) {
        try {
            return system.getJobCCSIDEncoding();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int calculateByteLength(int length, String encoding) {
        if (encoding != null && !encoding.isEmpty()) {
            try {
                byte[] bytes = new String("A").getBytes(encoding);
                if (bytes != null && bytes.length > 1) {
                    return length + length;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return length;
    }

    public byte[] toBytes(Object arg0) {
        return super.toBytes(this.pad(arg0));
    }

    public int toBytes(Object arg0, byte[] arg1) {
        return super.toBytes(this.pad(arg0), arg1);
    }

    public int toBytes(Object arg0, byte[] arg1, int arg2) {
        return super.toBytes(this.pad(arg0), arg1, arg2);
    }

    public int toBytes(Object arg0, byte[] arg1, int arg2, BidiConversionProperties arg3) {
        return super.toBytes(this.pad(arg0), arg1, arg2, arg3);
    }

    public int toBytes(Object arg0, byte[] arg1, int arg2, int arg3) {
        return super.toBytes(this.pad(arg0), arg1, arg2, arg3);
    }

    private Object pad(Object str) {
        if (str instanceof String && ((String)str).length() < this.characterLength && this.characterLength != this.getByteLength()) {
            try {
                StringBuilder sb = new StringBuilder((String)str);
                while (sb.toString().getBytes(this.getEncoding()).length < this.getByteLength()) {
                    sb.append(' ');
                }
                return sb.toString();
            }
            catch (Exception exception) {}
        }
        return str;
    }

    public Object toObject(byte[] arg0) {
        Object retVal = super.toObject(arg0);
        if (!this.retainTrailingSpaces && retVal instanceof String) {
            retVal = EString.clip((String)((String)retVal));
        }
        return retVal;
    }

    public Object toObject(byte[] arg0, int arg1) {
        Object retVal = super.toObject(arg0, arg1);
        if (!this.retainTrailingSpaces && retVal instanceof String) {
            retVal = EString.clip((String)((String)retVal));
        }
        return retVal;
    }

    public Object toObject(byte[] arg0, int arg1, BidiConversionProperties arg2) {
        Object retVal = super.toObject(arg0, arg1, arg2);
        if (!this.retainTrailingSpaces && retVal instanceof String) {
            retVal = EString.clip((String)((String)retVal));
        }
        return retVal;
    }

    public Object toObject(byte[] arg0, int arg1, int arg2) {
        Object retVal = super.toObject(arg0, arg1, arg2);
        if (!this.retainTrailingSpaces && retVal instanceof String) {
            retVal = EString.clip((String)((String)retVal));
        }
        return retVal;
    }
}

