/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.internal.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.deployment.Activator;
import org.eclipse.edt.ide.deployment.internal.actions.DeployOperation;
import org.eclipse.edt.ide.deployment.internal.nls.Messages;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;

public class DeployJob
extends WorkspaceJob {
    private DeploymentContext[] models;
    private Object jobFamily;

    public DeployJob() {
        super(Messages.deploy_job_name);
        this.setUser(true);
        this.setPriority(30);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public DeployJob(Object jobFamily) {
        this();
        this.jobFamily = jobFamily;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.deploy_operation_task_name, 100);
        try {
            try {
                new DeployOperation().deploy(this.models, monitor);
            }
            catch (Exception e) {
                Activator.getDefault().log("Error running deploy job", e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void setModels(DeploymentContext[] models) {
        this.models = models;
    }

    public boolean belongsTo(Object family) {
        if (this.jobFamily != null) {
            return family.equals(this.jobFamily);
        }
        return super.belongsTo(family);
    }
}

