/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
/*
 * Updated on Tue May 27 10:54:14 EDT 2008
 */
package org.eclipse.edt.compiler.core.ast;

/**
 * Visitor class to perform operations on all Nodes.
 *
 * Generated by tools/org.eclipse.edt.compiler.core.ast.VisitorGenerator
 */
public abstract class AbstractASTNodeVisitor implements IASTVisitor {

	public abstract boolean visitNode(Node node);

	public abstract void endVisitNode(Node node);

	public boolean visit(AddStatement addStatement) {
		return visitNode( addStatement );
	}
	
	public boolean visit(AnnotationExpression annotationExpression) {
		return visitNode( annotationExpression );
	}
	
	public boolean visit(ArrayAccess arrayAccess) {
		return visitNode( arrayAccess );
	}
	
	public boolean visit(ArrayLiteral arrayLiteral) {
		return visitNode( arrayLiteral );
	}
	
	public boolean visit(ArrayType arrayType) {
		return visitNode( arrayType );
	}
	
	public boolean visit(AsExpression asExpression) {
		return visitNode( asExpression );
	}
	
	public boolean visit(Assignment assignment) {
		return visitNode( assignment );
	}
	
	public boolean visit(AssignmentStatement assignmentStatement) {
		return visitNode( assignmentStatement );
	}
	
	public boolean visit(BinaryExpression binaryExpression) {
		return visitNode( binaryExpression );
	}
	
	public boolean visit(BooleanLiteral booleanLiteral) {
		return visitNode( booleanLiteral );
	}
	
	public boolean visit(CallStatement callStatement) {
		return visitNode( callStatement );
	}
	
	public boolean visit(CallbackTarget callbackTarget) {
		return visitNode( callbackTarget );
	}

	public boolean visit(CallReturns callReturns) {
		return visitNode( callReturns );
	}

	public boolean visit(CallSynchronizationValues callSynch) {
		return visitNode( callSynch );
	}

	public boolean visit(CaseStatement caseStatement) {
		return visitNode( caseStatement );
	}
	
	public boolean visit(CharLiteral charLiteral) {
		return visitNode( charLiteral );
	}
	
	public boolean visit(ClassDataDeclaration classDataDeclaration) {
		return visitNode( classDataDeclaration );
	}
	
	public boolean visit(CloseStatement closeStatement) {
		return visitNode( closeStatement );
	}
	
	public boolean visit(ConstantFormField constantFormField) {
		return visitNode( constantFormField );
	}
	
	public boolean visit(Constructor constructor) {
		return visitNode( constructor );
	}
	
	public boolean visit(ContinueStatement continueStatement) {
		return visitNode( continueStatement );
	}
	
	public boolean visit(ConverseStatement converseStatement) {
		return visitNode( converseStatement );
	}
	
	public boolean visit(DataItem dataItem) {
		return visitNode( dataItem );
	}
	
	public boolean visit(DataTable dataTable) {
		return visitNode( dataTable );
	}
	
	public boolean visit(DBCharLiteral dBCharLiteral) {
		return visitNode( dBCharLiteral );
	}
	
	public boolean visit(DecimalLiteral decimalLiteral) {
		return visitNode( decimalLiteral );
	}
	
	public boolean visit(Delegate delegate) {
		return visitNode( delegate );
	}
	
	public boolean visit(DeleteStatement deleteStatement) {
		return visitNode( deleteStatement );
	}
	
	public boolean visit(DisplayStatement displayStatement) {
		return visitNode( displayStatement );
	}
	
	public boolean visit(ElseBlock elseBlock) {
		return visitNode( elseBlock );
	}
	
	public boolean visit(EmptyStatement emptyStatement) {
		return visitNode( emptyStatement );
	}
	
	public boolean visit(Enumeration enumeration) {
		return visitNode( enumeration );
	}
	
	public boolean visit(EnumerationField enumerationField) {
		return visitNode( enumerationField );
	}
	
	public boolean visit(ExecuteStatement executeStatement) {
		return visitNode( executeStatement );
	}
	
	public boolean visit(ExitStatement exitStatement) {
		return visitNode( exitStatement );
	}
	
	public boolean visit(ExternalType externalType) {
		return visitNode( externalType );
	}
	
	public boolean visit(FieldAccess fieldAccess) {
		return visitNode( fieldAccess );
	}
	
	public boolean visit(File file) {
		return visitNode( file );
	}
	
	public boolean visit(FloatLiteral floatLiteral) {
		return visitNode( floatLiteral );
	}
	
	public boolean visit(ForEachStatement forEachStatement) {
		return visitNode( forEachStatement );
	}
	
	public boolean visit(ForExpressionClause forExpressionClause) {
		return visitNode( forExpressionClause );
	}
	
	public boolean visit(FormGroup formGroup) {
		return visitNode( formGroup );
	}
	
	public boolean visit(ForStatement forStatement) {
		return visitNode( forStatement );
	}
	
	public boolean visit(ForUpdateClause forUpdateClause) {
		return visitNode( forUpdateClause );
	}
	
	public boolean visit(ForwardStatement forwardStatement) {
		return visitNode( forwardStatement );
	}
	
	public boolean visit(FreeSQLStatement freeSQLStatement) {
		return visitNode( freeSQLStatement );
	}
	
	public boolean visit(FromExpressionClause fromExpressionClause) {
		return visitNode( fromExpressionClause );
	}
	
	public boolean visit( FromOrToExpressionClause clause) {
		return visitNode( clause );
	}
	
	public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
		return visitNode( functionDataDeclaration );
	}
	
	public boolean visit(FunctionInvocation functionInvocation) {
		return visitNode( functionInvocation );
	}
	
	public boolean visit(FunctionInvocationStatement functionInvocationStatement) {
		return visitNode( functionInvocationStatement );
	}
	
	public boolean visit(FunctionParameter functionParameter) {
		return visitNode( functionParameter );
	}
	
	public boolean visit(GetByKeyStatement getByKeyStatement) {
		return visitNode( getByKeyStatement );
	}
	
	public boolean visit(GetByPositionStatement getByPositionStatement) {
		return visitNode( getByPositionStatement );
	}
	
	public boolean visit(GotoStatement gotoStatement) {
		return visitNode( gotoStatement );
	}
	
	public boolean visit(Handler handler) {
		return visitNode( handler );
	}
	
	public boolean visit(HexLiteral hexLiteral) {
		return visitNode( hexLiteral );
	}
	
	public boolean visit(ImportDeclaration importDeclaration) {
		return visitNode( importDeclaration );
	}
	
	public boolean visit(IfStatement ifStatement) {
		return visitNode( ifStatement );
	}
	
	public boolean visit(InExpression inExpression) {
		return visitNode( inExpression );
	}
	
	public boolean visit(InlineDLIStatement inlineDLIStatement) {
		return visitNode( inlineDLIStatement );
	}
	
	public boolean visit(InlineSQLStatement inlineSQLStatement) {
		return visitNode( inlineSQLStatement );
	}
	
	public boolean visit(IntegerLiteral integerLiteral) {
		return visitNode( integerLiteral );
	}
	
	public boolean visit(Interface interfaceNode) {
		return visitNode( interfaceNode );
	}
	
	public boolean visit(IntoClause intoClause) {
		return visitNode( intoClause );
	}
	
	public boolean visit(IsAExpression isAExpression) {
		return visitNode( isAExpression );
	}
	
	public boolean visit(IsNotExpression isNotExpression) {
		return visitNode( isNotExpression );
	}
	
	public boolean visit(LabelStatement labelStatement) {
		return visitNode( labelStatement );
	}
	
	public boolean visit(Library library) {
		return visitNode( library );
	}
	
	public boolean visit(LikeMatchesExpression likeMatchesExpression) {
		return visitNode( likeMatchesExpression );
	}
	
	public boolean visit(MBCharLiteral mBCharLiteral) {
		return visitNode( mBCharLiteral );
	}
	
	public boolean visit(MoveStatement moveStatement) {
		return visitNode( moveStatement );
	}
	
	public boolean visit(NameType nameType) {
		return visitNode( nameType );
	}
	
	public boolean visit(NestedForm nestedForm) {
		return visitNode( nestedForm );
	}
	
	public boolean visit(NestedFunction nestedFunction) {
		return visitNode( nestedFunction );
	}
	
	public boolean visit(NewExpression newExpression) {
		return visitNode( newExpression );
	}
	
	public boolean visit(NullLiteral nullLiteral) {
		return visitNode( nullLiteral );
	}
	
	public boolean visit(NullableType nullableType) {
		return visitNode( nullableType );
	}
	
	public boolean visit(NoCursorClause noCursorClause) {
		return visitNode( noCursorClause );
	}
	
	public boolean visit(ObjectExpression objExpr) {
		return visitNode( objExpr );
	}

	public boolean visit(ObjectExpressionEntry objExprEntry) {
		return visitNode( objExprEntry );
	}

	public boolean visit(OnEventBlock onEventBlock) {
		return visitNode( onEventBlock );
	}
	
	public boolean visit(OnExceptionBlock onExceptionBlock) {
		return visitNode( onExceptionBlock );
	}
	
	public boolean visit(OpenStatement openStatement) {
		return visitNode( openStatement );
	}
	
	public boolean visit(OpenUIStatement openUIStatement) {
		return visitNode( openUIStatement );
	}
	
	public boolean visit(OtherwiseClause otherwiseClause) {
		return visitNode( otherwiseClause );
	}
	
	public boolean visit(PackageDeclaration packageDeclaration) {
		return visitNode( packageDeclaration );
	}
	
	public boolean visit(ParenthesizedExpression parenthesizedExpression) {
		return visitNode( parenthesizedExpression );
	}
	
	public boolean visit(PassingClause passingClause) {
		return visitNode( passingClause );
	}
	
	public boolean visit(PrepareStatement prepareStatement) {
		return visitNode( prepareStatement );
	}
	
	public boolean visit(PrimitiveType primitiveType) {
		return visitNode( primitiveType );
	}
	
	public boolean visit(PrintStatement printStatement) {
		return visitNode( printStatement );
	}
	
	public boolean visit(Program program) {
		return visitNode( program );
	}
	
	public boolean visit(ProgramParameter programParameter) {
		return visitNode( programParameter );
	}
	
	public boolean visit(Record record) {
		return visitNode( record );
	}
	
	public boolean visit(ReplaceStatement replaceStatement) {
		return visitNode( replaceStatement );
	}
	
	public boolean visit(ReturnsDeclaration returnsDeclaration) {
		return visitNode( returnsDeclaration );
	}
	
	public boolean visit(ReturningToInvocationTargetClause returningToInvocationTargetClause) {
		return visitNode( returningToInvocationTargetClause );
	}
	
	public boolean visit(ReturningToNameClause returningToNameClause) {
		return visitNode( returningToNameClause );
	}
	
	public boolean visit(ReturnStatement returnStatement) {
		return visitNode( returnStatement );
	}
	
	public boolean visit(Service service) {
		return visitNode( service );
	}
	
	public boolean visit(ServiceReference serviceReference) {
		return visitNode( serviceReference );
	}
	
	public boolean visit(SetStatement setStatement) {
		return visitNode( setStatement );
	}
	
	public boolean visit(SetValuesExpression setValuesExpression) {
		return visitNode( setValuesExpression );
	}
	
	public boolean visit(SetValuesStatement setValuesStatement) {
		return visitNode( setValuesStatement );
	}
	
	public boolean visit(SettingsBlock settingsBlock) {
		return visitNode( settingsBlock );
	}
	
	public boolean visit(ShowStatement showStatement) {
		return visitNode( showStatement );
	}
	
	public boolean visit(SimpleName simpleName) {
		return visitNode( simpleName );
	}
	
	public boolean visit(SingleRowClause singleRowClause) {
		return visitNode( singleRowClause );
	}
	
	public boolean visit(StringLiteral stringLiteral) {
		return visitNode( stringLiteral );
	}
	
	public boolean visit(StructureItem structureItem) {
		return visitNode( structureItem );
	}
	
	public boolean visit(SQLLiteral sQLLiteral) {
		return visitNode( sQLLiteral );
	}
	
	public boolean visit(SubstringAccess substringAccess) {
		return visitNode( substringAccess );
	}
	
	public boolean visit(ThisExpression thisExpression) {
		return visitNode( thisExpression );
	}
	
	public boolean visit(ThrowStatement throwStatement) {
		return visitNode( throwStatement );
	}
	
	public boolean visit(TopLevelForm topLevelForm) {
		return visitNode( topLevelForm );
	}
	
	public boolean visit(TopLevelFunction topLevelFunction) {
		return visitNode( topLevelFunction );
	}
	
	public boolean visit(TransferStatement transferStatement) {
		return visitNode( transferStatement );
	}
	
	public boolean visit(TryStatement tryStatement) {
		return visitNode( tryStatement );
	}
	
	public boolean visit(TypeLiteralExpression typeLiteralExpression) {
		return visitNode( typeLiteralExpression );
	}
	
	public boolean visit(QualifiedName qualifiedName) {
		return visitNode( qualifiedName );
	}
	
	public boolean visit(UnaryExpression unaryExpression) {
		return visitNode( unaryExpression );
	}
	
	public boolean visit(UsingClause usingClause) {
		return visitNode( usingClause );
	}
	
	public boolean visit(UsingKeysClause usingKeysClause) {
		return visitNode( usingKeysClause );
	}
	
	public boolean visit(UseStatement useStatement) {
		return visitNode( useStatement );
	}
	
	public boolean visit(UsingPCBClause usingPCBClause) {
		return visitNode( usingPCBClause );
	}
	
	public boolean visit(VariableFormField variableFormField) {
		return visitNode( variableFormField );
	}
	
	public boolean visit(WhenClause whenClause) {
		return visitNode( whenClause );
	}
	
	public boolean visit(WhileStatement whileStatement) {
		return visitNode( whileStatement );
	}
	
	public boolean visit(WithIDClause withIDClause) {
		return visitNode( withIDClause );
	}
	
	public boolean visit(WithExpressionClause withExprClause) {
		return visitNode( withExprClause );
	}

	public boolean visit(WithInlineDLIClause withInlineDLIClause) {
		return visitNode( withInlineDLIClause );
	}
	
	public boolean visit(WithInlineSQLClause withInlineSQLClause) {
		return visitNode( withInlineSQLClause );
	}
	
	public void endVisit(AddStatement addStatement) {
		 endVisitNode( addStatement );
	}
	
	public void endVisit(AnnotationExpression annotationExpression) {
		 endVisitNode( annotationExpression );
	}
	
	public void endVisit(ArrayAccess arrayAccess) {
		 endVisitNode( arrayAccess );
	}
	
	public void endVisit(ArrayLiteral arrayLiteral) {
		 endVisitNode( arrayLiteral );
	}
	
	public void endVisit(ArrayType arrayType) {
		 endVisitNode( arrayType );
	}
	
	public void endVisit(AsExpression asExpression) {
		 endVisitNode( asExpression );
	}
	
	public void endVisit(Assignment assignment) {
		 endVisitNode( assignment );
	}
	
	public void endVisit(AssignmentStatement assignmentStatement) {
		 endVisitNode( assignmentStatement );
	}
	
	public void endVisit(BinaryExpression binaryExpression) {
		 endVisitNode( binaryExpression );
	}
	
	public void endVisit(BooleanLiteral booleanLiteral) {
		 endVisitNode( booleanLiteral );
	}
	
	public void endVisit(CallStatement callStatement) {
		 endVisitNode( callStatement );
	}
	
	public void endVisit(CallbackTarget callbackTarget) {
		 endVisitNode( callbackTarget );
	}

	public void endVisit(CallReturns callReturns) {
		 endVisitNode( callReturns );
	}

	public void endVisit(CallSynchronizationValues callSynch) {
		 endVisitNode( callSynch );
	}

	public void endVisit(CaseStatement caseStatement) {
		 endVisitNode( caseStatement );
	}
	
	public void endVisit(CharLiteral charLiteral) {
		 endVisitNode( charLiteral );
	}
	
	public void endVisit(ClassDataDeclaration classDataDeclaration) {
		 endVisitNode( classDataDeclaration );
	}
	
	public void endVisit(CloseStatement closeStatement) {
		 endVisitNode( closeStatement );
	}
	
	public void endVisit(ConstantFormField constantFormField) {
		 endVisitNode( constantFormField );
	}
	
	public void endVisit(Constructor constructor) {
		 endVisitNode( constructor );
	}
	
	public void endVisit(ContinueStatement continueStatement) {
		 endVisitNode( continueStatement );
	}
	
	public void endVisit(ConverseStatement converseStatement) {
		 endVisitNode( converseStatement );
	}
	
	public void endVisit(DataItem dataItem) {
		 endVisitNode( dataItem );
	}
	
	public void endVisit(DataTable dataTable) {
		 endVisitNode( dataTable );
	}
	
	public void endVisit(DBCharLiteral dBCharLiteral) {
		 endVisitNode( dBCharLiteral );
	}
	
	public void endVisit(DecimalLiteral decimalLiteral) {
		 endVisitNode( decimalLiteral );
	}
	
	public void endVisit(Delegate delegate) {
		 endVisitNode( delegate );
	}
	
	public void endVisit(DeleteStatement deleteStatement) {
		 endVisitNode( deleteStatement );
	}
	
	public void endVisit(DisplayStatement displayStatement) {
		 endVisitNode( displayStatement );
	}
	
	public void endVisit(ElseBlock elseBlock) {
		 endVisitNode( elseBlock );
	}
	
	public void endVisit(EmptyStatement emptyStatement) {
		 endVisitNode( emptyStatement );
	}
	
	public void endVisit(Enumeration enumeration) {
		 endVisitNode( enumeration );
	}
	
	public void endVisit(EnumerationField enumerationField) {
		 endVisitNode( enumerationField );
	}
	
	public void endVisit(ExecuteStatement executeStatement) {
		 endVisitNode( executeStatement );
	}
	
	public void endVisit(ExitStatement exitStatement) {
		 endVisitNode( exitStatement );
	}
	
	public void endVisit(ExternalType externalType) {
		 endVisitNode( externalType );
	}
	
	public void endVisit(FieldAccess fieldAccess) {
		 endVisitNode( fieldAccess );
	}
	
	public void endVisit(File file) {
		 endVisitNode( file );
	}
	
	public void endVisit(FloatLiteral floatLiteral) {
		 endVisitNode( floatLiteral );
	}
	
	public void endVisit(ForEachStatement forEachStatement) {
		 endVisitNode( forEachStatement );
	}
	
	public void endVisit(ForExpressionClause forExpressionClause) {
		 endVisitNode( forExpressionClause );
	}
	
	public void endVisit(FormGroup formGroup) {
		 endVisitNode( formGroup );
	}
	
	public void endVisit(ForStatement forStatement) {
		 endVisitNode( forStatement );
	}
	
	public void endVisit(ForUpdateClause forUpdateClause) {
		 endVisitNode( forUpdateClause );
	}
	
	public void endVisit(ForwardStatement forwardStatement) {
		 endVisitNode( forwardStatement );
	}
	
	public void endVisit(FreeSQLStatement freeSQLStatement) {
		 endVisitNode( freeSQLStatement );
	}
	
	public void endVisit(FromExpressionClause fromExpressionClause) {
		 endVisitNode( fromExpressionClause );
	}
	
	public void endVisit( FromOrToExpressionClause clause) {
		 endVisitNode( clause );
	}
	
	public void endVisit(FunctionDataDeclaration functionDataDeclaration) {
		 endVisitNode( functionDataDeclaration );
	}
	
	public void endVisit(FunctionInvocation functionInvocation) {
		 endVisitNode( functionInvocation );
	}
	
	public void endVisit(FunctionInvocationStatement functionInvocationStatement) {
		 endVisitNode( functionInvocationStatement );
	}
	
	public void endVisit(FunctionParameter functionParameter) {
		 endVisitNode( functionParameter );
	}
	
	public void endVisit(GetByKeyStatement getByKeyStatement) {
		 endVisitNode( getByKeyStatement );
	}
	
	public void endVisit(GetByPositionStatement getByPositionStatement) {
		 endVisitNode( getByPositionStatement );
	}
	
	public void endVisit(GotoStatement gotoStatement) {
		 endVisitNode( gotoStatement );
	}
	
	public void endVisit(Handler handler) {
		 endVisitNode( handler );
	}
	
	public void endVisit(HexLiteral hexLiteral) {
		 endVisitNode( hexLiteral );
	}
	
	public void endVisit(ImportDeclaration importDeclaration) {
		 endVisitNode( importDeclaration );
	}
	
	public void endVisit(IfStatement ifStatement) {
		 endVisitNode( ifStatement );
	}
	
	public void endVisit(InExpression inExpression) {
		 endVisitNode( inExpression );
	}
	
	public void endVisit(InlineDLIStatement inlineDLIStatement) {
		 endVisitNode( inlineDLIStatement );
	}
	
	public void endVisit(InlineSQLStatement inlineSQLStatement) {
		 endVisitNode( inlineSQLStatement );
	}
	
	public void endVisit(IntegerLiteral integerLiteral) {
		 endVisitNode( integerLiteral );
	}
	
	public void endVisit(Interface interfaceNode) {
		 endVisitNode( interfaceNode );
	}
	
	public void endVisit(IntoClause intoClause) {
		 endVisitNode( intoClause );
	}
	
	public void endVisit(IsAExpression isAExpression) {
		 endVisitNode( isAExpression );
	}
	
	public void endVisit(IsNotExpression isNotExpression) {
		 endVisitNode( isNotExpression );
	}
	
	public void endVisit(LabelStatement labelStatement) {
		 endVisitNode( labelStatement );
	}
	
	public void endVisit(Library library) {
		 endVisitNode( library );
	}
	
	public void endVisit(LikeMatchesExpression likeMatchesExpression) {
		 endVisitNode( likeMatchesExpression );
	}
	
	public void endVisit(MBCharLiteral mBCharLiteral) {
		 endVisitNode( mBCharLiteral );
	}
	
	public void endVisit(MoveStatement moveStatement) {
		 endVisitNode( moveStatement );
	}
	
	public void endVisit(NameType nameType) {
		 endVisitNode( nameType );
	}
	
	public void endVisit(NestedForm nestedForm) {
		 endVisitNode( nestedForm );
	}
	
	public void endVisit(NestedFunction nestedFunction) {
		 endVisitNode( nestedFunction );
	}
	
	public void endVisit(NewExpression newExpression) {
		 endVisitNode( newExpression );
	}
	
	public void endVisit(NullLiteral nullLiteral) {
		 endVisitNode( nullLiteral );
	}
	
	public void endVisit(NullableType nullableType) {
		 endVisitNode( nullableType );
	}
	
	public void endVisit(NoCursorClause noCursorClause) {
		 endVisitNode( noCursorClause );
	}
	
	public void endVisit(ObjectExpression objExpr) {
		 endVisitNode( objExpr );
	}

	public void endVisit(ObjectExpressionEntry objExprEntry) {
		 endVisitNode( objExprEntry );
	}

	public void endVisit(OnEventBlock onEventBlock) {
		 endVisitNode( onEventBlock );
	}
	
	public void endVisit(OnExceptionBlock onExceptionBlock) {
		 endVisitNode( onExceptionBlock );
	}
	
	public void endVisit(OpenStatement openStatement) {
		 endVisitNode( openStatement );
	}
	
	public void endVisit(OpenUIStatement openUIStatement) {
		 endVisitNode( openUIStatement );
	}
	
	public void endVisit(OtherwiseClause otherwiseClause) {
		 endVisitNode( otherwiseClause );
	}
	
	public void endVisit(PackageDeclaration packageDeclaration) {
		 endVisitNode( packageDeclaration );
	}
	
	public void endVisit(ParenthesizedExpression parenthesizedExpression) {
		 endVisitNode( parenthesizedExpression );
	}
	
	public void endVisit(PassingClause passingClause) {
		 endVisitNode( passingClause );
	}
	
	public void endVisit(PrepareStatement prepareStatement) {
		 endVisitNode( prepareStatement );
	}
	
	public void endVisit(PrimitiveType primitiveType) {
		 endVisitNode( primitiveType );
	}
	
	public void endVisit(PrintStatement printStatement) {
		 endVisitNode( printStatement );
	}
	
	public void endVisit(Program program) {
		 endVisitNode( program );
	}
	
	public void endVisit(ProgramParameter programParameter) {
		 endVisitNode( programParameter );
	}
	
	public void endVisit(Record record) {
		 endVisitNode( record );
	}
	
	public void endVisit(ReplaceStatement replaceStatement) {
		 endVisitNode( replaceStatement );
	}
	
	public void endVisit(ReturnsDeclaration returnsDeclaration) {
		 endVisitNode( returnsDeclaration );
	}
	
	public void endVisit(ReturningToInvocationTargetClause returningToInvocationTargetClause) {
		 endVisitNode( returningToInvocationTargetClause );
	}
	
	public void endVisit(ReturningToNameClause returningToNameClause) {
		 endVisitNode( returningToNameClause );
	}
	
	public void endVisit(ReturnStatement returnStatement) {
		 endVisitNode( returnStatement );
	}
	
	public void endVisit(Service service) {
		 endVisitNode( service );
	}
	
	public void endVisit(ServiceReference serviceReference) {
		 endVisitNode( serviceReference );
	}
	
	public void endVisit(SetStatement setStatement) {
		 endVisitNode( setStatement );
	}
	
	public void endVisit(SetValuesExpression setValuesExpression) {
		 endVisitNode( setValuesExpression );
	}
	
	public void endVisit(SetValuesStatement setValuesStatement) {
		 endVisitNode( setValuesStatement );
	}
	
	public void endVisit(SettingsBlock settingsBlock) {
		 endVisitNode( settingsBlock );
	}
	
	public void endVisit(ShowStatement showStatement) {
		 endVisitNode( showStatement );
	}
	
	public void endVisit(SimpleName simpleName) {
		 endVisitNode( simpleName );
	}
	
	public void endVisit(SingleRowClause singleRowClause) {
		 endVisitNode( singleRowClause );
	}
	
	public void endVisit(StringLiteral stringLiteral) {
		 endVisitNode( stringLiteral );
	}
	
	public void endVisit(StructureItem structureItem) {
		 endVisitNode( structureItem );
	}
	
	public void endVisit(SQLLiteral sQLLiteral) {
		 endVisitNode( sQLLiteral );
	}
	
	public void endVisit(SubstringAccess substringAccess) {
		 endVisitNode( substringAccess );
	}
	
	public void endVisit(ThisExpression thisExpression) {
		 endVisitNode( thisExpression );
	}
	
	public void endVisit(ThrowStatement throwStatement) {
		 endVisitNode( throwStatement );
	}
	
	public void endVisit(TopLevelForm topLevelForm) {
		 endVisitNode( topLevelForm );
	}
	
	public void endVisit(TopLevelFunction topLevelFunction) {
		 endVisitNode( topLevelFunction );
	}
	
	public void endVisit(TransferStatement transferStatement) {
		 endVisitNode( transferStatement );
	}
	
	public void endVisit(TryStatement tryStatement) {
		 endVisitNode( tryStatement );
	}
	
	public void endVisit(TypeLiteralExpression typeLiteralExpression) {
		 endVisitNode( typeLiteralExpression );
	}
	
	public void endVisit(QualifiedName qualifiedName) {
		 endVisitNode( qualifiedName );
	}
	
	public void endVisit(UnaryExpression unaryExpression) {
		 endVisitNode( unaryExpression );
	}
	
	public void endVisit(UsingClause usingClause) {
		 endVisitNode( usingClause );
	}
	
	public void endVisit(UsingKeysClause usingKeysClause) {
		 endVisitNode( usingKeysClause );
	}
	
	public void endVisit(UseStatement useStatement) {
		 endVisitNode( useStatement );
	}
	
	public void endVisit(UsingPCBClause usingPCBClause) {
		 endVisitNode( usingPCBClause );
	}
	
	public void endVisit(VariableFormField variableFormField) {
		 endVisitNode( variableFormField );
	}
	
	public void endVisit(WhenClause whenClause) {
		 endVisitNode( whenClause );
	}
	
	public void endVisit(WhileStatement whileStatement) {
		 endVisitNode( whileStatement );
	}
	
	public void endVisit(WithExpressionClause withExprClause) {
		 endVisitNode( withExprClause );
	}

	public void endVisit(WithIDClause withIDClause) {
		 endVisitNode( withIDClause );
	}
	
	public void endVisit(WithInlineDLIClause withInlineDLIClause) {
		 endVisitNode( withInlineDLIClause );
	}
	
	public void endVisit(WithInlineSQLClause withInlineSQLClause) {
		 endVisitNode( withInlineSQLClause );
	}
	
}
