/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/

//----------------------------------------------------
// The following code was generated by CUP v0.10k
// Mon Mar 21 18:29:35 EST 2005
//----------------------------------------------------

package org.eclipse.edt.compiler.internal.dli;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import java_cup.runtime.Symbol;

import org.eclipse.edt.compiler.internal.core.builder.IMarker;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.Problem;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;



/** CUP v0.10k generated parser.
  * @version Mon Mar 21 18:29:35 EST 2005
  */
public class DLIParser extends java_cup.runtime.lr_parser {

/** Default constructor. */
  public DLIParser(ICompilerOptions compilerOptions) {
	  super();
  	  eglParser = new DLIEGLParser(compilerOptions);
  }

  /** Constructor which sets the default scanner. */
  public DLIParser(java_cup.runtime.Scanner s, ICompilerOptions compilerOptions) {
	  super(s);
	  eglParser = new DLIEGLParser(compilerOptions);
  }

  /** Production table. */
  protected static final short _production_table[][] = 
    unpackFromStrings(new String[] {
    "\000\035\000\002\003\003\000\002\002\004\000\002\004" +
    "\004\000\002\004\003\000\002\005\003\000\002\006\005" +
    "\000\002\007\002\000\002\007\004\000\002\010\002\000" +
    "\002\010\005\000\002\010\005\000\002\011\003\000\002" +
    "\011\005\000\002\012\005\000\002\013\003\000\002\013" +
    "\003\000\002\014\003\000\002\014\003\000\002\014\003" +
    "\000\002\014\003\000\002\014\003\000\002\015\002\000" +
    "\002\015\003\000\002\016\003\000\002\016\004\000\002" +
    "\017\002\000\002\017\003\000\002\020\003\000\002\020" +
    "\004" });

  /** Access to production table. */
  public short[][] production_table() {return _production_table;}

  /** Parse-action table. */
  protected static final short[][] _action_table = 
    unpackFromStrings(new String[] {
    "\000\045\000\010\002\uffec\003\005\006\010\001\002\000" +
    "\004\002\001\001\002\000\010\002\ufffe\003\ufffe\006\ufffe" +
    "\001\002\000\010\002\uffeb\003\005\006\010\001\002\000" +
    "\010\002\uffea\003\uffea\006\uffea\001\002\000\014\002\ufffd" +
    "\003\ufffd\006\ufffd\007\ufffd\013\ufffd\001\002\000\004\002" +
    "\046\001\002\000\014\002\uffe8\003\uffe8\006\uffe8\007\013" +
    "\013\017\001\002\000\022\002\ufff3\003\ufff3\006\ufff3\007" +
    "\ufff3\013\ufff3\015\ufff3\017\ufff3\023\ufff3\001\002\000\014" +
    "\002\uffe6\003\uffe6\006\uffe6\007\uffe6\013\uffe6\001\002\000" +
    "\020\002\ufffb\003\ufffb\006\ufffb\007\ufffb\013\ufffb\017\ufffb" +
    "\023\023\001\002\000\010\002\uffff\003\uffff\006\uffff\001" +
    "\002\000\022\002\ufff2\003\ufff2\006\ufff2\007\ufff2\013\ufff2" +
    "\015\ufff2\017\ufff2\023\ufff2\001\002\000\014\002\uffe7\003" +
    "\uffe7\006\uffe7\007\013\013\017\001\002\000\014\002\uffe5" +
    "\003\uffe5\006\uffe5\007\uffe5\013\uffe5\001\002\000\016\002" +
    "\ufff9\003\ufff9\006\ufff9\007\ufff9\013\ufff9\017\025\001\002" +
    "\000\004\007\024\001\002\000\016\002\ufffa\003\ufffa\006" +
    "\ufffa\007\ufffa\013\ufffa\017\ufffa\001\002\000\020\004\031" +
    "\007\013\010\036\011\037\012\033\013\017\014\035\001" +
    "\002\000\014\002\ufffc\003\ufffc\006\ufffc\007\ufffc\013\ufffc" +
    "\001\002\000\004\015\044\001\002\000\006\016\ufff6\020" +
    "\ufff6\001\002\000\006\016\uffed\020\uffed\001\002\000\006" +
    "\016\042\020\041\001\002\000\006\016\uffef\020\uffef\001" +
    "\002\000\004\020\040\001\002\000\006\016\uffee\020\uffee" +
    "\001\002\000\006\016\ufff1\020\ufff1\001\002\000\006\016" +
    "\ufff0\020\ufff0\001\002\000\014\002\ufff7\003\ufff7\006\ufff7" +
    "\007\ufff7\013\ufff7\001\002\000\014\002\ufff8\003\ufff8\006" +
    "\ufff8\007\ufff8\013\ufff8\001\002\000\006\007\013\013\017" +
    "\001\002\000\006\016\ufff5\020\ufff5\001\002\000\014\004" +
    "\031\010\036\011\037\012\033\014\035\001\002\000\006" +
    "\016\ufff4\020\ufff4\001\002\000\004\002\000\001\002\000" +
    "\010\002\uffe9\003\uffe9\006\uffe9\001\002" });

  /** Access to parse-action table. */
  public short[][] action_table() {return _action_table;}

  /** <code>reduce_goto</code> table. */
  protected static final short[][] _reduce_table = 
    unpackFromStrings(new String[] {
    "\000\045\000\014\003\010\004\006\005\011\015\003\016" +
    "\005\001\001\000\002\001\001\000\002\001\001\000\006" +
    "\004\046\005\011\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\012\006\013\013\014\017\015" +
    "\020\017\001\001\000\002\001\001\000\002\001\001\000" +
    "\004\007\021\001\001\000\002\001\001\000\002\001\001" +
    "\000\006\006\020\013\014\001\001\000\002\001\001\000" +
    "\004\010\025\001\001\000\002\001\001\000\002\001\001" +
    "\000\012\011\031\012\027\013\026\014\033\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\006\012\042\013" +
    "\026\001\001\000\002\001\001\000\004\014\044\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001" });

  /** Access to <code>reduce_goto</code> table. */
  public short[][] reduce_table() {return _reduce_table;}

  /** Instance of action encapsulation class. */
  protected CUP$DLIParser$actions action_obj;

  /** Action encapsulation object initializer. */
  protected void init_actions()
    {
      action_obj = new CUP$DLIParser$actions(this);
    }

  /** Invoke a user supplied parse action. */
  public java_cup.runtime.Symbol do_action(
    int                        act_num,
    java_cup.runtime.lr_parser parser,
    Stack            stack,
    int                        top)
    throws java.lang.Exception
  {
    /* call code in generated class */
    return action_obj.CUP$DLIParser$do_action(act_num, parser, stack, top);
  }

  /** Indicates start state. */
  public int start_state() {return 0;}
  /** Indicates start production. */
  public int start_production() {return 1;}

  /** <code>EOF</code> Symbol index. */
  public int EOF_sym() {return 0;}

  /** <code>error</code> Symbol index. */
  public int error_sym() {return 1;}



  	private String parseString;

  	List messages = new ArrayList();
  	DLIEGLParser eglParser;
  	
  
    /* (non-Javadoc)
     * @see java_cup.runtime.lr_parser#report_error(java.lang.String, java.lang.Object)
     */
    public void report_error(String message, Object info) {
        Symbol symbol = (Symbol) info;
        messages.add(new Problem(
            symbol.left,
            symbol.right,
            IMarker.SEVERITY_ERROR,
            IProblemRequestor.UNEXPECTED_TOKEN,
            new String[] { ((DLILexer) getScanner()).yytext() }
        ));				
    }
    
    public int getHostVariableLength(int startPosition) {
    	return eglParser.getHostVariableLength(parseString.substring(startPosition));
   	}
    
    public DLIModel parse(String string) throws Exception {
        this.parseString = string;
        
        DLILexer lexer = new DLILexer(new StringReader(string));
        setScanner(lexer);
        lexer.setParser(this);
        
        DLIModel result = (DLIModel) parse().value;

        this.parseString = null;
        
        return result;
    }

}

/** Cup generated class to encapsulate user supplied action code.*/
class CUP$DLIParser$actions {
  private final DLIParser parser;

  /** Constructor */
  CUP$DLIParser$actions(DLIParser parser) {
    this.parser = parser;
  }

  /** Method with the actual generated action code. */
  public final java_cup.runtime.Symbol CUP$DLIParser$do_action(
    int                        CUP$DLIParser$act_num,
    java_cup.runtime.lr_parser CUP$DLIParser$parser,
    Stack            CUP$DLIParser$stack,
    int                        CUP$DLIParser$top)
    throws java.lang.Exception
    {
      /* Symbol object for return from actions */
      java_cup.runtime.Symbol CUP$DLIParser$result;

      /* select the action based on the action number */
      switch (CUP$DLIParser$act_num)
        {
          /*. . . . . . . . . . . . . . . . . . . .*/
          case 28: // ssa_plus ::= ssa_plus ssa 
            {
              List RESULT = null;
		int ssasleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int ssasright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		List ssas = (List)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		int ssaleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int ssaright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		ISegmentSearchArgument ssa = (ISegmentSearchArgument)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 ssas.add(ssa); RESULT = ssas; 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(14/*ssa_plus*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 27: // ssa_plus ::= ssa 
            {
              List RESULT = null;
		int ssaleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int ssaright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		ISegmentSearchArgument ssa = (ISegmentSearchArgument)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new ArrayList(); RESULT.add(ssa); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(14/*ssa_plus*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 26: // ssa_star ::= ssa_plus 
            {
              List RESULT = null;
		int ssasleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int ssasright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		List ssas = (List)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = ssas; 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(13/*ssa_star*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 25: // ssa_star ::= 
            {
              List RESULT = null;
		 RESULT = new ArrayList(); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(13/*ssa_star*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 24: // statement_plus ::= statement_plus statement 
            {
              List RESULT = null;
		int statementsleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int statementsright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		List statements = (List)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		int statementleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int statementright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		IStatement statement = (IStatement)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 if(statement != null) statements.add(statement); RESULT = statements; 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(12/*statement_plus*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 23: // statement_plus ::= statement 
            {
              List RESULT = null;
		int statementleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int statementright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		IStatement statement = (IStatement)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new ArrayList(); if(statement != null) RESULT.add(statement); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(12/*statement_plus*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 22: // statement_star ::= statement_plus 
            {
              List RESULT = null;
		int statementsleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int statementsright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		List statements = (List)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = statements; 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(11/*statement_star*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 21: // statement_star ::= 
            {
              List RESULT = null;
		 RESULT = new ArrayList(); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(11/*statement_star*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 20: // value ::= HOSTVAR 
            {
              IValue RESULT = null;
		int dataAccessString1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int dataAccessString1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String dataAccessString1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new HostVariableValue(dataAccessString1, dataAccessString1left, dataAccessString1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(10/*value*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 19: // value ::= STRINGLIT 
            {
              IValue RESULT = null;
		int value1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int value1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String value1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new StringLiteralValue(value1, value1left, value1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(10/*value*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 18: // value ::= FLOATLIT 
            {
              IValue RESULT = null;
		int value1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int value1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String value1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new FloatLiteralValue(value1, value1left, value1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(10/*value*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 17: // value ::= DECIMALLIT 
            {
              IValue RESULT = null;
		int value1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int value1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String value1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new DecimalLiteralValue(value1, value1left, value1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(10/*value*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 16: // value ::= INTEGERLIT 
            {
              IValue RESULT = null;
		int value1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int value1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String value1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new IntegerLiteralValue(value1, value1left, value1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(10/*value*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 15: // name ::= SINGLE_QUOTED_STRINGLIT 
            {
              IName RESULT = null;
		int quotedName1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int quotedName1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String quotedName1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new QuotedName(quotedName1, quotedName1left, quotedName1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(9/*name*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 14: // name ::= ID 
            {
              IName RESULT = null;
		int id1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int id1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String id1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new SimpleName(id1, id1left, id1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(9/*name*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 13: // condition ::= name RELATIONOP value 
            {
              ICondition RESULT = null;
		int fieldName1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).left;
		int fieldName1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).right;
		IName fieldName1 = (IName)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).value;
		int operator1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int operator1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		String operator1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		int value1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int value1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		IValue value1 = (IValue)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new Condition(fieldName1, operator1, value1, fieldName1left, value1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(8/*condition*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 12: // conditions ::= conditions BOOLEANOP condition 
            {
              IBooleanExpression RESULT = null;
		int left1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).left;
		int left1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).right;
		IBooleanExpression left1 = (IBooleanExpression)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).value;
		int operator1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int operator1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		String operator1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		int right1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int right1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		ICondition right1 = (ICondition)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new BooleanOperatorExpression(left1, operator1, right1, left1left, right1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(7/*conditions*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 11: // conditions ::= condition 
            {
              IBooleanExpression RESULT = null;
		int condition1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int condition1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		ICondition condition1 = (ICondition)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = condition1; 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(7/*conditions*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 10: // conditions_opt ::= LPAREN value RPAREN 
            {
              ISSAConditions RESULT = null;
		int value1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int value1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		IValue value1 = (IValue)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		 RESULT = new ValueExpressionSSAConditions(value1, value1left, value1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(6/*conditions_opt*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 9: // conditions_opt ::= LPAREN conditions RPAREN 
            {
              ISSAConditions RESULT = null;
		int conditions1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int conditions1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		IBooleanExpression conditions1 = (IBooleanExpression)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		 RESULT = new BooleanExpressionSSAConditions(conditions1, conditions1left, conditions1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(6/*conditions_opt*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 8: // conditions_opt ::= 
            {
              ISSAConditions RESULT = null;

              CUP$DLIParser$result = new java_cup.runtime.Symbol(6/*conditions_opt*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 7: // commandCodes_opt ::= ASTERISK ID 
            {
              ICommandCodes RESULT = null;
		int id1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int id1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String id1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new CommandCodes(id1, id1left, id1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(5/*commandCodes_opt*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 6: // commandCodes_opt ::= 
            {
              ICommandCodes RESULT = null;

              CUP$DLIParser$result = new java_cup.runtime.Symbol(5/*commandCodes_opt*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 5: // ssa ::= name commandCodes_opt conditions_opt 
            {
              ISegmentSearchArgument RESULT = null;
		int name1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).left;
		int name1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).right;
		IName name1 = (IName)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).value;
		int commandCodes1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int commandCodes1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		ICommandCodes commandCodes1 = (ICommandCodes)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		int conditions1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int conditions1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		ISSAConditions conditions1 = (ISSAConditions)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new SegmentSearchArgument(name1, commandCodes1, conditions1, name1left, conditions1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(4/*ssa*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-2)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 4: // functionName ::= FUNCTIONNAME 
            {
              String RESULT = null;
		int functionName1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int functionName1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		String functionName1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = functionName1; 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(3/*functionName*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 3: // statement ::= error 
            {
              IStatement RESULT = null;

              CUP$DLIParser$result = new java_cup.runtime.Symbol(2/*statement*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 2: // statement ::= functionName ssa_star 
            {
              IStatement RESULT = null;
		int functionName1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int functionName1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		String functionName1 = (String)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		int ssas1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int ssas1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		List ssas1 = (List)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new Statement(functionName1, ssas1, functionName1left, ssas1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(2/*statement*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 1: // $START ::= dli EOF 
            {
              Object RESULT = null;
		int start_valleft = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left;
		int start_valright = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).right;
		IDLIModel start_val = (IDLIModel)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).value;
		RESULT = start_val;
              CUP$DLIParser$result = new java_cup.runtime.Symbol(0/*$START*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-1)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          /* ACCEPT */
          CUP$DLIParser$parser.done_parsing();
          return CUP$DLIParser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 0: // dli ::= statement_star 
            {
              IDLIModel RESULT = null;
		int statements1left = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left;
		int statements1right = ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right;
		List statements1 = (List)((java_cup.runtime.Symbol) CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).value;
		 RESULT = new DLIModel(statements1, parser.messages, statements1left, statements1right); 
              CUP$DLIParser$result = new java_cup.runtime.Symbol(1/*dli*/, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).left, ((java_cup.runtime.Symbol)CUP$DLIParser$stack.elementAt(CUP$DLIParser$top-0)).right, RESULT);
            }
          return CUP$DLIParser$result;

          /* . . . . . .*/
          default:
            throw new Exception(
               "Invalid action number found in internal parse table");

        }
    }
}

