/*******************************************************************************
 * Copyright © 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.mof.egl;

import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EEnum;
import org.eclipse.edt.mof.EFactory;

public interface IrFactoryBase extends EFactory  {
	public String packageName = "org.eclipse.edt.mof.egl";
	
	String AccessKind = packageName+".AccessKind";
	String AddStatement = packageName+".AddStatement";
	String Annotation = packageName+".Annotation";
	String AnnotationType = packageName+".AnnotationType";
	String ArrayAccess = packageName+".ArrayAccess";
	String ArrayElementMemberAccess = packageName+".ArrayElementMemberAccess";
	String ArrayLiteral = packageName+".ArrayLiteral";
	String ArrayType = packageName+".ArrayType";
	String AsExpression = packageName+".AsExpression";
	String Assignment = packageName+".Assignment";
	String AssignmentStatement = packageName+".AssignmentStatement";
	String BinaryExpression = packageName+".BinaryExpression";
	String BooleanLiteral = packageName+".BooleanLiteral";
	String BoxingExpression = packageName+".BoxingExpression";
	String BuiltInOperation = packageName+".BuiltInOperation";
	String BuiltInOperationExpression = packageName+".BuiltInOperationExpression";
	String CallStatement = packageName+".CallStatement";
	String CaseStatement = packageName+".CaseStatement";
	String CharLiteral = packageName+".CharLiteral";
	String Classifier = packageName+".Classifier";
	String CloseStatement = packageName+".CloseStatement";
	String ConditionalStatement = packageName+".ConditionalStatement";
	String ConstantField = packageName+".ConstantField";
	String ConstantFormField = packageName+".ConstantFormField";
	String Constructor = packageName+".Constructor";
	String Container = packageName+".Container";
	String ContinueStatement = packageName+".ContinueStatement";
	String ConverseStatement = packageName+".ConverseStatement";
	String ConversionOperation = packageName+".ConversionOperation";
	String ConvertExpression = packageName+".ConvertExpression";
	String ConvertStatement = packageName+".ConvertStatement";
	String DanglingReference = packageName+".DanglingReference";
	String DataItem = packageName+".DataItem";
	String DataTable = packageName+".DataTable";
	String DataType = packageName+".DataType";
	String DBCharLiteral = packageName+".DBCharLiteral";
	String DecimalLiteral = packageName+".DecimalLiteral";
	String DeclarationExpression = packageName+".DeclarationExpression";
	String Delegate = packageName+".Delegate";
	String DelegateInvocation = packageName+".DelegateInvocation";
	String DeleteStatement = packageName+".DeleteStatement";
	String DirectionKind = packageName+".DirectionKind";
	String DisplayStatement = packageName+".DisplayStatement";
	String DynamicAccess = packageName+".DynamicAccess";
	String EClassProxy = packageName+".EClassProxy";
	String EGLClass = packageName+".EGLClass";
	String Element = packageName+".Element";
	String ElementAnnotations = packageName+".ElementAnnotations";
	String ElementKind = packageName+".ElementKind";
	String EmptyStatement = packageName+".EmptyStatement";
	String Enumeration = packageName+".Enumeration";
	String EnumerationEntry = packageName+".EnumerationEntry";
	String ETypeKind = packageName+".ETypeKind";
	String ExceptionBlock = packageName+".ExceptionBlock";
	String ExecuteStatement = packageName+".ExecuteStatement";
	String ExitStatement = packageName+".ExitStatement";
	String Expression = packageName+".Expression";
	String ExpressionStatement = packageName+".ExpressionStatement";
	String ExternalType = packageName+".ExternalType";
	String Field = packageName+".Field";
	String FixedPrecisionType = packageName+".FixedPrecisionType";
	String FloatingPointLiteral = packageName+".FloatingPointLiteral";
	String ForEachStatement = packageName+".ForEachStatement";
	String Form = packageName+".Form";
	String FormField = packageName+".FormField";
	String FormGroup = packageName+".FormGroup";
	String ForStatement = packageName+".ForStatement";
	String ForwardStatement = packageName+".ForwardStatement";
	String FreeSqlStatement = packageName+".FreeSqlStatement";
	String Function = packageName+".Function";
	String FunctionInvocation = packageName+".FunctionInvocation";
	String FunctionMember = packageName+".FunctionMember";
	String FunctionParameter = packageName+".FunctionParameter";
	String FunctionPart = packageName+".FunctionPart";
	String FunctionPartInvocation = packageName+".FunctionPartInvocation";
	String FunctionReturnField = packageName+".FunctionReturnField";
	String FunctionStatement = packageName+".FunctionStatement";
	String GenericType = packageName+".GenericType";
	String GetByKeyStatement = packageName+".GetByKeyStatement";
	String GetByPositionKind = packageName+".GetByPositionKind";
	String GetByPositionStatement = packageName+".GetByPositionStatement";
	String GoToStatement = packageName+".GoToStatement";
	String Handler = packageName+".Handler";
	String HexLiteral = packageName+".HexLiteral";
	String IfStatement = packageName+".IfStatement";
	String InExpression = packageName+".InExpression";
	String IntegerLiteral = packageName+".IntegerLiteral";
	String Interface = packageName+".Interface";
	String IntervalType = packageName+".IntervalType";
	String InvalidName = packageName+".InvalidName";
	String InvocationExpression = packageName+".InvocationExpression";
	String IOStatement = packageName+".IOStatement";
	String IsAExpression = packageName+".IsAExpression";
	String IsNotExpression = packageName+".IsNotExpression";
	String LabelStatement = packageName+".LabelStatement";
	String LHSExpr = packageName+".LHSExpr";
	String Library = packageName+".Library";
	String Literal = packageName+".Literal";
	String LocalVariableDeclarationStatement = packageName+".LocalVariableDeclarationStatement";
	String LogicAndDataPart = packageName+".LogicAndDataPart";
	String LoopStatement = packageName+".LoopStatement";
	String MBCharLiteral = packageName+".MBCharLiteral";
	String Member = packageName+".Member";
	String MemberAccess = packageName+".MemberAccess";
	String MemberName = packageName+".MemberName";
	String MoveStatement = packageName+".MoveStatement";
	String Name = packageName+".Name";
	String NamedElement = packageName+".NamedElement";
	String NewExpression = packageName+".NewExpression";
	String NullLiteral = packageName+".NullLiteral";
	String NullType = packageName+".NullType";
	String NumericLiteral = packageName+".NumericLiteral";
	String ObjectExpression = packageName+".ObjectExpression";
	String ObjectExpressionEntry = packageName+".ObjectExpressionEntry";
	String OpenStatement = packageName+".OpenStatement";
	String OpenUIStatement = packageName+".OpenUIStatement";
	String Operation = packageName+".Operation";
	String Parameter = packageName+".Parameter";
	String ParameterizableType = packageName+".ParameterizableType";
	String ParameterizedType = packageName+".ParameterizedType";
	String ParameterKind = packageName+".ParameterKind";
	String Part = packageName+".Part";
	String PartName = packageName+".PartName";
	String PatternType = packageName+".PatternType";
	String PrepareStatement = packageName+".PrepareStatement";
	String PrimitiveTypeLiteral = packageName+".PrimitiveTypeLiteral";
	String PrintStatement = packageName+".PrintStatement";
	String Program = packageName+".Program";
	String ProgramParameter = packageName+".ProgramParameter";
	String QualifiedFunctionInvocation = packageName+".QualifiedFunctionInvocation";
	String Record = packageName+".Record";
	String ReplaceStatement = packageName+".ReplaceStatement";
	String ReturnStatement = packageName+".ReturnStatement";
	String SequenceType = packageName+".SequenceType";
	String Service = packageName+".Service";
	String SetStatement = packageName+".SetStatement";
	String SetValuesExpression = packageName+".SetValuesExpression";
	String SetValuesStatement = packageName+".SetValuesStatement";
	String ShowStatement = packageName+".ShowStatement";
	String SizeInBytesExpression = packageName+".SizeInBytesExpression";
	String SizeOfExpression = packageName+".SizeOfExpression";
	String Statement = packageName+".Statement";
	String StatementBlock = packageName+".StatementBlock";
	String Stereotype = packageName+".Stereotype";
	String StereotypeType = packageName+".StereotypeType";
	String StringLiteral = packageName+".StringLiteral";
	String StructPart = packageName+".StructPart";
	String StructuredContainer = packageName+".StructuredContainer";
	String StructuredField = packageName+".StructuredField";
	String StructuredRecord = packageName+".StructuredRecord";
	String SubstringAccess = packageName+".SubstringAccess";
	String SystemFunctionArgumentMnemonicName = packageName+".SystemFunctionArgumentMnemonicName";
	String TernaryExpression = packageName+".TernaryExpression";
	String TextTypeLiteral = packageName+".TextTypeLiteral";
	String ThisExpression = packageName+".ThisExpression";
	String ThrowStatement = packageName+".ThrowStatement";
	String TimestampType = packageName+".TimestampType";
	String TopLevelFunctionName = packageName+".TopLevelFunctionName";
	String TransferStatement = packageName+".TransferStatement";
	String TryStatement = packageName+".TryStatement";
	String Type = packageName+".Type";
	String TypedElement = packageName+".TypedElement";
	String TypeExpression = packageName+".TypeExpression";
	String TypeName = packageName+".TypeName";
	String TypeParameter = packageName+".TypeParameter";
	String UnaryExpression = packageName+".UnaryExpression";
	String VariableFormField = packageName+".VariableFormField";
	String WhenClause = packageName+".WhenClause";
	String WhileStatement = packageName+".WhileStatement";
	
	EEnum getAccessKindEEnum();
	EClass getAddStatementEClass();
	EClass getAnnotationEClass();
	EClass getAnnotationTypeEClass();
	EClass getArrayAccessEClass();
	EClass getArrayElementMemberAccessEClass();
	EClass getArrayLiteralEClass();
	EClass getArrayTypeEClass();
	EClass getAsExpressionEClass();
	EClass getAssignmentEClass();
	EClass getAssignmentStatementEClass();
	EClass getBinaryExpressionEClass();
	EClass getBooleanLiteralEClass();
	EClass getBoxingExpressionEClass();
	EClass getBuiltInOperationEClass();
	EClass getBuiltInOperationExpressionEClass();
	EClass getCallStatementEClass();
	EClass getCaseStatementEClass();
	EClass getCharLiteralEClass();
	EClass getClassifierEClass();
	EClass getCloseStatementEClass();
	EClass getConditionalStatementEClass();
	EClass getConstantFieldEClass();
	EClass getConstantFormFieldEClass();
	EClass getConstructorEClass();
	EClass getContainerEClass();
	EClass getContinueStatementEClass();
	EClass getConverseStatementEClass();
	EClass getConversionOperationEClass();
	EClass getConvertExpressionEClass();
	EClass getConvertStatementEClass();
	EClass getDanglingReferenceEClass();
	EClass getDataItemEClass();
	EClass getDataTableEClass();
	EClass getDataTypeEClass();
	EClass getDBCharLiteralEClass();
	EClass getDecimalLiteralEClass();
	EClass getDeclarationExpressionEClass();
	EClass getDelegateEClass();
	EClass getDelegateInvocationEClass();
	EClass getDeleteStatementEClass();
	EEnum getDirectionKindEEnum();
	EClass getDisplayStatementEClass();
	EClass getDynamicAccessEClass();
	EClass getEClassProxyEClass();
	EClass getEGLClassEClass();
	EClass getElementEClass();
	EClass getElementAnnotationsEClass();
	EEnum getElementKindEEnum();
	EClass getEmptyStatementEClass();
	EClass getEnumerationEClass();
	EClass getEnumerationEntryEClass();
	EEnum getETypeKindEEnum();
	EClass getExceptionBlockEClass();
	EClass getExecuteStatementEClass();
	EClass getExitStatementEClass();
	EClass getExpressionEClass();
	EClass getExpressionStatementEClass();
	EClass getExternalTypeEClass();
	EClass getFieldEClass();
	EClass getFixedPrecisionTypeEClass();
	EClass getFloatingPointLiteralEClass();
	EClass getForEachStatementEClass();
	EClass getFormEClass();
	EClass getFormFieldEClass();
	EClass getFormGroupEClass();
	EClass getForStatementEClass();
	EClass getForwardStatementEClass();
	EClass getFreeSqlStatementEClass();
	EClass getFunctionEClass();
	EClass getFunctionInvocationEClass();
	EClass getFunctionMemberEClass();
	EClass getFunctionParameterEClass();
	EClass getFunctionPartEClass();
	EClass getFunctionPartInvocationEClass();
	EClass getFunctionReturnFieldEClass();
	EClass getFunctionStatementEClass();
	EClass getGenericTypeEClass();
	EClass getGetByKeyStatementEClass();
	EEnum getGetByPositionKindEEnum();
	EClass getGetByPositionStatementEClass();
	EClass getGoToStatementEClass();
	EClass getHandlerEClass();
	EClass getHexLiteralEClass();
	EClass getIfStatementEClass();
	EClass getInExpressionEClass();
	EClass getIntegerLiteralEClass();
	EClass getInterfaceEClass();
	EClass getIntervalTypeEClass();
	EClass getInvalidNameEClass();
	EClass getInvocationExpressionEClass();
	EClass getIOStatementEClass();
	EClass getIsAExpressionEClass();
	EClass getIsNotExpressionEClass();
	EClass getLabelStatementEClass();
	EClass getLHSExprEClass();
	EClass getLibraryEClass();
	EClass getLiteralEClass();
	EClass getLocalVariableDeclarationStatementEClass();
	EClass getLogicAndDataPartEClass();
	EClass getLoopStatementEClass();
	EClass getMBCharLiteralEClass();
	EClass getMemberEClass();
	EClass getMemberAccessEClass();
	EClass getMemberNameEClass();
	EClass getMoveStatementEClass();
	EClass getNameEClass();
	EClass getNamedElementEClass();
	EClass getNewExpressionEClass();
	EClass getNullLiteralEClass();
	EClass getNullTypeEClass();
	EClass getNumericLiteralEClass();
	EClass getObjectExpressionEClass();
	EClass getObjectExpressionEntryEClass();
	EClass getOpenStatementEClass();
	EClass getOpenUIStatementEClass();
	EClass getOperationEClass();
	EClass getParameterEClass();
	EClass getParameterizableTypeEClass();
	EClass getParameterizedTypeEClass();
	EEnum getParameterKindEEnum();
	EClass getPartEClass();
	EClass getPartNameEClass();
	EClass getPatternTypeEClass();
	EClass getPrepareStatementEClass();
	EClass getPrimitiveTypeLiteralEClass();
	EClass getPrintStatementEClass();
	EClass getProgramEClass();
	EClass getProgramParameterEClass();
	EClass getQualifiedFunctionInvocationEClass();
	EClass getRecordEClass();
	EClass getReplaceStatementEClass();
	EClass getReturnStatementEClass();
	EClass getSequenceTypeEClass();
	EClass getServiceEClass();
	EClass getSetStatementEClass();
	EClass getSetValuesExpressionEClass();
	EClass getSetValuesStatementEClass();
	EClass getShowStatementEClass();
	EClass getSizeInBytesExpressionEClass();
	EClass getSizeOfExpressionEClass();
	EClass getStatementEClass();
	EClass getStatementBlockEClass();
	EClass getStereotypeEClass();
	EClass getStereotypeTypeEClass();
	EClass getStringLiteralEClass();
	EClass getStructPartEClass();
	EClass getStructuredContainerEClass();
	EClass getStructuredFieldEClass();
	EClass getStructuredRecordEClass();
	EClass getSubstringAccessEClass();
	EClass getSystemFunctionArgumentMnemonicNameEClass();
	EClass getTernaryExpressionEClass();
	EClass getTextTypeLiteralEClass();
	EClass getThisExpressionEClass();
	EClass getThrowStatementEClass();
	EClass getTimestampTypeEClass();
	EClass getTopLevelFunctionNameEClass();
	EClass getTransferStatementEClass();
	EClass getTryStatementEClass();
	EClass getTypeEClass();
	EClass getTypedElementEClass();
	EClass getTypeExpressionEClass();
	EClass getTypeNameEClass();
	EClass getTypeParameterEClass();
	EClass getUnaryExpressionEClass();
	EClass getVariableFormFieldEClass();
	EClass getWhenClauseEClass();
	EClass getWhileStatementEClass();
	public AddStatement createAddStatement();
	public Annotation createAnnotation();
	public AnnotationType createAnnotationType();
	public ArrayAccess createArrayAccess();
	public ArrayElementMemberAccess createArrayElementMemberAccess();
	public ArrayLiteral createArrayLiteral();
	public ArrayType createArrayType();
	public AsExpression createAsExpression();
	public Assignment createAssignment();
	public AssignmentStatement createAssignmentStatement();
	public BinaryExpression createBinaryExpression();
	public BooleanLiteral createBooleanLiteral();
	public BoxingExpression createBoxingExpression();
	public BuiltInOperation createBuiltInOperation();
	public BuiltInOperationExpression createBuiltInOperationExpression();
	public CallStatement createCallStatement();
	public CaseStatement createCaseStatement();
	public CharLiteral createCharLiteral();
	public CloseStatement createCloseStatement();
	public ConstantField createConstantField();
	public ConstantFormField createConstantFormField();
	public Constructor createConstructor();
	public ContinueStatement createContinueStatement();
	public ConverseStatement createConverseStatement();
	public ConversionOperation createConversionOperation();
	public ConvertExpression createConvertExpression();
	public ConvertStatement createConvertStatement();
	public DanglingReference createDanglingReference();
	public DataItem createDataItem();
	public DataTable createDataTable();
	public DataType createDataType();
	public DBCharLiteral createDBCharLiteral();
	public DecimalLiteral createDecimalLiteral();
	public DeclarationExpression createDeclarationExpression();
	public Delegate createDelegate();
	public DeleteStatement createDeleteStatement();
	public DisplayStatement createDisplayStatement();
	public DynamicAccess createDynamicAccess();
	public EClassProxy createEClassProxy();
	public EGLClass createEGLClass();
	public ElementAnnotations createElementAnnotations();
	public EmptyStatement createEmptyStatement();
	public Enumeration createEnumeration();
	public EnumerationEntry createEnumerationEntry();
	public ExceptionBlock createExceptionBlock();
	public ExecuteStatement createExecuteStatement();
	public ExitStatement createExitStatement();
	public ExpressionStatement createExpressionStatement();
	public ExternalType createExternalType();
	public Field createField();
	public FixedPrecisionType createFixedPrecisionType();
	public FloatingPointLiteral createFloatingPointLiteral();
	public ForEachStatement createForEachStatement();
	public Form createForm();
	public FormField createFormField();
	public FormGroup createFormGroup();
	public ForStatement createForStatement();
	public ForwardStatement createForwardStatement();
	public FreeSqlStatement createFreeSqlStatement();
	public Function createFunction();
	public FunctionInvocation createFunctionInvocation();
	public DelegateInvocation createDelegateInvocation();
	public FunctionMember createFunctionMember();
	public FunctionParameter createFunctionParameter();
	public FunctionPart createFunctionPart();
	public FunctionPartInvocation createFunctionPartInvocation();
	public FunctionReturnField createFunctionReturnField();
	public FunctionStatement createFunctionStatement();
	public GenericType createGenericType();
	public GetByKeyStatement createGetByKeyStatement();
	public GetByPositionStatement createGetByPositionStatement();
	public GoToStatement createGoToStatement();
	public Handler createHandler();
	public HexLiteral createHexLiteral();
	public IfStatement createIfStatement();
	public IntegerLiteral createIntegerLiteral();
	public Interface createInterface();
	public IntervalType createIntervalType();
	public InvalidName createInvalidName();
	public IsAExpression createIsAExpression();
	public IsNotExpression createIsNotExpression();
	public LabelStatement createLabelStatement();
	public Library createLibrary();
	public LocalVariableDeclarationStatement createLocalVariableDeclarationStatement();
	public MBCharLiteral createMBCharLiteral();
	public MemberAccess createMemberAccess();
	public MemberName createMemberName();
	public MoveStatement createMoveStatement();
	public NewExpression createNewExpression();
	public NullLiteral createNullLiteral();
	public ObjectExpression createObjectExpression();
	public ObjectExpressionEntry createObjectExpressionEntry();
	public OpenStatement createOpenStatement();
	public OpenUIStatement createOpenUIStatement();
	public Operation createOperation();
	public Parameter createParameter();
	public ParameterizableType createParameterizableType();
	public PartName createPartName();
	public TypeName createTypeName();
	public PrepareStatement createPrepareStatement();
	public PrimitiveTypeLiteral createPrimitiveTypeLiteral();
	public PrintStatement createPrintStatement();
	public Program createProgram();
	public ProgramParameter createProgramParameter();
	public QualifiedFunctionInvocation createQualifiedFunctionInvocation();
	public Record createRecord();
	public ReplaceStatement createReplaceStatement();
	public ReturnStatement createReturnStatement();
	public SequenceType createSequenceType();
	public Service createService();
	public SetStatement createSetStatement();
	public SetValuesExpression createSetValuesExpression();
	public SetValuesStatement createSetValuesStatement();
	public ShowStatement createShowStatement();
	public SizeInBytesExpression createSizeInBytesExpression();
	public SizeOfExpression createSizeOfExpression();
	public StatementBlock createStatementBlock();
	public Stereotype createStereotype();
	public StereotypeType createStereotypeType();
	public StringLiteral createStringLiteral();
	public StructPart createStructPart();
	public StructuredField createStructuredField();
	public StructuredRecord createStructuredRecord();
	public SubstringAccess createSubstringAccess();
	public SystemFunctionArgumentMnemonicName createSystemFunctionArgumentMnemonicName();
	public TernaryExpression createTernaryExpression();
	public TextTypeLiteral createTextTypeLiteral();
	public ThisExpression createThisExpression();
	public ThrowStatement createThrowStatement();
	public TimestampType createTimestampType();
	public TopLevelFunctionName createTopLevelFunctionName();
	public TransferStatement createTransferStatement();
	public TryStatement createTryStatement();
	public TypeParameter createTypeParameter();
	public UnaryExpression createUnaryExpression();
	public VariableFormField createVariableFormField();
	public WhenClause createWhenClause();
	public WhileStatement createWhileStatement();
}
