/*******************************************************************************
 * Copyright © 2008, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_VAR
//
// Guidelines for defining Rich UI messages:  
// (1) DO NOT change the variable, "egl.eze$$rscBundles["RuiMessages"]"
// (2) The general format of a message is:
//          'MessageId'  :   'Message Text: {n}'
// (3) 'MessageId' (eg: CRRUI2007E) is composed of 4 parts:
//        - the first 5 characters is product identification, must be 'CRRUI'  
//        - the sixth character is a digit which identifies the component:
//                '0' -  Others       ( used to be 'E' )
//                '1' -  Widget       ( used to be 'I' )
//                '2' -  Runtime      ( used to be 'R' )
//                '3' -  Service      ( used to be 'S' )
//        - the 7th to 9th characters identifies message number, eg: '001'
//        - the 10th character identifies the message type:
//                'E' - error message
//                'I' - informational message
//                'W' - warning message
// (5)The message text may contain 1 or more message inserts, 
//         eg: {n},  where n is a 0 based number
// (6)Insert the message in alphabetical and numeric sort order  
//    against the MessageId to avoid conflicts which can be 
//    difficult to track at runtime            
//
egl.eze$$rscBundles["RuiMessages"] =
{
		'CRRUI0001E' : '\u0627\u0633\u0645 InitalUI[{0}]InitialUI \u062e\u0627\u0644\u064a. \u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0627\u0644\u0648\u0638\u064a\u0641\u0629 \u0644\u0627\u0639\u062f\u0627\u062f \u0627\u0644\u0627\u0633\u0645 \u0644\u0644\u0628\u062f\u0621.',		
		'CRRUI0006E' : '\u062a\u062d\u062a\u0648\u064a \u0645\u062c\u0645\u0648\u0639\u0629 {0} RadioGroup \u0639\u0644\u0649 \u0645\u062a\u063a\u064a\u0631 \u0645\u0633\u062a\u0642\u0644 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d.',
					
		'CRRUI1001E' : '\u0628\u0627\u0644\u0646\u0633\u0628\u0629 \u0644\u0644\u0645\u062a\u063a\u064a\u0631 {0}\u060c \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062d\u062f\u064a\u062f {1} \u0627\u0644\u0649 {2}',
		'CRRUI1010E' : '\u0648\u0638\u0627\u0626\u0641 \u0627\u0644\u0633\u062d\u0628 \u0648\u0627\u0644\u0648\u0636\u0639 \u062a\u0639\u062f \u0645\u0631\u0627\u062c\u0639 \u0644\u0644\u0648\u0638\u064a\u0641\u0629\u060c \u0648\u0644\u064a\u0633\u062a \u0645\u0635\u0641\u0648\u0641\u0627\u062a: {0}',
		'CRRUI1020E' : 'Runtime.asDictionary: \u064a\u0645\u0643\u0646 \u062a\u062d\u0648\u064a\u0644 \u0628\u0631\u0627\u0645\u062c \u0627\u0644\u0645\u0639\u0627\u0644\u062c\u0629 \u0623\u0648 \u0627\u0644\u0633\u062c\u0644\u0627\u062a \u0627\u0644\u0649 Dictionaries \u0641\u0642\u0637\u060c \u0648\u0644\u064a\u0633 {0}',
		'CRRUI1030E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u064a\u062c\u0627\u062f \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0649 {0}.{1}',
		'CRRUI1050E' : '\u064a\u062c\u0628 \u0623\u0646 \u064a\u062a\u0636\u0645\u0646 \u0627\u0644\u0645\u062a\u063a\u064a\u0631 {0} \u0627\u0644\u0643\u0644\u0645\u0629 \"null\".',
		'CRRUI1051E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0636\u0627\u0641\u0629 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0627\u0644\u0649 \u0627\u0644\u0645\u062a\u063a\u064a\u0631 {0}.',
		'CRRUI1055E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0636\u0627\u0641\u0629 \u0627\u0644\u0639\u0646\u0635\u0631 \u0627\u0644\u0641\u0631\u0639\u064a {1} \u0627\u0644\u0649 \u0627\u0644\u0645\u062a\u063a\u064a\u0631 {2}.',		
		'CRRUI1057E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0636\u0627\u0641\u0629 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 {0} \u0627\u0644\u0649 \u0646\u0641\u0633\u0647.',	
		'CRRUI1058E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0636\u0627\u0641\u0629 \u0627\u0644\u0639\u0646\u0635\u0631 \u0627\u0644\u0623\u0635\u0644\u064a \u0627\u0644\u0645\u062a\u0641\u0631\u0639 {1} \u0627\u0644\u0649 \u0627\u0644\u0645\u062a\u063a\u064a\u0631 {0}. \u064a\u0639\u062f {2} \u0647\u0648 \u0627\u0644\u0639\u0646\u0635\u0631 \u0627\u0644\u0623\u0635\u0644\u064a \u0627\u0644\u0645\u062a\u0641\u0631\u0639 \u0627\u0644\u062d\u0627\u0644\u064a.',
		'CRRUI1060E' : '\u064a\u062a\u0645 \u0645\u062d\u0627\u0648\u0644\u0629 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0639\u0646\u0635\u0631 \u0627\u0644\u0631\u0626\u064a\u0633\u064a \u0644\u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \"{0}\" \u0627\u0644\u0649 {1}:{2}\u061b \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0639\u0646\u0635\u0631 \u0627\u0644\u0631\u0626\u064a\u0633\u064a \u0647\u0648 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u062a\u0639\u0627\u0645\u0644',
		'CRRUI1070E' : '\u062d\u062f\u062b \u0627\u0644\u062e\u0637\u0623 \u0627\u0644\u0627\u0633\u062a\u062b\u0646\u0627\u0626\u064a {0} \u0623\u062b\u0646\u0627\u0621 \u062a\u0634\u063a\u064a\u0644 \u0648\u0638\u064a\u0641\u0629 \u0627\u0644\u0627\u0633\u062a\u062f\u0639\u0627\u0621. \u0627\u0633\u062a\u062e\u062f\u0645  try...OnException.',
		'CRRUI1071E' : '\u0644\u0645 \u064a\u062a\u0645 \u0627\u064a\u062c\u0627\u062f \u0623\u064a\u0629 \u0648\u062d\u062f\u0629 \u0644\u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0623\u062e\u0637\u0627\u0621 \u0627\u0644\u0627\u0633\u062a\u062b\u0646\u0627\u0626\u064a\u0629 \u0644\u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0627\u0644\u062e\u062f\u0645\u0629.  \u0642\u0645 \u0628\u0627\u0636\u0627\u0641\u0629 \u0628\u0631\u0646\u0627\u0645\u062c \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0623\u062e\u0637\u0627\u0621 \u0627\u0644\u0627\u0633\u062a\u062b\u0646\u0627\u0626\u064a\u0629 \u0644\u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0627\u0644\u062e\u062f\u0645\u0629.',
		'CRRUI1072E' : '\u062d\u062f\u062b \u0627\u0644\u062e\u0637\u0623 \u0627\u0644\u0627\u0633\u062a\u062b\u0646\u0627\u0626\u064a {0} \u0641\u064a \u0648\u0638\u064a\u0641\u0629 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u063a\u064a\u0631 \u0627\u0644\u0635\u062d\u064a\u062d\u0629\u060c \u0628\u0627\u0644\u0643\u0648\u062f \u0630\u0648 try...OnException',		
		'CRRUI1080E' : '\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0639\u0644\u0649 \u0623\u064a \u0639\u0646\u0635\u0631 \u200f\u200eDocument Object Model \u200e(DOM)\u200e\u200f \u0648\u0647\u0648 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0628\u0627\u0644\u0648\u062b\u064a\u0642\u0629.<br>\u0627\u0644\u062e\u0635\u0627\u0626\u0635 \u0627\u0644\u0645\u0645\u064a\u0632\u0629 \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u0644\u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0647\u0630\u0627 \u0647\u064a:<P>{0}',
		'CRRUI1083E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0645\u0639\u0627\u0644\u062c\u0629 \u062d\u062f\u062b \u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u0627\u0633\u062a\u0639\u0631\u0627\u0636 {0}.',
		'CRRUI1150E' : '\u062a\u0645 \u0627\u062c\u0631\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u0644\u0627\u0632\u0627\u0644\u0629 \"null\" \u0645\u0646 \u0645\u062a\u063a\u064a\u0631 {0}.',		
		'CRRUI1151E' : '\u062a\u0645 \u0627\u062c\u0631\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u0644\u0627\u0632\u0627\u0644\u0629 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0627\u0644\u0630\u064a \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u064a \u0639\u0646\u0635\u0631 \u200f\u200eDocument Object Model \u200e(DOM)\u200e\u200f \u0645\u0646 \u0645\u062a\u063a\u064a\u0631 {0}.',		
		'CRRUI1155E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0632\u0627\u0644\u0629 \u0627\u0644\u0639\u0646\u0635\u0631 \u0627\u0644\u0641\u0631\u0639\u064a \u0644\u0644\u0646\u0648\u0639 {1} \u0645\u0646 \u0645\u062a\u063a\u064a\u0631 {0}: {2}.',
		'CRRUI1157E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0632\u0627\u0644\u0629 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0645\u0646 \u0646\u0641\u0633\u0647. \u0646\u0648\u0639 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 \u0647\u0648 {0}.',
			
		'CRRUI2002E' : '{1}<br>\u062d\u062f\u062b \u062e\u0637\u0623 \u0641\u064a {0}: {2}',
		'CRRUI2004E' : '\u064a\u062d\u062a\u0648\u064a \u0627\u0644\u0633\u062c\u0644 \u0627\u0644\u062a\u0627\u0631\u064a\u062e\u064a {0} \u0639\u0644\u0649 \u0645\u062a\u063a\u064a\u0631 \u0645\u0633\u062a\u0642\u0644 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d.',
		'CRRUI2005E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u0631\u062c\u0639 \u0639\u062f\u064a\u0645 \u0627\u0644\u0642\u064a\u0645\u0629.',
		'CRRUI2006E' : '{0}', // The text of this message comes from some other error message.
		'CRRUI2007E' : '\u0645\u062a\u063a\u064a\u0631 \u0645\u0633\u062a\u0642\u0644 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d: {0}.',
		'CRRUI2009E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u0643\u0648\u064a\u0646 \u0646\u0633\u062e\u0629 \u0645\u0646 \u0627\u0644\u062d\u062f\u062b \u0645\u0646 \u0628\u0631\u0646\u0627\u0645\u062c \u0645\u0639\u0627\u0644\u062c\u0629 RUI.',
		'CRRUI2010E' : '\u0648\u0638\u064a\u0641\u0629 \u0645\u062a\u0642\u0627\u062f\u0645\u0629: {0}.',
		
		'CRRUI2015E' : '\u0627\u0644\u0645\u0644\u0641 {0} \u0627\u0644\u0649 RUIPropertiesLibrary {1} \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f',
		'CRRUI2016E' : '\u064a\u0633\u062a\u063a\u0631\u0642 \u062a\u0634\u063a\u064a\u0644 \u0628\u0631\u0646\u0627\u0645\u062c EGL \u0648\u0642\u062a \u0637\u0648\u064a\u0644',
		'CRRUI2017E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062d\u0648\u064a\u0644 \u0627\u0644\u0642\u064a\u0645\u0629 \"{0}\" \u0644\u0644\u0646\u0648\u0639 {1} \u0627\u0644\u0649 \u0627\u0644\u0646\u0648\u0639 {2}',
		'CRRUI2018E' : '\u064a\u062d\u062f\u062b \u062a\u062c\u0627\u0648\u0632 \u0639\u0646 \u062a\u062e\u0635\u064a\u0635 {0} \u0627\u0644\u0649 \u0627\u0644\u0646\u0648\u0639 {1}',
		'CRRUI2019E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0644\u062d\u0627\u0642 \u0627\u0644\u0639\u0646\u0635\u0631 {1} \u0627\u0644\u0649 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629. \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u062d\u062c\u0645 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629 \u0647\u0648 {1}.',
		'CRRUI2020E' : '\u0645\u062a\u063a\u064a\u0631 \u0645\u0633\u062a\u0642\u0644 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d {0} \u0644\u0648\u0638\u064a\u0641\u0629 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629\u060c setMaxSize()',
		'CRRUI2021E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u0631\u062c\u0627\u0639 \u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0645\u0645\u064a\u0632 \u0627\u0644\u062a\u0627\u0644\u064a \u0645\u0646 \u0645\u062c\u0645\u0648\u0639\u0629 \u0627\u0644\u062d\u0631\u0648\u0641 \u0627\u0644\u062a\u064a \u062a\u0628\u062f\u0623 \u0628\u0627\u0644\u0641\u0647\u0631\u0633 {0}',
		'CRRUI2022E' : '\u0627\u0644\u0641\u0647\u0631\u0633 {0} \u062e\u0627\u0631\u062c \u062d\u062f\u0648\u062f \u0647\u0630\u0647 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629. \u062d\u062c\u0645 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629 \u0647\u0648 {1}.',
		'CRRUI2023E' : '\u062a\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0645\u0631\u062c\u0639 \u0639\u062f\u064a\u0645 \u0627\u0644\u0642\u064a\u0645\u0629: {0}',
		'CRRUI2024E' : '\u0627\u0645\u0643\u0627\u0646\u064a\u0629 \u0627\u0644\u062a\u0648\u0635\u0644 \u0627\u0644\u062f\u064a\u0646\u0627\u0645\u064a\u0643\u064a\u0629 \u0627\u0644\u0649 \u0627\u0644\u0645\u0641\u062a\u0627\u062d \"{0}\" \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 \u0628\u0627\u0644\u0639\u0646\u0635\u0631 \u0630\u0648 \u0627\u0644\u0646\u0648\u0639 {1}',
		'CRRUI2025E' : '\u0641\u0634\u0644\u062a \u0627\u0645\u0643\u0627\u0646\u064a\u0629 \u0627\u0644\u062a\u0648\u0635\u0644 \u0627\u0644\u062f\u064a\u0646\u0627\u0645\u064a\u0643\u064a\u0629: \u0644\u0627 \u064a\u0648\u062c\u062f \u0645\u0641\u062a\u0627\u062d \u0628\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0645\u060c \"{0}\"',
		'CRRUI2030E' : '\u0645\u062a\u063a\u064a\u0631 \u0645\u0633\u062a\u0642\u0644 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d \u0627\u0644\u0649 XMLLib.convertFromXML. \u064a\u062a\u0648\u0642\u0639 \u0645\u062c\u0645\u0648\u0639\u0629 \u062d\u0631\u0648\u0641\u060c \u0648\u062a\u0645 \u0627\u0633\u062a\u0644\u0627\u0645 \"{0}\"',
		'CRRUI2031E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0627\u062c\u0631\u0627\u0621 \u062a\u062d\u0644\u064a\u0644 \u0644\u063a\u0648\u064a\u0627 \u0627\u0644\u0649 XML: {0}',
		'CRRUI2032E' : '\u0646\u0645\u0648\u0630\u062c \u062e\u0627\u062a\u0645 \u0627\u0644\u0648\u0642\u062a {0} \u063a\u064a\u0631 \u0635\u062d\u064a\u062d',
		'CRRUI2033E' : '\u0627\u0644\u0642\u064a\u0645\u0629 {0} \u0627\u0644\u0645\u062d\u062f\u062f\u0629 \u0644\u0648\u0638\u064a\u0641\u0629 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629\u060c resize()\u060c \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u062d\u062c\u0645 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629\u060c {1}',
		'CRRUI2034E' : '\u0627\u0644\u0646\u0648\u0639\u060c {0}\u060c \u0644\u0639\u0646\u0635\u0631 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d',
		'CRRUI2035E' : '\u0639\u062f\u062f \u0627\u0644\u0623\u0628\u0639\u0627\u062f \u0627\u0644\u062a\u064a \u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u062d\u062c\u0645\u0647\u0627 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0639\u062f\u062f \u0623\u0628\u0639\u0627\u062f \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629',
		'CRRUI2036E' : '\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0646\u0637\u0627\u0642 \u0639\u0646\u062f \u0627\u0633\u062a\u062f\u0639\u0627\u0621 {0}: \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u062a\u063a\u064a\u0631 \u0627\u0644\u0645\u0633\u062a\u0642\u0644 \u0628\u064a\u0646 {1} \u0648 {2}',
		'CRRUI2037E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: \u0644\u0627 \u064a\u0645\u0643\u0646 \u0642\u0633\u0645 \u0627\u0644\u0631\u0642\u0645 \u0639\u0644\u0649 0',
		'CRRUI2038E' : '\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0646\u0637\u0627\u0642 \u0639\u0646\u062f \u0627\u0633\u062a\u062f\u0639\u0627\u0621 {0}: \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u062a\u063a\u064a\u0631 \u0627\u0644\u0645\u0633\u062a\u0642\u0644 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0635\u0641\u0631',
		'CRRUI2039E' : '\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0646\u0637\u0627\u0642 \u0639\u0646\u062f \u0627\u0633\u062a\u062f\u0639\u0627\u0621 {0}: \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u062a\u063a\u064a\u0631 \u0627\u0644\u0645\u0633\u062a\u0642\u0644 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0635\u0641\u0631 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a \u0635\u0641',
		'CRRUI2040E' : '\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0646\u0637\u0627\u0642 \u0639\u0646\u062f \u0627\u0633\u062a\u062f\u0639\u0627\u0621 {0}: \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0622\u0633 \u0644\u0644\u0623\u0633\u0627\u0633 \u0635\u0641\u0631 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0635\u0641\u0631',
		'CRRUI2041E' : '\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u0646\u0637\u0627\u0642 \u0639\u0646\u062f \u0627\u0633\u062a\u062f\u0639\u0627\u0621 {0}: \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0622\u0633 \u0644\u0623\u0633\u0627\u0633 \u0633\u0627\u0644\u0628 \u0639\u0628\u0627\u0631\u0629 \u0639\u0646 \u0631\u0642\u0645 \u0635\u062d\u064a\u062d',
		'CRRUI2042E' : '\u0641\u0647\u0627\u0631\u0633 \u0645\u062c\u0645\u0648\u0639\u0629 \u062d\u0631\u0648\u0641 \u0641\u0631\u0639\u064a\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 {0}:{1}.',
		'CRRUI2050E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: abs() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 0 \u0623\u0648 1',
		'CRRUI2051E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: add() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2052E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: compareTo() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2053E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: divide() - \u0627\u0644\u0645\u0642\u064a\u0627\u0633 \u0627\u0644\u0633\u0627\u0644\u0628\u060c {0}\u060c \u063a\u064a\u0631 \u0635\u062d\u064a\u062d',
		'CRRUI2054E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: divide() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 \u0645\u0627 \u0628\u064a\u0646 1 \u0623\u0648 3',
		'CRRUI2055E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: divideInteger() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2056E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: max() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2057E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: min() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2058E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: multiply() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2059E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: negate() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 0 \u0623\u0648 1',
		'CRRUI2060E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: plus() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 0 \u0623\u0648 1',
		'CRRUI2061E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: pow() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2062E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: pow() - \u0622\u0633 \u0633\u0627\u0644\u0628\u060c {0}',
		'CRRUI2063E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: pow() - \u0623\u0631\u0642\u0627\u0645 \u0643\u062b\u064a\u0631\u0629 \u062c\u062f\u0627\u060c {0}',
		'CRRUI2064E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: remainder() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2065E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: subtract() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2066E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: format() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 2 \u0623\u0648 6',
		'CRRUI2067E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: format() - \u062a\u062c\u0627\u0648\u0632 \u0627\u0644\u0623\u0633\u060c {0}',
		'CRRUI2068E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: intValueExact() - \u0627\u0644\u062c\u0632\u0621 \u0627\u0644\u0639\u0634\u0631\u064a \u063a\u064a\u0631 \u0635\u0641\u0631\u064a\u060c {0}',
		'CRRUI2069E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: intValueExact() - \u062d\u062f\u062b \u062a\u062c\u0627\u0648\u0632 \u0641\u064a \u0627\u0644\u062a\u062d\u0648\u064a\u0644\u060c {0}',
		'CRRUI2070E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: setScale() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2071E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: setScale() - \u0645\u0642\u064a\u0627\u0633 \u0633\u0627\u0644\u0628\u060c {0}',
		'CRRUI2072E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: intCheck() - \u062d\u062f\u062b \u062a\u062c\u0627\u0648\u0632 \u0641\u064a \u0627\u0644\u062a\u062d\u0648\u064a\u0644\u060c {0}',
		'CRRUI2073E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: dodivide() - \u062d\u062f\u062b \u062a\u062c\u0627\u0648\u0632 \u0644\u0644\u0631\u0642\u0645 \u0627\u0644\u0635\u062d\u064a\u062d',
		'CRRUI2074E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062d\u0648\u064a\u0644 \u0645\u062c\u0645\u0648\u0639\u0629 \u0627\u0644\u062d\u0631\u0648\u0641 \"{1}\" \u0627\u0644\u0649 \u0631\u0642\u0645',
		'CRRUI2075E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: \u0631\u0642\u0645 \u0627\u0644\u0645\u062a\u063a\u064a\u0631 \u0627\u0644\u0645\u0633\u062a\u0642\u0644 {0} \u0644\u0644\u0637\u0631\u064a\u0642\u0629 {1} \u063a\u064a\u0631 \u0635\u062d\u064a\u062d. \u0627\u0644\u0645\u062a\u063a\u064a\u0631 \u0627\u0644\u0645\u0633\u062a\u0642\u0644 \u0627\u0644\u0645\u062a\u0627\u062d \u0647\u0648 {2}',
		'CRRUI2076E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: \u064a\u0648\u062c\u062f \u0639\u062f\u062f \u0643\u0628\u064a\u0631 \u062c\u062f\u0627 \u0645\u0646 \u0627\u0644\u0623\u0631\u0642\u0627\u0645 - {0}',
		'CRRUI2077E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: round() - \u062a\u0645 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 {0}. \u064a\u062a\u0648\u0642\u0639 1 \u0623\u0648 2',
		'CRRUI2078E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: round() - \u064a\u062a\u0637\u0644\u0628 \u0627\u0644\u062a\u0642\u0631\u064a\u0628',
		'CRRUI2079E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: round() - \u0642\u064a\u0645\u0629 \u062a\u0642\u0631\u064a\u0628 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629\u060c {0}',
		'CRRUI2080E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: round() - \u062d\u062f\u062b \u062a\u062c\u0627\u0648\u0632 \u0644\u0644\u0623\u0633\u060c {0}',
		'CRRUI2081E' : '\u062e\u0637\u0623 \u062d\u0633\u0627\u0628\u064a: finish() - \u062d\u062f\u062b \u062a\u062c\u0627\u0648\u0632 \u0644\u0644\u0623\u0633\u060c {0}',
		'CRRUI2082E' : '\u062e\u0637\u0623 \u062f\u0627\u062e\u0644\u064a: \u0623\u062b\u0646\u0627\u0621 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0648\u062d\u062f\u0629 \u062a\u0643\u0648\u064a\u0646 {0}.',
		'CRRUI2083E' : '\u062e\u0637\u0623 \u062f\u0627\u062e\u0644\u064a: \u062d\u062f\u062b\u062a \u0645\u0634\u0643\u0644\u0629 \u0623\u062b\u0646\u0627\u0621 \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0641\u0626\u0629 {0}',
		'CRRUI2084E' : '\u062e\u0637\u0623 \u062f\u0627\u062e\u0644\u064a: \u0623\u062b\u0646\u0627\u0621 \u062a\u0639\u0631\u064a\u0641 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 {0}.{1} \u0643\u0641\u0626\u0629 \u0641\u0631\u0639\u064a\u0629 \u0627\u0644\u0649 egl.ui.rui.RUIPropertiesLibrary',
		'CRRUI2085E' : '\u062e\u0637\u0623 \u062f\u0627\u062e\u0644\u064a: \u0623\u062b\u0646\u0627\u0621 \u062a\u0639\u0631\u064a\u0641 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u0627\u0644\u062a\u0639\u0627\u0645\u0644 {0}.{1} \u0643\u0641\u0626\u0629 \u0641\u0631\u0639\u064a\u0629 \u0627\u0644\u0649 {2}.{3}',
		'CRRUI2086E' : '\u062e\u0637\u0623 \u062f\u0627\u062e\u0644\u064a: \u062d\u062f\u062b\u062a \u0645\u0634\u0643\u0644\u0629 \u0623\u062b\u0646\u0627\u0621 \u062a\u0639\u0631\u064a\u0641 \u0628\u0631\u0646\u0627\u0645\u062c \u0645\u0639\u0627\u0644\u062c\u0629 RUI \u200f{0}',
		'CRRUI2087E' : '\u062e\u0637\u0623 \u062f\u0627\u062e\u0644\u064a: \u062d\u062f\u062b\u062a \u0645\u0634\u0643\u0644\u0629 \u0623\u062b\u0646\u0627\u0621 \u062a\u0639\u0631\u064a\u0641 \u0639\u0646\u0635\u0631 \u0648\u0627\u062c\u0647\u0629 \u062a\u0639\u0627\u0645\u0644 RUI \u200f{0}',
		'CRRUI2088E' : '\u0628\u0631\u0646\u0627\u0645\u062c \u0627\u0644\u0627\u0633\u062a\u0639\u0631\u0627\u0636 \u0647\u0630\u0627 \u063a\u064a\u0631 \u0645\u062f\u0639\u0645 \u0628\u0648\u0627\u0633\u0637\u0629 EGL Rich UI',
		'CRRUI2089E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0644\u062a\u062d\u0648\u064a\u0644 \u0645\u0646 \u0627\u0644\u0646\u0633\u0642 JSON: \u200f"{0}"\u060c \u0628\u0633\u0628\u0628 {1}',
		'CRRUI2090E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0627\u0644\u062e\u062f\u0645\u0629: {0}',
		'CRRUI2091E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0631\u0633\u0627\u0644 \u062d\u062f\u062b \u0627\u0644\u0649 Eclipse IDE: \u200f{0}',
		'CRRUI2092E' : '\u062e\u0637\u0623 \u062f\u0627\u062e\u0644\u064a: \u062d\u062f\u062b\u062a \u0645\u0634\u0643\u0644\u0629 \u0623\u062b\u0646\u0627\u0621 \u0645\u0639\u0627\u0644\u062c\u0629 \u062d\u062f\u062b IDE \u200f{0}',
		'CRRUI2093E' : '\u062e\u0637\u0623 \u062f\u0627\u062e\u0644\u064a: \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u0648\u062c\u064a\u0647 \u0627\u0644\u0648\u0638\u064a\u0641\u0629 {0}.',
		'CRRUI2094E' : '\u0641\u064a\u0645\u0627 \u064a\u0644\u064a \u0639\u0645\u0644\u064a\u0627\u062a \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0648\u0638\u064a\u0641\u0629 EGL \u0627\u0644\u062a\u064a \u0623\u062f\u062a \u0627\u0644\u0649 \u062d\u062f\u0648\u062b \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623:',
		'CRRUI2095E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u064a\u062c\u0627\u062f \u0627\u0633\u062a\u062f\u0639\u0627\u0621\u0627\u062a \u0648\u0638\u064a\u0641\u0629 EGL \u0627\u0644\u062a\u064a \u062a\u0624\u062f\u064a \u0627\u0644\u0649 \u0647\u0630\u0627 \u0627\u0644\u062e\u0637\u0623',
		'CRRUI2097E' : '\u0642\u064a\u0645\u0629 \u0646\u0645\u0637 CSS \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 "{1}" \u0644\u0644\u062e\u0627\u0635\u064a\u0629 \u0627\u0644\u0645\u0645\u064a\u0632\u0629 {0}',
		'CRRUI2097E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u062c\u0631\u0627\u0621 \u062a\u062d\u0644\u064a\u0644 \u0644\u063a\u0648\u064a \u0628\u0637\u0631\u064a\u0642\u0629 \u0635\u062d\u064a\u062d\u0629 \u0644\u0646\u0645\u0637 CSS \u200f{0}. \u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0635\u064a\u063a\u0629\u060c \u0623\u0648 \u0627\u0633\u062a\u062e\u062f\u0645 \u0635\u0641\u062d\u0629 \u0623\u0646\u0645\u0627\u0637 \u062e\u0627\u0631\u062c\u064a\u0629.',
		'CRRUI2098E' : '\u062d\u062f\u062b\u062a \u0623\u062e\u0637\u0627\u0621 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u0633\u062d\u0628 \u0648\u0627\u0644\u0648\u0636\u0639: {0}',
		'CRRUI2099E' : '\u0641\u064a Rich UI\u060c \u0639\u0645\u0644\u064a\u0629 EGL "set" \u063a\u064a\u0631 \u0645\u062f\u0639\u0645\u0629 \u0628\u0627\u0644\u0646\u0648\u0639 {0}',
		'CRRUI2100E' : '\u0645\u062a\u063a\u064a\u0631 \u0645\u0633\u062a\u0642\u0644 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d \u0627\u0644\u0649 RuiLib.convertFromXML. \u064a\u062a\u0648\u0642\u0639 \u0645\u062c\u0645\u0648\u0639\u0629 \u062d\u0631\u0648\u0641. \u0648\u062a\u0645 \u0627\u0633\u062a\u0644\u0627\u0645 \u0639\u0646\u0635\u0631 \u0628\u0627\u0644\u0646\u0648\u0639 {0}',
		'CRRUI2101E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u064a\u062c\u0627\u062f indexOf "{1}" \u062f\u0627\u062e\u0644 "{0}" \u0628\u0633\u0628\u0628 {2}',
		'CRRUI2102E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0641\u0631\u0632 \u0627\u0644\u0645\u0635\u0641\u0648\u0641\u0629',
		'CRRUI2103E' : '\u0627\u0645\u0643\u0627\u0646\u064a\u0629 \u062a\u0648\u0635\u0644 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 \u0627\u0644\u0649 "{0}" \u0641\u064a \u0627\u0644\u0639\u0646\u0635\u0631 \u0628\u0627\u0644\u0646\u0648\u0639 "{1}" \u0628\u0633\u0628\u0628 {2}',
		'CRRUI2104E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u062c\u0631\u0627\u0621 \u062a\u062d\u0644\u064a\u0644 \u0644\u063a\u0648\u064a \u0644\u0639\u0628\u0627\u0631\u0629 JSON \u200f"{0}"',
		'CRRUI2105E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0627\u062c\u0631\u0627\u0621 \u062a\u062d\u0644\u064a\u0644 \u0644\u063a\u0648\u064a \u0627\u0644\u0649 JSON \u0623\u062b\u0646\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u062a\u062d\u062f\u064a\u062f \u200f{0}. \u0627\u0644\u0645\u062c\u0627\u0644 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a \u0627\u0644\u0645\u0643\u0627\u0646 \u0627\u0644\u0645\u062a\u0648\u0642\u0639 \u0641\u064a \u0639\u0628\u0627\u0631\u0629 JSON.',
		'CRRUI2106E' : '\u0641\u0634\u0644\u062a \u0645\u062d\u0627\u0648\u0644\u0629 \u062a\u062d\u062f\u064a\u062f {0} \u0628\u0642\u064a\u0645\u0629 \u0635\u0641\u0631\u064a\u0629 \u0623\u062b\u0646\u0627\u0621 \u0627\u062c\u0631\u0627\u0621 \u062a\u062d\u0644\u064a\u0644 \u0644\u063a\u0648\u064a \u0627\u0644\u0649 JSON \u0644\u0623\u0646\u0647 \u0644\u0645 \u064a\u062a\u0645 \u062a\u0648\u0636\u064a\u062d\u0647 \u0643\u0645\u062c\u0627\u0644 \u064a\u0645\u0643\u0646 \u062a\u062d\u062f\u064a\u062f \u0642\u064a\u0645\u0629 \u0635\u0641\u0631\u064a\u0629 \u0644\u0647.',
		'CRRUI2107E' : '\u064a\u062a\u0645 \u062a\u0646\u0641\u064a\u0630 \u0648\u0638\u0627\u0626\u0641 \u062a\u062d\u0648\u064a\u0644 JSON \u0644\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 \u0639\u0644\u0649 \u0633\u062c\u0644 \u0623\u0648 \u0642\u0627\u0645\u0648\u0633. \u0644\u0627 \u064a\u0639\u062f {0} \u0646\u0648\u0639 \u0635\u062d\u064a\u062d.',
		'CRRUI2108E' : '\u064a\u062a\u0645 \u062a\u0634\u063a\u064a\u0644 \u0648\u0638\u0627\u0626\u0641 \u062a\u062d\u0648\u064a\u0644 XML \u0644\u0645\u0643\u062a\u0628\u0629 XML \u0639\u0644\u0649 \u0633\u062c\u0644. \u0644\u0627 \u064a\u062a\u0645 \u062f\u0639\u0645 \u0627\u0644\u0646\u0648\u0639 {0}.',
		
		'CRRUI2111E' : '\u062e\u0637\u0623 \u0641\u064a MathContext(): \u0639\u062f\u062f \u0627\u0644\u0645\u062a\u063a\u064a\u0631\u0627\u062a \u0627\u0644\u0645\u0633\u062a\u0642\u0644\u0629 \u0627\u0644\u0645\u062d\u062f\u062f\u060c {0}\u060c \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u061b \u064a\u062a\u0648\u0642\u0639 \u0645\u0646 1 \u0627\u0644\u0649 4.',
		'CRRUI2112E' : '\u062e\u0637\u0623 \u0641\u064a MathContext(): \u0639\u062f\u062f \u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u062d\u062f\u062f\u060c {0}\u060c \u0635\u063a\u064a\u0631 \u062c\u062f\u0627.',
		'CRRUI2113E' : '\u062e\u0637\u0623 \u0641\u064a MathContext(): \u0639\u062f\u062f \u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0627\u0644\u0645\u062d\u062f\u062f\u060c {0}\u060c \u0643\u0628\u064a\u0631 \u062c\u062f\u0627.',
		'CRRUI2114E' : '\u062e\u0637\u0623 \u0641\u064a MathContext(): \u0642\u064a\u0645\u0629 \u0627\u0644\u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0645\u062d\u062f\u062f\u0629\u060c {0}\u060c \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.',
		'CRRUI2115E' : '\u062e\u0637\u0623 \u0641\u064a MathContext(): \u0642\u064a\u0645\u0629 \u0646\u0645\u0637 \u0627\u0644\u062a\u0642\u0631\u064a\u0628 \u0627\u0644\u0645\u062d\u062f\u062f\u0629\u060c {0}\u060c \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.',
		
	    'CRRUI2700E' : '\u0644\u0645 \u064a\u062a\u0645 \u0627\u0633\u062a\u0644\u0627\u0645 \u0623\u064a\u0629 \u0645\u062f\u062e\u0644\u0627\u062a \u0644\u0644\u0645\u062c\u0627\u0644 \u0627\u0644\u0645\u0637\u0644\u0648\u0628 - \u0642\u0645 \u0628\u0627\u0644\u0627\u062f\u062e\u0627\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.',
		'CRRUI2702E' : '\u062e\u0637\u0623 \u0641\u064a \u0646\u0648\u0639 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0641\u064a \u0627\u0644\u0645\u062f\u062e\u0644\u0627\u062a - \u0642\u0645 \u0628\u0627\u0644\u0627\u062f\u062e\u0627\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.',
		'CRRUI2703E' : '\u062a\u0645 \u062a\u0639\u062f\u064a \u0639\u062f\u062f \u0627\u0644\u0623\u0631\u0642\u0627\u0645 \u0630\u0627\u062a \u0627\u0644\u0623\u0647\u0645\u064a\u0629 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627 - \u0642\u0645 \u0628\u0627\u0644\u0627\u062f\u062e\u0627\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.',
		'CRRUI2704E' : '\u0627\u0644\u0645\u062f\u062e\u0644\u0627\u062a \u0644\u064a\u0633\u062a \u0641\u064a \u0627\u0644\u0645\u062f\u0649 \u0627\u0644\u0630\u064a \u062a\u0645 \u062a\u0639\u0631\u064a\u0641\u0647 \u0627\u0644\u0649 \u0648\u0647\u0648 \u0645\u0646 {0} \u0627\u0644\u0649 {1} - \u0642\u0645 \u0628\u0627\u0644\u0627\u062f\u062e\u0627\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.',
		'CRRUI2705E' : '\u062e\u0637\u0623 \u0641\u064a \u0627\u062f\u062e\u0627\u0644 \u0627\u0644\u062d\u062f \u0627\u0644\u0623\u062f\u0646\u0649 \u0644\u0644\u0637\u0648\u0644 - \u0642\u0645 \u0628\u0627\u0644\u0627\u062f\u062e\u0627\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.',
		'CRRUI2707E' : '\u062e\u0637\u0623 \u0641\u064a \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0645\u0639\u0627\u0645\u0644 \u0639\u0646\u062f \u0627\u0644\u0627\u062f\u062e\u0627\u0644 - \u0642\u0645 \u0628\u0627\u0644\u0627\u062f\u062e\u0627\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.',
		'CRRUI2708E' : '\u0627\u0644\u0645\u062f\u062e\u0644\u0627\u062a \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 \u0644\u0646\u0633\u0642 \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0623\u0648 \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u0630\u064a \u062a\u0645 \u062a\u0639\u0631\u064a\u0641\u0647 {0}.',
		'CRRUI2710E' : '\u0627\u0644\u0645\u062f\u062e\u0644\u0627\u062a \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 \u0644\u0644\u0645\u062c\u0627\u0644 \u0627\u0644\u0628\u0648\u0648\u0644\u064a.',
		'CRRUI2712E' : '\u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a \u0627\u0644\u0633\u062f\u0627\u0633\u064a \u0639\u0634\u0631\u064a\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.',
		'CRRUI2713E' : '\u0627\u0644\u0642\u064a\u0645\u0629 \u0627\u0644\u062a\u064a \u062a\u0645 \u0627\u062f\u062e\u0627\u0644\u0647\u0627 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629 \u0644\u0623\u0646\u0647\u0627 \u063a\u064a\u0631 \u0645\u0637\u0627\u0628\u0642\u0629 \u0644\u0644\u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0630\u064a \u062a\u0645 \u062a\u062d\u062f\u064a\u062f\u0647.',		
		'CRRUI2716E' : '\u0627\u0644\u0645\u062f\u062e\u0644\u0627\u062a \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629 \u0641\u064a \u0643\u0634\u0641 \u0627\u0644\u0642\u064a\u0645 \u0627\u0644\u0635\u062d\u064a\u062d\u0629 \u0627\u0644\u062a\u064a \u062a\u0645 \u062a\u0639\u0631\u064a\u0641\u0647\u0627. \u0642\u0645 \u0628\u0627\u0644\u0627\u062f\u062e\u0627\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649.',
		'CRRUI2717E' : '\u0646\u0633\u0642 \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0648\u0627\u0644\u0648\u0642\u062a \u0627\u0644\u0645\u062d\u062f\u062f \u0627\u0644\u0649 {0} \u063a\u064a\u0631 \u0635\u062d\u064a\u062d.',	
		'CRRUI2719E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0627\u062c\u0631\u0627\u0621 \u062a\u062d\u0644\u064a\u0644 \u0644\u063a\u0648\u064a \u0644\u0644\u0645\u062f\u062e\u0644\u0627\u062a.',

		'CRRUI3650E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u064a\u062c\u0627\u062f \u0645\u0644\u0641 \u0645\u0648\u0635\u0641 \u0627\u0644\u0646\u0634\u0631: \'{0}\'',
		'CRRUI3651E' : '\u0645\u0641\u062a\u0627\u062d \u0631\u0628\u0637 \u0627\u0644\u062e\u062f\u0645\u0629: \'{0}\' \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a \u0645\u0648\u0635\u0641 \u0627\u0644\u0646\u0634\u0631  \'{1}\'',
		'CRRUI3652E' : '\u0646\u0648\u0639 \u0631\u0628\u0637 \u062e\u062f\u0645\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d \'{0}\'\u060c \u064a\u062a\u0648\u0642\u0639 \u0646\u0648\u0639 \u0627\u0644\u0631\u0628\u0637 \'{1}\'',
		'CRRUI3653E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u062e\u062f\u0645\u0629 \u0627\u0644\u0627\u0631\u062c\u0627\u0639 \u0639\u0644\u0649 \'{0}\'',
		'CRRUI3654E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u0628\u0646\u0627\u0621 \u0639\u0646\u0635\u0631 \u0627\u0644\u0637\u0644\u0628: \'{0}\'',
		'CRRUI3655E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062a\u0634\u063a\u064a\u0644 \u0639\u0646\u0635\u0631 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629: \'{0}\'',
		'CRRUI3656E' : '\'formdata\' \u063a\u064a\u0631 \u0645\u062f\u0639\u0645 \u0643\u0646\u0633\u0642 \u0627\u0633\u062a\u062c\u0627\u0628\u0629',
		'CRRUI3657E' : '\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u064a\u062c\u0627\u062f proxy \u0641\u064a \'{0}\' \u0644\u0627\u062c\u0631\u0627\u0621 \u0639\u0645\u0644\u064a\u0627\u062a \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0627\u0644\u062e\u062f\u0645\u0629',
		'CRRUI3658E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0641\u064a proxy \u0639\u0644\u0649 \'{0}\' \u0623\u062b\u0646\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0627\u0644\u062e\u062f\u0645\u0629 \u0639\u0644\u0649  \'{1}\'',
		'CRRUI3659E' : '\u0623\u062f\u062a \u0639\u0645\u0644\u064a\u0629 \u0627\u062c\u0631\u0627\u0621 \u062a\u062d\u0644\u064a\u0644 \u0644\u063a\u0648\u064a \u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0627\u062a Json \u0627\u0644\u0649 \u0627\u0631\u062c\u0627\u0639 \u0642\u064a\u0645 \u0635\u0641\u0631\u064a\u0629\u060c \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0623\u0635\u0644\u064a\u0629 \u0647\u064a: \'{0}\'',
		'CRRUI3660E' : '\u062d\u062f\u062b \u062e\u0637\u0623 \u0627\u0633\u062a\u062b\u0646\u0627\u0626\u064a\u060c \u0644\u0627 \u064a\u0645\u0643\u0646 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0649  \'{0}\'\u060c \u0627\u0644\u0633\u0628\u0628: \'{1}\'',
		'CRRUI3661E' : '\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0631\u0628\u0637 \u0627\u0644\u062e\u062f\u0645\u0629 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629 \u0627\u0644\u0649 \'{0}\' \u0623\u062b\u0646\u0627\u0621 \u0645\u062d\u0627\u0648\u0644\u0629 \u0627\u0633\u062a\u062f\u0639\u0627\u0621 \u0648\u0638\u064a\u0641\u0629 \u0627\u0644\u062e\u062f\u0645\u0629 \'{1}\'.'
};

