/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.testserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.internal.testserver.HotCodeReplaceListener;
import org.eclipse.edt.ide.testserver.AbstractTestServerContribution;
import org.eclipse.edt.ide.testserver.ClasspathUtil;
import org.eclipse.edt.ide.testserver.SocketUtil;
import org.eclipse.edt.ide.testserver.TestServer;
import org.eclipse.edt.ide.testserver.TestServerIDEConnector;
import org.eclipse.edt.ide.testserver.TestServerMessages;
import org.eclipse.edt.ide.testserver.TestServerPlugin;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;

public class TestServerConfiguration
implements IDebugEventSetListener,
IResourceChangeListener,
IPropertyChangeListener {
    public static final int DEFAULT_PORT = 9701;
    public static final String TEST_SERVER_CONFIG_TYPE_ID = "org.eclipse.edt.ide.testserver.testServerLaunchType";
    private IProject project;
    private boolean debugMode;
    private int port;
    private boolean started;
    private ILaunch launch;
    private List<TerminationListener> terminationListeners;
    private String[] latestCheckedClasspath;

    public TestServerConfiguration(IProject project, boolean debugMode) {
        this(project, debugMode, -1);
    }

    public TestServerConfiguration(IProject project, boolean debugMode, int port) {
        this.project = project;
        this.debugMode = debugMode;
        this.port = port;
        AbstractTestServerContribution[] abstractTestServerContributionArray = TestServerPlugin.getContributions();
        int n = abstractTestServerContributionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTestServerContribution contrib = abstractTestServerContributionArray[n2];
            contrib.init(this);
            ++n2;
        }
    }

    public synchronized void start(IProgressMonitor monitor, boolean waitForServerToStart) throws CoreException {
        if (this.started) {
            return;
        }
        try {
            AbstractTestServerContribution contrib;
            if (!this.project.hasNature("org.eclipse.jdt.core.javanature")) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.edt.ide.testserver", NLS.bind((String)TestServerMessages.ProjectMissingJavaNature, (Object)this.project.getName())));
            }
            if (this.port < 0) {
                this.port = SocketUtil.findOpenPort(9701, 5, 100);
                SocketUtil.reservePort(this.port);
            }
            AbstractTestServerContribution[] contributions = TestServerPlugin.getContributions();
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(TEST_SERVER_CONFIG_TYPE_ID);
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, NLS.bind((String)TestServerMessages.TestServerProcessName, (Object[])new Object[]{this.project.getName(), this.port}));
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.project.getName());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, TestServer.class.getCanonicalName());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            List classpath = copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList(10));
            ClasspathUtil.buildClasspath(this, classpath);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpath);
            StringBuilder args = new StringBuilder(100);
            args.append(copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""));
            args.append(" -p ");
            args.append(this.port);
            args.append(" -i ");
            args.append(TestServerIDEConnector.getInstance().getPortNumber());
            args.append(" -c \"/");
            args.append(this.project.getName());
            args.append("\"");
            if (TestServerPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.edt.ide.testserver.EnableDebug")) {
                args.append(" -d");
            }
            HashSet<String> configuratorClasses = new HashSet<String>(10);
            AbstractTestServerContribution[] abstractTestServerContributionArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                contrib = abstractTestServerContributionArray[n2];
                String[] classes = contrib.getConfiguratorClassNames(this);
                if (classes != null && classes.length > 0) {
                    String[] stringArray = classes;
                    int n3 = classes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String clazz = stringArray[n4];
                        configuratorClasses.add(clazz);
                        ++n4;
                    }
                }
                ++n2;
            }
            if (configuratorClasses.size() > 0) {
                args.append(" -contribs ");
                boolean first = true;
                for (String clazz : configuratorClasses) {
                    if (!first) {
                        args.append(':');
                    }
                    args.append(clazz);
                }
            }
            abstractTestServerContributionArray = contributions;
            n = contributions.length;
            int n5 = 0;
            while (n5 < n) {
                contrib = abstractTestServerContributionArray[n5];
                String extraArgs = contrib.getArgumentAdditions(this);
                if (extraArgs != null) {
                    args.append(extraArgs);
                }
                ++n5;
            }
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args.toString());
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            this.launch = copy.launch(this.debugMode ? "debug" : "run", monitor);
            this.latestCheckedClasspath = ClasspathUtil.resolveClasspath(this.launch.getLaunchConfiguration());
            if (waitForServerToStart) {
                int i = 0;
                while (i < 240) {
                    try {
                        if (this.invokeServlet("default", "") == 200) {
                            this.started = true;
                            break;
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
                if (!this.started) {
                    try {
                        this.terminate();
                    }
                    catch (DebugException debugException) {}
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.edt.ide.testserver", NLS.bind((String)TestServerMessages.PingFailed, (Object[])new Object[]{this.project.getName(), String.valueOf(this.port)})));
                }
            }
            abstractTestServerContributionArray = this.launch.getDebugTargets();
            n = abstractTestServerContributionArray.length;
            n5 = 0;
            while (n5 < n) {
                AbstractTestServerContribution target = abstractTestServerContributionArray[n5];
                IJavaDebugTarget javaTarget = (IJavaDebugTarget)target.getAdapter(IJavaDebugTarget.class);
                if (javaTarget != null) {
                    javaTarget.addHotCodeReplaceListener((IJavaHotCodeReplaceListener)new HotCodeReplaceListener(this));
                }
                ++n5;
            }
            TestServerPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.edt.ide.testserver", e.getMessage(), (Throwable)e));
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public IProject getProject() {
        return this.project;
    }

    public int getPort() {
        return this.port;
    }

    public void terminate() throws DebugException {
        if (this.launch != null) {
            this.launch.terminate();
        }
    }

    public void addTerminationListener(TerminationListener listener) {
        if (this.terminationListeners == null) {
            this.terminationListeners = new ArrayList<TerminationListener>();
        }
        this.terminationListeners.add(listener);
    }

    public void removeTerminationListener(TerminationListener listener) {
        if (this.terminationListeners != null) {
            this.terminationListeners.remove(listener);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        TestServerPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        SocketUtil.freePort(this.port);
        if (this.terminationListeners != null) {
            for (TerminationListener listener : this.terminationListeners) {
                listener.terminated(this);
            }
        }
        AbstractTestServerContribution[] abstractTestServerContributionArray = TestServerPlugin.getContributions();
        int n = abstractTestServerContributionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTestServerContribution contrib = abstractTestServerContributionArray[n2];
            contrib.dispose(this);
            ++n2;
        }
        this.project = null;
        this.launch = null;
        this.started = false;
        this.terminationListeners = null;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (!this.started) {
            return;
        }
        if (events == null || events.length == 0) {
            return;
        }
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch;
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8 && event.getSource() instanceof IAdaptable && (launch = (ILaunch)((IAdaptable)event.getSource()).getAdapter(ILaunch.class)) == this.launch) {
                IProcess[] iProcessArray = launch.getProcesses();
                int n3 = iProcessArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    if (process.isTerminated()) {
                        this.dispose();
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!this.started) {
            return;
        }
        if ("org.eclipse.edt.ide.testserver.EnableDebug".equals(event.getProperty())) {
            try {
                int status = this.invokeServlet("default", "debug=" + event.getNewValue());
                if (status != 200) {
                    TestServerPlugin.getDefault().log(NLS.bind((String)TestServerMessages.DefaultServletBadStatus, (Object[])new Object[]{status, this.project.getName()}));
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.started) {
            return;
        }
        AbstractTestServerContribution[] abstractTestServerContributionArray = TestServerPlugin.getContributions();
        int n = abstractTestServerContributionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTestServerContribution contrib = abstractTestServerContributionArray[n2];
            contrib.resourceChanged(event, this);
            ++n2;
        }
    }

    public int invokeServlet(String servletPath, String args) throws IOException {
        String projectName = this.project.getName();
        try {
            projectName = URLEncoder.encode(projectName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        URLConnection conn = new URL("http://localhost:" + this.port + "/" + projectName + "/" + servletPath).openConnection();
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(args.getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        return ((HttpURLConnection)conn).getResponseCode();
    }

    public boolean isOnEGLPath(IProject project) {
        return this.isOnEGLPath(this.project, project, new HashSet<IProject>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOnEGLPath(IProject currProject, IProject deltaProject, Set<IProject> seen) {
        if (seen.contains(currProject)) {
            return false;
        }
        seen.add(currProject);
        if (currProject.equals((Object)deltaProject)) {
            return true;
        }
        try {
            if (!currProject.hasNature("org.eclipse.edt.ide.core.eglnature")) return false;
            IEGLProject eglProject = EGLCore.create((IProject)currProject);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
            int n = iEGLPathEntryArray.length;
            int n2 = 0;
            while (true) {
                IResource resource;
                if (n2 >= n) {
                    return false;
                }
                IEGLPathEntry entry = iEGLPathEntryArray[n2];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) != null && resource.getType() == 4 && resource.isAccessible() && this.isOnEGLPath((IProject)resource, deltaProject, seen)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (EGLModelException e) {
            TestServerPlugin.getDefault().log((Exception)((Object)e));
            return false;
        }
        catch (CoreException e) {
            TestServerPlugin.getDefault().log((Exception)((Object)e));
        }
        return false;
    }

    public boolean hasClasspathChanged() {
        if (!this.started || this.launch == null || this.launch.getLaunchConfiguration() == null) {
            return false;
        }
        boolean result = false;
        try {
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, "ezeTemp");
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.project.getName());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            List newClasspath = copy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList(10));
            ClasspathUtil.buildClasspath(this, newClasspath);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, newClasspath);
            Object[] newResolvedClasspath = ClasspathUtil.resolveClasspath((ILaunchConfiguration)copy);
            result = !Arrays.equals(this.latestCheckedClasspath, newResolvedClasspath);
            this.latestCheckedClasspath = newResolvedClasspath;
        }
        catch (CoreException coreException) {}
        return result;
    }

    public String toString() {
        return "Test server: project=" + (this.project == null ? "null" : this.project.getName()) + ", port=" + this.port + ", started=" + this.started;
    }

    public static interface TerminationListener {
        public void terminated(TestServerConfiguration var1);
    }
}

