/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.tools.IRLoader;
import org.eclipse.edt.gen.CommandOption;
import org.eclipse.edt.gen.CommandProcessor;
import org.eclipse.edt.gen.GenerationContributor;
import org.eclipse.edt.gen.GenerationRegistry;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.LoadPartException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public abstract class AbstractGeneratorCommand
extends CommandProcessor
implements GenerationRegistry {
    private String templates = "";
    private String nativeTypes = "";
    private String primitiveTypes = "";
    private String EGLMessages = "";

    public AbstractGeneratorCommand() {
        this.installParameter(true, "output", new String[]{"output", "out", "o"}, new String[1], "Output must identify the location to write the output");
        this.installParameter(true, "part", new String[]{"part", "p"}, new String[1], "Part must identify the part to be generated, which can contain an * for all matching parts");
        this.installParameter(true, "root", new String[]{"root", "r"}, new String[1], "Root must identify the root location to be used in generation");
        this.installParameter(true, "contribution", new String[]{"contribution", "c"}, new Object[1], "Contribution must identify the contribution classes used in generation");
    }

    public String getTemplates() {
        String[] templateList;
        String[] stringArray = templateList = this.getTemplatePath().toArray(new String[this.getTemplatePath().size()]);
        int n = templateList.length;
        int n2 = 0;
        while (n2 < n) {
            String template = stringArray[n2];
            this.templates = String.valueOf(this.templates) + template + ";";
            ++n2;
        }
        return this.templates;
    }

    public String getNativeTypes() {
        String[] nativeTypeList;
        String[] stringArray = nativeTypeList = this.getNativeTypePath().toArray(new String[this.getNativeTypePath().size()]);
        int n = nativeTypeList.length;
        int n2 = 0;
        while (n2 < n) {
            String nativeType = stringArray[n2];
            this.nativeTypes = String.valueOf(this.nativeTypes) + nativeType + ";";
            ++n2;
        }
        return this.nativeTypes;
    }

    public String getPrimitiveTypes() {
        String[] primitiveTypeList;
        String[] stringArray = primitiveTypeList = this.getPrimitiveTypePath().toArray(new String[this.getPrimitiveTypePath().size()]);
        int n = primitiveTypeList.length;
        int n2 = 0;
        while (n2 < n) {
            String primitiveType = stringArray[n2];
            this.primitiveTypes = String.valueOf(this.primitiveTypes) + primitiveType + ";";
            ++n2;
        }
        return this.primitiveTypes;
    }

    public String getEGLMessages() {
        String[] EGLMessageList;
        String[] stringArray = EGLMessageList = this.getMessagePath().toArray(new String[this.getMessagePath().size()]);
        int n = EGLMessageList.length;
        int n2 = 0;
        while (n2 < n) {
            String EGLMessage2 = stringArray[n2];
            this.EGLMessages = String.valueOf(this.EGLMessages) + EGLMessage2 + ";";
            ++n2;
        }
        return this.EGLMessages;
    }

    public void generate(String[] args, Generator generator, IEnvironment environment, ICompiler compiler) {
        if (this.initialize(args, generator)) {
            try {
                block12: {
                    if (environment != null) {
                        Environment.pushEnv((IEnvironment)environment);
                        generator.getContext().setEnvironment(environment);
                    }
                    try {
                        List<Part> parts = this.loadEGLParts(compiler);
                        for (Part part : parts) {
                            generator.generate(part);
                            try {
                                if (generator.getResult() instanceof String && ((String)generator.getResult()).length() > 0) {
                                    this.writeFile(part, generator);
                                }
                                this.writeAuxiliaryFiles(part, generator);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (generator == null) break block12;
                        System.out.print(generator.getResult());
                    }
                }
                generator.dumpErrorMessages();
            }
            finally {
                if (environment != null) {
                    Environment.popEnv();
                }
            }
        }
    }

    protected boolean initialize(String[] args, Generator generator) {
        if (this.processBase(args)) {
            Object[] contributions;
            Object[] objectArray = contributions = (Object[])this.getParameter("contribution").getValue();
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                Object contribution = objectArray[n2];
                try {
                    Class<?> clazz = Class.forName((String)contribution, true, this.getClass().getClassLoader());
                    GenerationContributor contributor = (GenerationContributor)clazz.newInstance();
                    contributor.contribute(this);
                }
                catch (Exception x) {
                    System.out.println("Exception: " + x.getMessage());
                    System.out.println("Unable to load: " + contribution + ". Generation aborted.");
                    return false;
                }
                ++n2;
            }
            if (this.processUser(args)) {
                generator.initialize(this);
                return true;
            }
        }
        return false;
    }

    private void listAllFiles(File parent, List<File> files, String pattern) {
        if (parent.isDirectory()) {
            File[] children;
            File[] fileArray = children = parent.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile() && (child.getName().toLowerCase(Locale.ENGLISH).endsWith(".eglxml") || child.getName().toLowerCase(Locale.ENGLISH).endsWith(".ir"))) {
                    String name = child.getPath();
                    int prefixLength = pattern.indexOf("*");
                    if (name.length() >= prefixLength && name.substring(0, prefixLength).equalsIgnoreCase(pattern.substring(0, prefixLength)) && (pattern.length() <= prefixLength + 1 || name.toLowerCase(Locale.ENGLISH).endsWith(String.valueOf(pattern.substring(prefixLength + 1)) + ".eglxml") || name.toLowerCase(Locale.ENGLISH).endsWith(String.valueOf(pattern.substring(prefixLength + 1)) + ".ir"))) {
                        files.add(child);
                    }
                }
                this.listAllFiles(child, files, pattern);
                ++n2;
            }
        }
    }

    protected List<Part> loadEGLParts(ICompiler compiler) throws LoadPartException {
        ArrayList<Part> parts = new ArrayList<Part>();
        String rootName = (String)this.getParameter("root").getValue();
        String partName = (String)this.getParameter("part").getValue();
        if (partName.indexOf("*") >= 0) {
            String totalName = rootName.endsWith(File.separator) ? rootName : String.valueOf(rootName) + File.separator;
            totalName = partName.startsWith(File.separator) ? String.valueOf(totalName) + partName.substring(File.separator.length()) : String.valueOf(totalName) + partName;
            totalName = totalName.replace('\\', File.separatorChar);
            totalName = totalName.replace('/', File.separatorChar);
            totalName = totalName.replace('.', File.separatorChar);
            File irRootDirFile = new File(rootName);
            ArrayList<File> irfiles = new ArrayList<File>();
            this.listAllFiles(irRootDirFile, irfiles, totalName);
            for (File irfile : irfiles) {
                String irFileRelativePath = irfile.getAbsolutePath().substring(irRootDirFile.getAbsolutePath().length());
                if (irFileRelativePath.startsWith(File.separator)) {
                    irFileRelativePath = irFileRelativePath.substring(File.separator.length());
                }
                parts.add(IRLoader.loadEGLPart((String)rootName, (String)irFileRelativePath.substring(0, irFileRelativePath.lastIndexOf(".")).replace(File.separatorChar, '.'), null));
            }
        } else {
            parts.add(IRLoader.loadEGLPart((String)rootName, (String)partName, (ICompiler)compiler));
        }
        return parts;
    }

    protected void writeFile(Part part, Generator generator) throws Exception {
        int offset;
        String fileName = ((String)this.getParameter("output").getValue()).replaceAll("\\\\", "/");
        if (!fileName.endsWith("/")) {
            fileName = String.valueOf(fileName) + "/";
        }
        if ((offset = (fileName = String.valueOf(fileName) + generator.getRelativeFileName(part)).lastIndexOf("/")) > 0) {
            new File(fileName.substring(0, offset)).mkdirs();
        }
        FileWriter writer = new FileWriter(fileName);
        writer.write(generator.getResult().toString());
        writer.close();
        generator.processFile(fileName);
    }

    protected void writeAuxiliaryFiles(Part part, Generator generator) throws Exception {
    }

    @Override
    public void registerCommandOptions(CommandOption[] options) {
        CommandOption[] commandOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            CommandOption option = commandOptionArray[n2];
            this.installParameter(option.getParameter().isRequired(), option.getInternalName(), option.getAliases(), option.getParameter().getPossibleValues(), option.getParameter().getPromptText());
            ++n2;
        }
    }

    @Override
    public void registerTemplatePath(String[] paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.getTemplatePath().add(path);
            ++n2;
        }
    }

    @Override
    public void registerNativeTypePath(String[] paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.getNativeTypePath().add(path);
            ++n2;
        }
    }

    @Override
    public void registerPrimitiveTypePath(String[] paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.getPrimitiveTypePath().add(path);
            ++n2;
        }
    }

    @Override
    public void registerMessagePath(String[] paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.getMessagePath().add(path);
            ++n2;
        }
    }
}

